/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.importer.word;

import com.aspose.words.Document;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.BranchType;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddBranchAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.BeginModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.EndModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.RunFullLayoutAction;
import com.thinkbuzan.gaia.editor.actions.SetLayoutEnabledAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.Notes;
import com.thinkbuzan.gaia.importer.word.license.AsposeLicenser;
import com.thinkbuzan.gaia.importer.word.resources.ResourceManager;
import com.thinkbuzan.gaia.importmanager.IImporter;
import com.thinkbuzan.gaia.importmanager.IImporterListener;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WordImporter
implements IImporter {
    private transient int progressCount = 0;
    private transient int currentProgress = 0;
    private transient Paragraph floatingIdeaParagraph;
    private transient mmFloatingIdeaCell floatingIdea;
    private transient IImporterListener listener;
    private transient Paragraph lastTitleHeadingParagraph;
    private transient Paragraph previousLastTitleHeadingParagraph;
    private final transient Map<Paragraph, Paragraph> paragraphParentMap = new HashMap<Paragraph, Paragraph>();
    private final transient Map<Paragraph, mmIStructureCell> paragraphCellMap = new HashMap<Paragraph, mmIStructureCell>();
    private final transient List<Paragraph> notesParagraphs = new ArrayList<Paragraph>();
    private static final transient char NEW_LINE_CHARACTER = '\n';
    private static final transient char RETURN_CHARACTER = '\r';
    private static final Logger LOGGER = Logger.getLogger(WordImporter.class);
    private static String LABEL;
    private static String DESCRIPTION;
    private static final List<String> EXTENSIONS;
    private static final String UNTITLED_PARAGRAPH_TEXT = "Untitled";
    private static String ERROR_MESSAGE;
    private static I18n i18n;

    public WordImporter(I18n i18nIn) {
        i18n = i18nIn;
        LABEL = i18n.getLocalizedText("com.thinkbuzan.i18n.wordimporter.import");
        DESCRIPTION = i18n.getLocalizedText("com.thinkbuzan.i18n.wordimporter.files");
        ERROR_MESSAGE = i18n.getLocalizedText("com.thinkbuzan.i18n.wordimporter.error");
    }

    public void importFile(File file, IEditorComponent editorComponent, IImporterListener importerListener) {
        this.validateImportImpl(file, editorComponent, importerListener);
        try {
            editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(false));
            editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
            AsposeLicenser.getInstance().setAsposeLicense();
            this.clearState();
            this.listener = importerListener;
            NodeCollection<Paragraph> paragraphs = this.getNodeCollection(file);
            this.initProgress(paragraphs);
            this.processParagraphs(editorComponent, file, paragraphs);
            if (this.floatingIdea == null) {
                this.addFloatingIdeaFromFileName(editorComponent, file);
                this.processNotesParagraphs(editorComponent, (mmIStructureCell)this.floatingIdea);
            }
            editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
            editorComponent.runAction((AbstractEditorAction)new SetLayoutEnabledAction(true));
            editorComponent.runAction((AbstractEditorAction)new RunFullLayoutAction());
        }
        catch (Exception exception) {
            importerListener.importErrorOccurred(ERROR_MESSAGE);
        }
    }

    private void addFloatingIdeaFromFileName(IEditorComponent editorComponent, File file) {
        String fileName;
        int lastIndexOfDot;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Adding floating idea from File[%s]...", file));
        }
        String text = (lastIndexOfDot = (fileName = file.getName()).lastIndexOf(".")) == -1 ? fileName : fileName.substring(0, lastIndexOfDot);
        this.floatingIdea = (mmFloatingIdeaCell)editorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(text));
        this.processNotesParagraphs(editorComponent, (mmIStructureCell)this.floatingIdea);
    }

    private void addFloatingIdeaFromParagraph(IEditorComponent editorComponent, Paragraph paragraph) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Adding floating idea from Paragraph[%s]...", paragraph.getText()));
        }
        this.floatingIdeaParagraph = this.lastTitleHeadingParagraph;
        this.paragraphParentMap.put(this.lastTitleHeadingParagraph, null);
        String text = this.getText(this.lastTitleHeadingParagraph);
        this.floatingIdea = (mmFloatingIdeaCell)editorComponent.runAction((AbstractEditorAction)new AddFloatingIdeaAction(text));
        this.paragraphCellMap.put(this.lastTitleHeadingParagraph, (mmIStructureCell)this.floatingIdea);
        this.previousLastTitleHeadingParagraph = this.lastTitleHeadingParagraph;
        this.processNotesParagraphs(editorComponent, (mmIStructureCell)this.floatingIdea);
    }

    private void clearState() {
        this.progressCount = 0;
        this.currentProgress = 0;
        this.paragraphCellMap.clear();
        this.paragraphParentMap.clear();
        this.notesParagraphs.clear();
        this.floatingIdeaParagraph = null;
        this.listener = null;
        this.previousLastTitleHeadingParagraph = null;
        this.lastTitleHeadingParagraph = null;
        this.floatingIdea = null;
    }

    private void validateImportImpl(File file, IEditorComponent editorComponent, IImporterListener importerListener) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (editorComponent == null) {
            throw new IllegalArgumentException("editorComponent must not be null");
        }
        if (importerListener == null) {
            throw new IllegalArgumentException("importerListener must not be null");
        }
    }

    private NodeCollection<Paragraph> getNodeCollection(File file) {
        NodeCollection paragraphs = null;
        try {
            Document doc = new Document((InputStream)new FileInputStream(file));
            paragraphs = doc.getChildNodes(8, true);
        }
        catch (Exception exception) {
            LOGGER.debug((Object)String.format("Caught Exception when attempting to parse Word document (%s)using Aspose.Words", file.getName()), (Throwable)exception);
            throw new RuntimeException();
        }
        return paragraphs;
    }

    private void initProgress(NodeCollection<Paragraph> paragraphs) {
        this.progressCount = 0;
        this.currentProgress = 0;
        if (null != paragraphs) {
            this.progressCount = paragraphs.getCount();
        }
    }

    private void processParagraphs(IEditorComponent editorComponent, File file, NodeCollection<Paragraph> paragraphs) {
        int i;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Going to process %s Paragraphs:", paragraphs.getCount()));
            for (i = 0; i < paragraphs.getCount(); ++i) {
                LOGGER.debug((Object)String.format("%s: \"%s\"", i, ((Paragraph)paragraphs.get(i)).getText()));
            }
        }
        for (i = 0; i < paragraphs.getCount(); ++i) {
            this.processParagraph(editorComponent, file, (Paragraph)paragraphs.get(i));
        }
        if (this.lastTitleHeadingParagraph != null) {
            this.processLastTitleHeadingParagraph(editorComponent, file);
        }
    }

    private void processParagraph(IEditorComponent editorComponent, File file, Paragraph paragraph) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Processing Paragraph[\"%s\"]...", paragraph.getText()));
        }
        if (this.isTitleOrHeading(paragraph)) {
            if (this.lastTitleHeadingParagraph != null) {
                this.processLastTitleHeadingParagraph(editorComponent, file);
            }
            this.lastTitleHeadingParagraph = paragraph;
        } else {
            this.notesParagraphs.add(paragraph);
        }
        this.updateImportProgress();
    }

    private void processLastTitleHeadingParagraph(IEditorComponent editorComponent, File file) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("processLastTitleHeadingParagraph Paragraph[\"%s\"]...", this.lastTitleHeadingParagraph.getText()));
        }
        if (this.isTitle(this.lastTitleHeadingParagraph)) {
            if (this.floatingIdea == null) {
                this.addFloatingIdeaFromParagraph(editorComponent, this.lastTitleHeadingParagraph);
            }
        } else {
            if (this.floatingIdea == null) {
                this.addFloatingIdeaFromFileName(editorComponent, file);
            }
            this.addBranchFromParagraph(editorComponent);
        }
    }

    private void addBranchFromParagraph(IEditorComponent editorComponent) {
        Paragraph parentParagraph = this.getParentParagraph(this.lastTitleHeadingParagraph, this.previousLastTitleHeadingParagraph);
        this.paragraphParentMap.put(this.lastTitleHeadingParagraph, parentParagraph);
        Object parentCell = parentParagraph == null ? this.floatingIdea : this.paragraphCellMap.get(parentParagraph);
        String text = this.getText(this.lastTitleHeadingParagraph);
        mmBranchCell branch = (mmBranchCell)editorComponent.runAction((AbstractEditorAction)new AddBranchAction((mmIStructureCell)parentCell, BranchType.BRANCH, text));
        this.paragraphCellMap.put(this.lastTitleHeadingParagraph, (mmIStructureCell)branch);
        this.previousLastTitleHeadingParagraph = this.lastTitleHeadingParagraph;
        this.processNotesParagraphs(editorComponent, (mmIStructureCell)branch);
    }

    private void processNotesParagraphs(IEditorComponent editorComponent, mmIStructureCell cell) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Processing notesParagraphs list (size = %s)...", this.notesParagraphs.size()));
        }
        if (!this.notesParagraphs.isEmpty()) {
            StringBuffer stringNotes = new StringBuffer();
            for (Paragraph notesParagraph : this.notesParagraphs) {
                stringNotes.append(this.getText(notesParagraph));
                stringNotes.append('\n');
            }
            editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)cell, "com.thinkbuzan.gaia.cell.notes", (IProperty)new Notes(stringNotes.toString())));
            this.notesParagraphs.clear();
        }
    }

    private String getText(Paragraph paragraph) {
        char lastChar;
        String text = paragraph.getText().trim();
        if (text.length() > 0 && (lastChar = text.charAt(text.length() - 1)) == '\r') {
            text = text.substring(0, text.length() - 1);
        }
        if (text.length() == 0) {
            text = UNTITLED_PARAGRAPH_TEXT;
        }
        return text;
    }

    private Paragraph getParentParagraph(Paragraph paragraph, Paragraph previousParagraph) {
        boolean styleIdentifierIsGood;
        if (previousParagraph == null) {
            return null;
        }
        boolean previousParagraphIsFloatingIdea = previousParagraph == this.floatingIdeaParagraph;
        boolean bl = styleIdentifierIsGood = this.getStyleIdentifier(paragraph) > this.getStyleIdentifier(previousParagraph);
        if (previousParagraphIsFloatingIdea || styleIdentifierIsGood) {
            return previousParagraph;
        }
        Paragraph nextParent = this.paragraphParentMap.get(previousParagraph);
        return this.getParentParagraph(paragraph, nextParent);
    }

    private void updateImportProgress() {
        if (0 == this.progressCount) {
            float finishProgess = 100.0f;
            this.listener.importProgress(100.0f);
            return;
        }
        ++this.currentProgress;
        float progress = (float)this.currentProgress * 1.0f / (float)this.progressCount;
        float tempNum = 100.0f;
        progress = Math.round(progress * 100.0f);
        this.listener.importProgress(progress);
    }

    private boolean isHeading(Paragraph paragraph) {
        try {
            String styleName = paragraph.getParagraphFormat().getStyle().getName().toUpperCase();
            boolean containsText = !"".equals(paragraph.getText().trim());
            boolean formatIsHeading = paragraph.getParagraphFormat().isHeading();
            boolean styleNameContainsHeading = styleName.contains("HEADING");
            int styleIdentifier = this.getStyleIdentifier(paragraph);
            boolean styleIdentifierMatches = 1 <= styleIdentifier && styleIdentifier <= 9;
            boolean isHeading = containsText & (formatIsHeading || styleNameContainsHeading || styleIdentifierMatches);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("isHeading(Paragraph[\"%s\"]) returning %s", paragraph.getText(), isHeading));
            }
            return isHeading;
        }
        catch (Exception exception) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Caught Exception when checking if a Paragraph is a heading", (Throwable)exception);
            }
            return false;
        }
    }

    private boolean isTitle(Paragraph paragraph) {
        try {
            String styleName = paragraph.getParagraphFormat().getStyle().getName().toUpperCase();
            boolean containsText = !"".equals(paragraph.getText().trim());
            boolean styleNameContainsTitle = styleName.contains("TITLE");
            int styleIdentifier = this.getStyleIdentifier(paragraph);
            boolean styleIdentifierMatches = styleIdentifier == 62;
            boolean isTitle = containsText & (styleNameContainsTitle || styleIdentifierMatches);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("isTitle(Paragraph[\"%s\"]) returning %s", paragraph.getText(), isTitle));
            }
            return isTitle;
        }
        catch (Exception exception) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Caught Exception when checking if a Paragraph is a title", (Throwable)exception);
            }
            return false;
        }
    }

    private boolean isTitleOrHeading(Paragraph paragraph) {
        return this.isTitle(paragraph) || this.isHeading(paragraph);
    }

    private int getStyleIdentifier(Paragraph paragraph) {
        int style;
        block2: {
            style = 0;
            try {
                style = paragraph.getParagraphFormat().getStyleIdentifier();
            }
            catch (Exception exception) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info((Object)"Exception caught when invoking getStyleIdentifier()", (Throwable)exception);
            }
        }
        return style;
    }

    public Icon getIcon() {
        return new ImageIcon(ResourceManager.getResourceIcon24());
    }

    public String getId() {
        return "com.thinkbuzan.gaia.importer.word";
    }

    public String getLabel() {
        return LABEL;
    }

    public List<String> getAllowedExtensions() {
        return EXTENSIONS;
    }

    public String getFileFilterDescription() {
        return DESCRIPTION;
    }

    public boolean isVisible() {
        return true;
    }

    public String getCategory() {
        return "Document";
    }

    static {
        EXTENSIONS = Collections.unmodifiableList(Arrays.asList("doc", "docx"));
    }
}

