/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.thinkbuzan.pascal.imageservice.favourites.FavouriteImagesService;
import com.thinkbuzan.pascal.imageservice.insert.ImageInsertController;
import com.thinkbuzan.pascal.imageservice.local.LocalImageService;
import com.thinkbuzan.pascal.imageservice.local.OpenImageService;
import com.thinkbuzan.pascal.imageservice.recent.RecentImagesService;
import com.thinkbuzan.pascal.imageservice.web.WebImageService;
import com.thinkbuzan.pascal.services.images.IImageService;
import com.thinkbuzan.pascal.services.images.cached.ICachedImagesService;
import com.thinkbuzan.pascal.services.images.filter.IImageCategoryFilter;
import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.insert.IImageInsertController;
import com.thinkbuzan.pascal.services.images.listener.IImageFilterListener;
import com.thinkbuzan.pascal.services.images.listener.IImageResultsListener;
import com.thinkbuzan.pascal.services.images.listener.IImageSearchCallback;
import com.thinkbuzan.pascal.services.images.local.ILocalImageService;
import com.thinkbuzan.pascal.services.images.local.IOpenImageService;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.web.IWebImageService;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageService
implements IImageService {
    private final transient ReentrantLock resultsLock = new ReentrantLock();
    private final transient List<IImageFilterListener> filterListeners = new ArrayList<IImageFilterListener>();
    private final transient List<IImageResultsListener> resultsListeners = new ArrayList<IImageResultsListener>();
    private transient ILocalImageService localService;
    private transient IWebImageService webService;
    private transient IOpenImageService openService;
    private transient ICachedImagesService recentService;
    private transient ICachedImagesService favService;
    private transient IImageInsertController insertController;
    private transient IImageCategoryFilter categoryFilter;
    private transient IImageFilter tagFilter;
    private transient IImageSearchCallback activeCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalImageService getLocalImageService() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.localService == null) {
                this.localService = new LocalImageService();
            }
            return this.localService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWebImageService getWebImageService() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.webService == null) {
                this.webService = new WebImageService();
            }
            return this.webService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenImageService getOpenImageService() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.openService == null) {
                this.openService = new OpenImageService(this);
            }
            return this.openService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedImagesService getRecentImagesService() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.recentService == null) {
                this.recentService = new RecentImagesService(this);
            }
            return this.recentService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedImagesService getFavouriteImagesService() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.favService == null) {
                this.favService = new FavouriteImagesService(this);
            }
            return this.favService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImageInsertController getInsertController() {
        ImageService imageService = this;
        synchronized (imageService) {
            if (this.insertController == null) {
                this.insertController = new ImageInsertController(this);
            }
            return this.insertController;
        }
    }

    public void refreshImages() {
        this.updateResults(false);
    }

    public void setCategoryFilter(IImageCategoryFilter filter) {
        this.categoryFilter = filter;
        this.fireFilterChanged();
        this.updateResults(false);
    }

    public IImageCategoryFilter getImageCategoryFilter() {
        return this.categoryFilter;
    }

    public void setTagFilter(IImageFilter filter) {
        this.tagFilter = filter;
        this.fireFilterChanged();
        this.updateResults(true);
    }

    public IImageFilter getTagFilter() {
        return this.tagFilter;
    }

    public void addFilterChangeListener(IImageFilterListener listener) {
        if (listener != null) {
            this.filterListeners.add(listener);
        }
    }

    public void removeFilterChangeListener(IImageFilterListener listener) {
        if (listener != null) {
            this.filterListeners.remove(listener);
        }
    }

    public void addImageResultsListener(IImageResultsListener listener) {
        if (listener != null) {
            this.resultsListeners.add(listener);
        }
    }

    public void removeImageResultsListener(IImageResultsListener listener) {
        if (listener != null) {
            this.resultsListeners.remove(listener);
        }
    }

    private void fireFilterChanged() {
        ArrayList<IImageFilterListener> copy = new ArrayList<IImageFilterListener>(this.filterListeners);
        for (IImageFilterListener listener : copy) {
            listener.filterChanged(this.tagFilter, this.categoryFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResults(boolean refreshWebResults) {
        this.resultsLock.lock();
        try {
            List favResults;
            boolean isSearch;
            if (refreshWebResults && this.activeCallback != null) {
                this.getWebImageService().cancelSearch();
                this.activeCallback.searchCancelled();
                this.activeCallback = null;
            }
            ArrayList<IImage> images = new ArrayList<IImage>();
            boolean isRecent = this.categoryFilter == null || this.categoryFilter.isMatch((IImageCategory)this.getRecentImagesService().getCategory());
            boolean isFavourite = this.categoryFilter == null || this.categoryFilter.isMatch((IImageCategory)this.getFavouriteImagesService().getCategory());
            boolean bl = isSearch = isRecent && isFavourite;
            if (isSearch) {
                List localResults = this.getLocalImageService().getFilteredImages(this.categoryFilter, this.tagFilter);
                if (localResults != null) {
                    this.addNonDuplicateImages(images, localResults);
                }
                if (this.categoryFilter == null || this.categoryFilter.isMatch((IImageCategory)this.getWebImageService().getWebImageCategory())) {
                    if (refreshWebResults) {
                        this.activeCallback = new ImageSearchCallback(images);
                        this.getWebImageService().search(this.tagFilter, this.activeCallback);
                    } else {
                        List webImages = this.getWebImageService().getWebImageCategory().getImages();
                        if (webImages != null) {
                            this.addNonDuplicateImages(images, webImages);
                        }
                    }
                }
            } else if (isRecent) {
                List recentResults = this.getRecentImagesService().getFilteredImages(null);
                if (recentResults != null) {
                    images.addAll(recentResults);
                }
            } else if (isFavourite && (favResults = this.getFavouriteImagesService().getFilteredImages(null)) != null) {
                images.addAll(favResults);
            }
            this.fireResultsChanged(new ArrayList<IImage>(images));
        }
        finally {
            this.resultsLock.unlock();
        }
    }

    private void fireResultsChanged(List<IImage> results) {
        ArrayList<IImageResultsListener> copy = new ArrayList<IImageResultsListener>(this.resultsListeners);
        ArrayList<IImage> copyResults = new ArrayList<IImage>(results);
        for (IImageResultsListener listener : copy) {
            listener.resultsChanged(copyResults);
        }
    }

    private void fireResultsAppended(List<IImage> appendedResults) {
        ArrayList<IImageResultsListener> copy = new ArrayList<IImageResultsListener>(this.resultsListeners);
        ArrayList<IImage> copyResults = new ArrayList<IImage>(appendedResults);
        for (IImageResultsListener listener : copy) {
            listener.resultsAppended(copyResults);
        }
    }

    private void addNonDuplicateImages(List<IImage> addTo, List<IImage> toAdd) {
        this.addNonDuplicateImages(addTo, addTo, toAdd);
    }

    private void addNonDuplicateImages(List<IImage> checkContains, List<IImage> addTo, List<IImage> toAdd) {
        if (checkContains != null && addTo != null && toAdd != null) {
            if (checkContains.isEmpty()) {
                addTo.addAll(toAdd);
            } else {
                for (IImage image : toAdd) {
                    if (checkContains.contains(image)) continue;
                    addTo.add(image);
                }
            }
        }
    }

    public static ImageInformation readImageInformation(File imageFile) throws IOException, MetadataException, ImageProcessingException {
        Metadata metadata = ImageMetadataReader.readMetadata((File)imageFile);
        Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
        JpegDirectory jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class);
        int orientation = 1;
        try {
            orientation = directory.getInt(274);
        }
        catch (MetadataException me) {
            // empty catch block
        }
        int width = jpegDirectory.getImageWidth();
        int height = jpegDirectory.getImageHeight();
        return new ImageInformation(orientation, width, height);
    }

    public static AffineTransform getExifTransformation(ImageInformation info) {
        AffineTransform t = new AffineTransform();
        switch (info.orientation) {
            case 1: {
                break;
            }
            case 2: {
                t.scale(-1.0, 1.0);
                t.translate(-info.width, 0.0);
                break;
            }
            case 3: {
                t.translate(info.width, info.height);
                t.rotate(Math.PI);
                break;
            }
            case 4: {
                t.scale(1.0, -1.0);
                t.translate(0.0, -info.height);
                break;
            }
            case 5: {
                t.rotate(-1.5707963267948966);
                t.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                t.translate(info.height, 0.0);
                t.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                t.scale(-1.0, 1.0);
                t.translate(-info.height, 0.0);
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
                break;
            }
            case 8: {
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
            }
        }
        return t;
    }

    public static BufferedImage transformImage(BufferedImage image, AffineTransform transform) throws Exception {
        AffineTransformOp op = new AffineTransformOp(transform, 3);
        BufferedImage destinationImage = op.createCompatibleDestImage(image, image.getType() == 10 ? image.getColorModel() : null);
        Graphics2D g = destinationImage.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, destinationImage.getWidth(), destinationImage.getHeight());
        destinationImage = op.filter(image, destinationImage);
        image.flush();
        image = null;
        g.dispose();
        return destinationImage;
    }

    public static BufferedImage getImageTransformedForExif(BufferedImage src, String filename) throws Exception {
        File f = new File(filename);
        ImageInformation info = ImageService.readImageInformation(f);
        AffineTransform transform = ImageService.getExifTransformation(info);
        BufferedImage dst = ImageService.transformImage(src, transform);
        src.flush();
        src = null;
        return dst;
    }

    public static class ImageInformation {
        public final int orientation;
        public final int width;
        public final int height;

        public ImageInformation(int orientation, int width, int height) {
            this.orientation = orientation;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return String.format("%dx%d,%d", this.width, this.height, this.orientation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageSearchCallback
    implements IImageSearchCallback {
        private transient boolean cancelled = false;
        private final transient List<IImage> localImages;

        public ImageSearchCallback(List<IImage> localImagesIn) {
            this.localImages = localImagesIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void searchFinished(List<IImage> images) {
            ImageService.this.resultsLock.lock();
            try {
                if (!this.cancelled && images != null && (ImageService.this.categoryFilter == null || ImageService.this.categoryFilter.isMatch((IImageCategory)ImageService.this.getWebImageService().getWebImageCategory()))) {
                    ImageService.this.fireResultsAppended(this.createNonDuplicateList(images));
                }
            }
            finally {
                ImageService.this.resultsLock.unlock();
            }
        }

        private List<IImage> createNonDuplicateList(List<IImage> images) {
            ArrayList<IImage> newList = new ArrayList<IImage>();
            ImageService.this.addNonDuplicateImages(this.localImages, newList, images);
            return newList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void searchCancelled() {
            ImageService.this.resultsLock.lock();
            try {
                this.cancelled = true;
            }
            finally {
                ImageService.this.resultsLock.unlock();
            }
        }
    }
}

