/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.cached;

import com.thinkbuzan.pascal.imageservice.cached.CacheController;
import com.thinkbuzan.pascal.imageservice.model.CachedImage;
import com.thinkbuzan.pascal.services.images.cached.ICachedImagesService;
import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.listener.ICachedImagesListener;
import com.thinkbuzan.pascal.services.images.model.ICachedImagesCategory;
import com.thinkbuzan.pascal.services.images.model.IImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachedImagesService
implements ICachedImagesService {
    private static final Logger LOGGER = Logger.getLogger(AbstractCachedImagesService.class);
    private final transient List<ICachedImagesListener> listeners = new ArrayList<ICachedImagesListener>();

    public abstract CacheController getCacheController();

    public void clearCache() {
        this.getCategory().removeImages();
        this.fireCachedImagesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageToCache(IImage image) {
        if (image != null) {
            ICachedImagesCategory iCachedImagesCategory = this.getCategory();
            synchronized (iCachedImagesCategory) {
                this.getCategory().addImage(image);
                this.fireCachedImagesChanged();
                ArrayList<CachedImage> cacheImages = new ArrayList<CachedImage>();
                for (IImage img : this.getCategory().getImages()) {
                    if (img instanceof CachedImage) {
                        cacheImages.add((CachedImage)img);
                        continue;
                    }
                    LOGGER.warn((Object)("Found IImage that is not a CachedImage in a cached images category! image=" + img));
                }
                this.getCacheController().cacheImages(cacheImages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageFromCache(IImage image) {
        if (image != null) {
            ICachedImagesCategory iCachedImagesCategory = this.getCategory();
            synchronized (iCachedImagesCategory) {
                this.getCategory().removeImage(image);
                this.fireCachedImagesChanged();
                ArrayList<CachedImage> cachedImages = new ArrayList<CachedImage>();
                for (IImage img : this.getCategory().getImages()) {
                    if (img instanceof CachedImage) {
                        cachedImages.add((CachedImage)img);
                        continue;
                    }
                    LOGGER.warn((Object)("Found IImage that is not a CachedImage in a cached images category! image=" + img));
                }
                this.getCacheController().cacheImages(cachedImages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageCached(IImage image) {
        boolean cached = false;
        if (image != null) {
            ICachedImagesCategory iCachedImagesCategory = this.getCategory();
            synchronized (iCachedImagesCategory) {
                cached = this.getCategory().getImages().contains(image);
            }
        }
        return cached;
    }

    public List<IImage> getFilteredImages(IImageFilter tagFilter) {
        ArrayList<IImage> images = new ArrayList<IImage>();
        if (tagFilter == null) {
            images.addAll(this.getCategory().getImages());
        } else {
            for (IImage image : this.getCategory().getImages()) {
                if (!tagFilter.isMatch(image)) continue;
                images.add(image);
            }
        }
        return images;
    }

    public void addCachedImagesListener(ICachedImagesListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void removeCachedImagesListener(ICachedImagesListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireCachedImagesChanged() {
        ArrayList<ICachedImagesListener> copy = new ArrayList<ICachedImagesListener>(this.listeners);
        for (ICachedImagesListener listener : copy) {
            listener.recentImagesChanged(this.getCategory().getImages());
        }
    }
}

