/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.cached;

import com.thinkbuzan.pascal.imageservice.cached.CachedImagesCodec;
import com.thinkbuzan.pascal.imageservice.cached.CachedImagesXMLHandler;
import com.thinkbuzan.pascal.imageservice.model.CachedImage;
import com.thinkbuzan.pascal.services.images.model.ICachedImagesCategory;
import com.thinkbuzan.pascal.services.images.model.IImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheController {
    private static final Logger LOGGER = Logger.getLogger(CacheController.class);
    private final transient CachedImagesXMLHandler handler;
    private final transient CachedImagesCodec codec;

    public CacheController(String folder, String filename) {
        this.handler = new CachedImagesXMLHandler(folder, filename);
        this.codec = new CachedImagesCodec();
    }

    public void cacheImages(List<CachedImage> images) {
        if (images != null) {
            try {
                Element root = this.codec.encode(images);
                if (root != null) {
                    this.handler.cache(root);
                }
            }
            catch (Exception exc) {
                LOGGER.error((Object)"Error caught caching cached images", (Throwable)exc);
            }
        }
    }

    public void loadImages(ICachedImagesCategory category) {
        if (category != null) {
            ArrayList<IImage> images = new ArrayList<IImage>();
            try {
                Document doc = this.handler.load();
                if (doc != null) {
                    this.codec.decode(doc, images);
                }
            }
            catch (Exception exc) {
                LOGGER.error((Object)"Error caught loading cached images", (Throwable)exc);
            }
            if (!images.isEmpty()) {
                category.addImages(images);
            }
        }
    }
}

