/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.cached;

import com.thinkbuzan.pascal.imageservice.licenser.BundleLicenser;
import com.thinkbuzan.pascal.imageservice.model.CachedImage;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachedImagesCodec {
    private static final Logger LOGGER = Logger.getLogger(CachedImagesCodec.class);
    public static final String NAMESPACE_URL = "http://www.thinkbuzan.com/RecentImagesSchema";
    private static final String ROOT_ELEMENT = "recentimages";
    private static final String IMAGE_ELEMENT = "image";
    private static final String TYPE_ATTR = "type";
    private static final String ID_ATTR = "id";
    private static final String RESOURCE_ATTR = "resource";
    private final transient Namespace nSpace = Namespace.getNamespace((String)"http://www.thinkbuzan.com/RecentImagesSchema");

    public Element encode(List<CachedImage> images) {
        if (images == null || images.isEmpty()) {
            return null;
        }
        Element root = new Element(ROOT_ELEMENT, this.nSpace);
        for (CachedImage image : images) {
            root.addContent((Content)this.createElement(image));
        }
        return root;
    }

    private Element createElement(CachedImage image) {
        Element element = new Element(IMAGE_ELEMENT, this.nSpace);
        element.setAttribute(new Attribute(TYPE_ATTR, image.getImageType().name()));
        element.setAttribute(new Attribute(ID_ATTR, image.getID()));
        element.setAttribute(new Attribute(RESOURCE_ATTR, image.getImageResourcePath()));
        return element;
    }

    public void decode(Document doc, List<IImage> images) {
        if (doc == null) {
            throw new IllegalArgumentException("doc cannot been null");
        }
        if (images == null) {
            throw new IllegalArgumentException("images cannot been null");
        }
        Element root = doc.getRootElement();
        for (Object child : root.getChildren(IMAGE_ELEMENT, this.nSpace)) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            Attribute typeAttr = element.getAttribute(TYPE_ATTR);
            if (typeAttr == null) {
                LOGGER.warn((Object)("Could not decode element with a null type attribute! element = " + element));
                continue;
            }
            ImageType type = ImageType.valueOf((String)typeAttr.getValue());
            if (type == null) {
                LOGGER.warn((Object)("Could not decode element with a type value = " + type));
                continue;
            }
            Attribute idAttr = element.getAttribute(ID_ATTR);
            if (idAttr == null) {
                LOGGER.warn((Object)("Could not decode element with a null id attribute! type = " + type));
                continue;
            }
            String imageID = idAttr.getValue();
            if (imageID == null || "".equals(imageID.trim())) {
                LOGGER.warn((Object)("Could not decode element with a null or empty id! type = " + type + ", imageID = " + imageID));
                continue;
            }
            Attribute resourceAttr = element.getAttribute(RESOURCE_ATTR);
            if (resourceAttr == null) {
                LOGGER.warn((Object)("Could not decode element with a null resource attribute! type = " + type + ", id = " + imageID));
                continue;
            }
            String resourcePath = resourceAttr.getValue();
            if (resourcePath == null || "".equals(resourcePath.trim())) {
                LOGGER.warn((Object)("Could not decode element with a null resource path! type = " + type + ", id = " + imageID + ", resourcePath = " + resourcePath));
                continue;
            }
            CachedImage image = this.createImage(type, imageID, resourcePath);
            if (image == null) continue;
            images.add(image);
        }
    }

    private CachedImage createImage(ImageType type, String imageID, String resourcePath) {
        CachedImage image = null;
        switch (type) {
            case LOCAL_3D: {
                if (!BundleLicenser.is3DLicensed()) break;
                image = new CachedImage(type, imageID, resourcePath);
                break;
            }
            case LOCAL_DISK: {
                try {
                    File resource = new File(resourcePath);
                    if (resource.exists()) {
                        image = new CachedImage(type, imageID, resourcePath);
                        break;
                    }
                    LOGGER.warn((Object)("ignoring recent image from local disk as the file doesn't exist any more! file=" + resourcePath));
                }
                catch (Exception exc) {
                    image = null;
                }
                break;
            }
            default: {
                image = new CachedImage(type, imageID, resourcePath);
            }
        }
        return image;
    }
}

