/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.cached;

import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.validate.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class CachedImagesXMLHandler {
    private final transient String foldername;
    private final transient String filename;

    public CachedImagesXMLHandler(String folderIn, String filenameIn) {
        Validator.noneEmpty((String)"CachedImagesXMLHandler", (String[])new String[]{folderIn, filenameIn});
        this.foldername = folderIn;
        this.filename = filenameIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Element root) throws IOException {
        File folder = ServiceManager.getFileAccessService().getUserFile(this.foldername);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("Could not create recent files folder");
        }
        File file = new File(folder, this.filename);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(root, (OutputStream)outStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    public Document load() throws IOException {
        File file;
        Document doc = null;
        File folder = ServiceManager.getFileAccessService().getUserFile(this.foldername);
        if (folder.exists() && (file = new File(folder, this.filename)).exists()) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder(false);
                doc = saxBuilder.build(file);
            }
            catch (JDOMException jde) {
                throw new IOException(jde);
            }
        }
        return doc;
    }
}

