/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.filter;

import com.thinkbuzan.pascal.services.images.filter.IImageCategoryFilter;
import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageCategoryFilter
implements IImageCategoryFilter {
    private final transient List<String> catIDs = new ArrayList<String>();

    public ImageCategoryFilter(IImageCategory category) {
        this.validateCategory(category);
        this.catIDs.add(category.getID());
    }

    public ImageCategoryFilter(List<IImageCategory> categories) {
        this.validateCategories(categories);
        for (IImageCategory cat : categories) {
            this.catIDs.add(cat.getID());
        }
    }

    private void validateCategory(IImageCategory category) {
        if (category == null || category.getID() == null) {
            throw new IllegalArgumentException("Cannot create category filter with a null category or category with a null id! category=" + category);
        }
    }

    private void validateCategories(List<IImageCategory> categories) {
        if (categories == null || categories.size() == 0) {
            throw new IllegalArgumentException("Cannot create category filter with a null or empty categories list");
        }
        for (IImageCategory cat : categories) {
            this.validateCategory(cat);
        }
    }

    public boolean isMatch(IImageCategory category) {
        boolean match = false;
        if (category != null) {
            for (String catID : this.catIDs) {
                if (!catID.equals(category.getID())) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public List<IImage> getFilteredImages(List<IImageCategory> categories, IImageFilter tagFilter) {
        ArrayList<IImage> images = new ArrayList<IImage>();
        for (IImageCategory category : categories) {
            if (!this.isMatch(category)) continue;
            this.addImagesFromCategory(tagFilter, images, category);
        }
        return images;
    }

    private void addImagesFromCategory(IImageFilter tagFilter, List<IImage> images, IImageCategory category) {
        for (IImage image : category.getImages()) {
            if (images.contains(image) || tagFilter != null && !tagFilter.isMatch(image)) continue;
            images.add(image);
        }
    }
}

