/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.filter;

import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.model.IImage;

public final class ImageFilter
implements IImageFilter {
    private final transient String searchTerm;
    private final transient String[] splitTerms;

    public ImageFilter(String searchString) {
        this.validateSearchString(searchString);
        this.searchTerm = searchString;
        this.splitTerms = this.searchTerm.split(" ");
    }

    private void validateSearchString(String searchString) {
        if (searchString == null) {
            throw new IllegalArgumentException("Cannot create filter with a null search term!");
        }
    }

    public boolean isMatch(IImage image) {
        boolean match = false;
        if (image != null && image.getTags() != null) {
            for (int index = 0; index < this.splitTerms.length; ++index) {
                boolean splitMatch = false;
                for (String tag : image.getTags()) {
                    if (!this.splitTerms[index].equals(tag)) continue;
                    splitMatch = true;
                    break;
                }
                if (!(match = splitMatch)) break;
            }
        }
        return match;
    }

    public String getSearchString() {
        return this.searchTerm;
    }
}

