/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.insert;

import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.model.mmImageCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.gaia.dialogs.ApplicationPane;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingIdeaAction;
import com.thinkbuzan.gaia.editor.actions.AddFloatingImageAction;
import com.thinkbuzan.gaia.editor.actions.AddImageAction;
import com.thinkbuzan.gaia.editor.actions.BeginModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.EndModelUpdateAction;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.entities.MindMapImage;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.imageservice.ImageService;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.insert.IImageInsertController;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.phoenix.licensing.LicenseState;
import com.thinkbuzan.phoenix.licensing.PluginLicense;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public final class ImageInsertController
implements IImageInsertController {
    private static final Logger LOGGER = Logger.getLogger(ImageInsertController.class);
    private static final String PREF_KEY_CANVAS_INSERT_AS_CI = "com.thinkbuzan.pascal.image.canvasinsert.asci";
    private static final String PREF_KEY_REMEMBER = "com.thinkbuzan.pascal.image.canvasinsert.asci.remember2";
    private final transient ImageService imgService;
    private final transient boolean isCILicensed;

    public ImageInsertController(ImageService service) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null!");
        }
        this.imgService = service;
        PluginLicense mmLicense = ServiceManager.getPluginLicenseService().getPluginLicense("com.thinkbuzan.license.gaia.multimap");
        this.isCILicensed = mmLicense != null && LicenseState.valid.equals((Object)mmLicense.getState());
    }

    public void insertImage(final IImage image, final boolean refreshImageList) {
        boolean brainstormView;
        IEditorComponent editorComponent = this.getCurrentEditor();
        if (editorComponent == null) {
            return;
        }
        List selection = editorComponent.getAllSelectionCells();
        boolean insertOnCanvas = selection == null || selection.isEmpty();
        boolean ciPickerShowing = editorComponent.getImageChooserManager() != null ? editorComponent.getImageChooserManager().isShowing() : false;
        boolean bl = brainstormView = editorComponent != null && ViewTypeSupport.BRAINSTORM_VIEW.equals(editorComponent.getView().getId());
        if (!brainstormView && this.isCILicensed && insertOnCanvas && !ciPickerShowing) {
            this.canvasInsertAsType(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageInsertController.this.insertImage(image, false, refreshImageList);
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageInsertController.this.insertImage(image, true, refreshImageList);
                }
            });
        } else {
            this.insertImage(image, false, refreshImageList);
        }
    }

    public void insertImage(IImage image, boolean insertAsCI, boolean refreshImageList) {
        if (image == null) {
            LOGGER.warn((Object)"cannot insert a null image!");
            return;
        }
        try {
            BufferedImage img = image.getImage();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", os);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(os.toByteArray());
            double width = img.getWidth();
            double height = img.getHeight();
            if (image.getInsertScale() != 1.0 && image.getInsertScale() > 0.0) {
                width *= image.getInsertScale();
                height *= image.getInsertScale();
            }
            MindMapImage mindMapImage = new MindMapImage((InputStream)inputStream, width, height);
            Object[] parameters = image.getInsertUUID() == null ? new Object[]{mindMapImage} : new Object[]{mindMapImage, UUID.fromString(image.getInsertUUID())};
            if (ServiceManager.getEditorManager().getCurrentEditorComponent() != null && ViewTypeSupport.BRAINSTORM_VIEW.equals(ServiceManager.getEditorManager().getCurrentEditorComponent().getView().getId())) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.apollo.brainstorm.actions.AddImageAction", parameters);
            } else if (insertAsCI) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertFloatingIdeaAction", parameters);
            } else {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InsertImageAction", parameters);
            }
            this.imgService.getRecentImagesService().addImageToCache(image);
            if (refreshImageList) {
                this.imgService.refreshImages();
            }
        }
        catch (IOException exc) {
            LOGGER.error((Object)("Exception caught inserting image=" + image), (Throwable)exc);
            this.showErrorMessage();
        }
    }

    private void showErrorMessage() {
        Frame parent = MainFrameUtilities.getMainFrame();
        String title = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.anErrorHasOccurred");
        String message = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.imindmap.couldNotOpenImageFile");
        ApplicationPane.showErrorMessage((Component)parent, (String)message, (String)title);
    }

    public void insertImage(IImage image, Object dropObject, Point dropLocation) {
        if (image == null) {
            LOGGER.warn((Object)"cannot insert a null image!");
            return;
        }
        try {
            UUID imageUUID;
            MindMapImage mindMapImage;
            BufferedImage img = image.getImage();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", os);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(os.toByteArray());
            double width = img.getWidth();
            double height = img.getHeight();
            if (image.getInsertScale() != 1.0 && image.getInsertScale() > 0.0) {
                width *= image.getInsertScale();
                height *= image.getInsertScale();
            }
            if (this.doImageInsert(mindMapImage = new MindMapImage((InputStream)inputStream, width, height), imageUUID = image.getInsertUUID() == null ? null : UUID.fromString(image.getInsertUUID()), dropObject, dropLocation)) {
                this.imgService.getRecentImagesService().addImageToCache(image);
            }
        }
        catch (IOException exc) {
            LOGGER.error((Object)("Exception caught inserting image=" + image), (Throwable)exc);
            this.showErrorMessage();
        }
    }

    private void canvasInsertAsType(ActionListener floatingImageListener, ActionListener centralIdeaListener) {
        boolean rememberDecision = ServiceManager.getPreferencesService().getCurrentUserHiddenPreferences().getBoolean(PREF_KEY_REMEMBER, false);
        if (rememberDecision) {
            boolean asCI = ServiceManager.getPreferencesService().getCurrentUserPreferences().getBoolean(PREF_KEY_CANVAS_INSERT_AS_CI, false);
            if (asCI) {
                centralIdeaListener.actionPerformed(null);
            } else {
                floatingImageListener.actionPerformed(null);
            }
        } else {
            ModalOptionDialog.SelectedModalOptionDialogPersistOption op = ModalOptionDialog.showCancelAcceptPersistDialog((Frame)MainFrameUtilities.getMainFrame(), (String)ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.title"), (String)ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.message"), (String)ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea"), (String)ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.floatingImage"), (String)ServiceManager.getLocalizedText("com.thinkbuzan.i18n.infobox.donotshowagain"));
            switch (op) {
                case ACCEPT: {
                    ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean(PREF_KEY_CANVAS_INSERT_AS_CI, true);
                    centralIdeaListener.actionPerformed(null);
                    break;
                }
                case CANCEL: {
                    ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean(PREF_KEY_CANVAS_INSERT_AS_CI, false);
                    floatingImageListener.actionPerformed(null);
                    break;
                }
                case ACCEPT_PERSIST: {
                    ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean(PREF_KEY_CANVAS_INSERT_AS_CI, true);
                    ServiceManager.getPreferencesService().getCurrentUserHiddenPreferences().putBoolean(PREF_KEY_REMEMBER, true);
                    centralIdeaListener.actionPerformed(null);
                    break;
                }
                case CANCEL_PERSIST: {
                    ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean(PREF_KEY_CANVAS_INSERT_AS_CI, false);
                    ServiceManager.getPreferencesService().getCurrentUserHiddenPreferences().putBoolean(PREF_KEY_REMEMBER, true);
                    floatingImageListener.actionPerformed(null);
                }
            }
        }
    }

    private boolean doImageInsert(final MindMapImage mindMapImage, final UUID imageId, Object dropObject, final Point dropLocation) {
        final IEditorComponent editorComponent = this.getCurrentEditor();
        if (editorComponent == null) {
            return false;
        }
        mmIStructureCell structure = this.getValidDropCell(dropObject);
        if (structure == null) {
            if (this.isCILicensed) {
                this.canvasInsertAsType(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ImageInsertController.this.insertFloatingImage(mindMapImage, imageId, dropLocation, editorComponent);
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ImageInsertController.this.insertFloatingIdea(mindMapImage, imageId, dropLocation, editorComponent);
                    }
                });
            }
        } else {
            this.insertChildImage(mindMapImage, imageId, editorComponent, structure);
        }
        return true;
    }

    private IEditorComponent getCurrentEditor() {
        IEditorComponent editor = null;
        try {
            editor = ServiceManager.getEditorManager().getCurrentEditorComponent();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return editor;
    }

    private mmIStructureCell getValidDropCell(Object dropObject) {
        mmIStructureCell cell = null;
        if (dropObject instanceof mmIStructureCell) {
            cell = (mmIStructureCell)dropObject;
        } else if (dropObject instanceof mmBranchBoxCell) {
            cell = ((mmBranchBoxCell)dropObject).getBranch();
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFloatingIdea(MindMapImage mindMapImage, UUID imageId, Point dropLocation, IEditorComponent editorComponent) {
        editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
        try {
            AddFloatingIdeaAction action = new AddFloatingIdeaAction(null, mindMapImage);
            action.setShowImageChooser(false);
            mmFloatingIdeaCell idea = (mmFloatingIdeaCell)editorComponent.runAction((AbstractEditorAction)action);
            if (dropLocation != null) {
                mxGraph graph = editorComponent.getGraphComponent().getGraph();
                mxGeometry floatingIdeaGeometry = (mxGeometry)graph.getModel().getGeometry((Object)idea).clone();
                double scale = graph.getView().getScale();
                mxPoint translate = graph.getView().getTranslate();
                double x = (double)dropLocation.x / scale - translate.getX() - floatingIdeaGeometry.getWidth() / 2.0;
                double y = (double)dropLocation.y / scale - translate.getY() - floatingIdeaGeometry.getHeight() / 2.0;
                floatingIdeaGeometry.setX(x);
                floatingIdeaGeometry.setY(y);
                graph.getModel().setGeometry((Object)idea, floatingIdeaGeometry);
            }
            if (imageId != null) {
                String propertyKey = "com.thinkbuzan.phoenix.centralIdeaImageId";
                String propertyValue = imageId.toString();
                editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)idea, "com.thinkbuzan.phoenix.centralIdeaImageId", propertyValue));
            }
        }
        finally {
            editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFloatingImage(MindMapImage mindMapImage, UUID imageId, Point dropLocation, IEditorComponent editorComponent) {
        mxGeometry geometry;
        Point2D imageInsertSize = mmUtils.calculateCentralIdeaImageInsertSize((double)mindMapImage.getWidth(), (double)mindMapImage.getHeight());
        if (dropLocation == null) {
            geometry = new mxGeometry(0.0, 0.0, imageInsertSize.getX(), imageInsertSize.getY());
        } else {
            int dropX = dropLocation.x - (int)(imageInsertSize.getX() / 2.0);
            int dropY = dropLocation.y - (int)(imageInsertSize.getY() / 2.0);
            geometry = new mxGeometry((double)dropX, (double)dropY, imageInsertSize.getX(), imageInsertSize.getY());
        }
        InputStream inputStream = mindMapImage.getImageStream();
        editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
        try {
            mmImageCell imageCell = (mmImageCell)editorComponent.runAction((AbstractEditorAction)new AddFloatingImageAction(inputStream, geometry.getRectangle()));
            if (imageId != null) {
                String propertyKey = "com.thinkbuzan.phoenix.imageId";
                String propertyValue = imageId.toString();
                editorComponent.runAction((AbstractEditorAction)new SetPropertyAction((mmICell)imageCell, "com.thinkbuzan.phoenix.imageId", propertyValue));
            }
        }
        finally {
            editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertChildImage(MindMapImage mindMapImage, UUID imageId, IEditorComponent editorComponent, mmIStructureCell structure) {
        Point2D imageInsertSize = mmUtils.calculateImageInsertSize((mmICell)structure, (MindMapImage)mindMapImage);
        mxGeometry geometry = new mxGeometry(0.8, imageInsertSize.getY() / 2.0 + mmUtils.getImageInsertYOffest((mmICell)structure), mindMapImage.getWidth(), mindMapImage.getHeight());
        InputStream inputStream = mindMapImage.getImageStream();
        editorComponent.runAction((AbstractEditorAction)new BeginModelUpdateAction());
        try {
            mmICell imageCell = (mmICell)editorComponent.runAction((AbstractEditorAction)new AddImageAction(structure, geometry, inputStream));
            if (imageId != null) {
                String propertyKey = structure instanceof mmFloatingIdeaCell ? "com.thinkbuzan.phoenix.centralIdeaImageId" : "com.thinkbuzan.phoenix.imageId";
                String propertyValue = imageId.toString();
                editorComponent.runAction((AbstractEditorAction)new SetPropertyAction(imageCell, propertyKey, propertyValue));
            }
        }
        finally {
            editorComponent.runAction((AbstractEditorAction)new EndModelUpdateAction());
        }
    }
}

