/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.local;

import com.thinkbuzan.pascal.imageservice.local.loader.LocalImageLoader;
import com.thinkbuzan.pascal.imageservice.local.provider.LocalDiskImageProvider;
import com.thinkbuzan.pascal.imageservice.local.provider.LocalImageResourceProvider;
import com.thinkbuzan.pascal.services.images.filter.IImageCategoryFilter;
import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.listener.ILocalImagesLoadedListener;
import com.thinkbuzan.pascal.services.images.local.ILocalImageService;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageProvider;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageResourceProvider;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalImageService
implements ILocalImageService {
    private final transient List<IImage> allImages = new ArrayList<IImage>();
    private final transient List<IImageCategory> categories = new ArrayList<IImageCategory>();
    private final transient Map<ImageType, ILocalImageProvider> providerMap = new HashMap<ImageType, ILocalImageProvider>();
    private final transient List<ILocalImagesLoadedListener> localLoadListeners = new ArrayList<ILocalImagesLoadedListener>();

    public LocalImageService() {
        this.loadLocalImages(new LocalImageResourceProvider(), ImageType.LOCAL);
        this.providerMap.put(ImageType.LOCAL_DISK, new LocalDiskImageProvider());
    }

    public void addLocalImagesLoadedListener(ILocalImagesLoadedListener listener) {
        if (listener != null) {
            this.localLoadListeners.add(listener);
        }
    }

    public void removeLocalImagesLoadedListener(ILocalImagesLoadedListener listener) {
        if (listener != null) {
            this.localLoadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLocalImages(ILocalImageResourceProvider provider, ImageType type) {
        if (type == null || ImageType.WEB.equals((Object)type)) {
            throw new IllegalArgumentException("invalid image type! type=" + type);
        }
        if (provider == null) {
            throw new IllegalArgumentException("cannot import local images from a null resource provider!");
        }
        Map<ImageType, ILocalImageProvider> map = this.providerMap;
        synchronized (map) {
            if (this.providerMap.containsKey(type)) {
                throw new IllegalArgumentException("provider already registered for ImageType=" + type);
            }
            this.providerMap.put(type, (ILocalImageProvider)provider);
            LocalImageLoader.loadLocalLibrary(this, provider, type);
        }
        ArrayList<ILocalImagesLoadedListener> copy = new ArrayList<ILocalImagesLoadedListener>(this.localLoadListeners);
        for (ILocalImagesLoadedListener listener : copy) {
            listener.localImagesLoaded(this.getCategories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalImageProvider getImageProvider(ImageType type) {
        Map<ImageType, ILocalImageProvider> map = this.providerMap;
        synchronized (map) {
            return this.providerMap.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImages(List<IImage> localImages) {
        if (localImages != null) {
            LocalImageService localImageService = this;
            synchronized (localImageService) {
                for (IImage image : localImages) {
                    if (this.allImages.contains(image)) continue;
                    this.allImages.add(image);
                    this.addImageToExistingCategories(image);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(IImageCategory category) {
        if (category != null) {
            LocalImageService localImageService = this;
            synchronized (localImageService) {
                this.categories.add(category);
                this.addExistingImagesToCategory(category);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IImageCategory> getCategories() {
        LocalImageService localImageService = this;
        synchronized (localImageService) {
            return new ArrayList<IImageCategory>(this.categories);
        }
    }

    public List<IImage> getFilteredImages(IImageCategoryFilter categoryFilter, IImageFilter tagFilter) {
        ArrayList<IImage> images = new ArrayList<IImage>();
        if (categoryFilter != null) {
            images.addAll(categoryFilter.getFilteredImages(this.getCategories(), tagFilter));
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImageToExistingCategories(IImage image) {
        LocalImageService localImageService = this;
        synchronized (localImageService) {
            if (this.categories.isEmpty()) {
                return;
            }
            for (IImageCategory cat : this.categories) {
                if (!image.getCategoryIDs().contains(cat.getID())) continue;
                cat.addImage(image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExistingImagesToCategory(IImageCategory category) {
        LocalImageService localImageService = this;
        synchronized (localImageService) {
            if (this.allImages.isEmpty()) {
                return;
            }
            for (IImage image : this.allImages) {
                if (!image.getCategoryIDs().contains(category.getID())) continue;
                category.addImage(image);
            }
        }
    }
}

