/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.local;

import com.thinkbuzan.gaia.dialogs.ApplicationPane;
import com.thinkbuzan.gaia.dialogs.FileFilters;
import com.thinkbuzan.gaia.dialogs.IFileFilter;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.imageservice.ImageService;
import com.thinkbuzan.pascal.imageservice.model.LocalImage;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.local.IOpenImageService;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.Component;
import java.io.File;

public final class OpenImageService
implements IOpenImageService {
    private final transient ImageService imgService;

    public OpenImageService(ImageService service) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null!");
        }
        this.imgService = service;
    }

    public void insertImageFromFile(Component parent) {
        IImage image = this.getImage(parent);
        if (image != null) {
            this.imgService.getInsertController().insertImage(image, true);
        }
    }

    public boolean insertImageFromFile(Component parent, boolean asCI) {
        IImage image = this.getImage(parent);
        if (image != null) {
            this.imgService.getInsertController().insertImage(image, true, true);
            return true;
        }
        return false;
    }

    private IImage getImage(Component parent) {
        File imageFile = this.openFileDialog(parent);
        if (imageFile == null) {
            return null;
        }
        if (imageFile.getParentFile() != null) {
            ServiceManager.getPreferencesService().getCurrentUserPreferences().put("com.thinkbuzan.image.lastOpenedImageDirectory", imageFile.getParentFile().getAbsolutePath());
        }
        LocalImage localImage = new LocalImage(ImageType.LOCAL_DISK, "local_disk_" + imageFile.getAbsolutePath(), imageFile.getAbsolutePath(), this.imgService.getLocalImageService().getImageProvider(ImageType.LOCAL_DISK));
        return localImage;
    }

    private File openFileDialog(Component parentComp) {
        String lastSaveLoc;
        Component parent = parentComp == null ? MainFrameUtilities.getMainFrame() : parentComp;
        String defaultString = "null";
        String currentDirectory = lastSaveLoc = ServiceManager.getPreferencesService().getCurrentUserPreferences().get("com.thinkbuzan.image.lastOpenedImageDirectory", "null");
        File imageFile = !currentDirectory.equals("null") ? ApplicationPane.showOpenFileDialog((Component)parent, (IFileFilter)FileFilters.IMAGE_FILE_FILTER, (String)currentDirectory) : ApplicationPane.showOpenFileDialog((Component)parent, (IFileFilter)FileFilters.IMAGE_FILE_FILTER);
        return imageFile;
    }
}

