/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.local.loader;

import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalImageLibrary {
    private transient List<IImageCategory> categories;
    private transient List<IImage> images;

    public LocalImageLibrary(List<IImageCategory> categoriesIn, List<IImage> imagesIn) {
        this.validateParams(categoriesIn, imagesIn);
        this.categories = categoriesIn;
        this.images = imagesIn;
    }

    private void validateParams(List<IImageCategory> categoriesIn, List<IImage> imagesIn) {
        if (categoriesIn == null || categoriesIn.isEmpty()) {
            throw new IllegalArgumentException("categoriesIn cannot be null or empty!");
        }
        if (imagesIn == null || imagesIn.isEmpty()) {
            throw new IllegalArgumentException("imagesIn cannot be null or empty!");
        }
    }

    public List<IImageCategory> getCategories() {
        return this.categories;
    }

    public List<IImage> getImages() {
        return this.images;
    }
}

