/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.local.loader;

import com.thinkbuzan.pascal.imageservice.local.loader.LocalImageLibrary;
import com.thinkbuzan.pascal.imageservice.local.loader.LocalImageXMLHandler;
import com.thinkbuzan.pascal.services.images.local.ILocalImageService;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageResourceProvider;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public final class LocalImageLoader {
    public static BufferedImage getBufferedImage(String filename) {
        if (filename == null || "".equals(filename.trim())) {
            throw new IllegalArgumentException("Cannot get buffered image for a null or empty filename");
        }
        return LocalImageLoader.getBufferedImage(filename, 2);
    }

    private static BufferedImage getBufferedImage(String imageFileName, int bufferedImageType) {
        Image bufferedImage = null;
        Image convertedBufferedImage = null;
        try {
            bufferedImage = ImageIO.read(LocalImageLoader.class.getResourceAsStream(imageFileName));
            if (bufferedImageType != -1 && bufferedImage.getType() != bufferedImageType) {
                convertedBufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImageType);
                Graphics2D graphics = (Graphics2D)((BufferedImage)convertedBufferedImage).getGraphics();
                graphics.drawImage(bufferedImage, 0, 0, null);
                graphics.dispose();
                bufferedImage = convertedBufferedImage;
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException(String.format("Could not get BufferedImage \"%s\"", imageFileName));
        }
        finally {
            if (convertedBufferedImage != null) {
                convertedBufferedImage.flush();
            }
        }
        return bufferedImage;
    }

    public static void loadLocalLibrary(ILocalImageService localImageService, ILocalImageResourceProvider provider, ImageType type) {
        LocalImageLibrary localLibrary = new LocalImageXMLHandler(provider, type).getLocalLibrary();
        for (IImageCategory category : localLibrary.getCategories()) {
            localImageService.addCategory(category);
        }
        localImageService.addImages(new ArrayList<IImage>(localLibrary.getImages()));
    }
}

