/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.local.loader;

import com.thinkbuzan.pascal.imageservice.local.loader.LocalImageLibrary;
import com.thinkbuzan.pascal.imageservice.local.loader.LocalImageLoader;
import com.thinkbuzan.pascal.imageservice.model.ImageCategory;
import com.thinkbuzan.pascal.imageservice.model.LocalImage;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageProvider;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageResourceProvider;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class LocalImageXMLHandler
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(LocalImageLoader.class);
    private static final String IMAGE = "image";
    private static final String IMAGE_ID = "imageId";
    private static final String INSERT_UUID = "insertuuid";
    private static final String INSERT_SCALE = "insertscale";
    private static final String FILENAME = "filename";
    private static final String TAGS = "tags";
    private static final String CATEGORY = "category";
    private static final String CATEGORY_ID = "categoryId";
    private static final String I18N_KEY = "i18nkey";
    private static final String CATEGORY_IDS = "category_ids";
    private final transient List<IImageCategory> categories = new ArrayList<IImageCategory>();
    private final transient List<IImage> images = new ArrayList<IImage>();
    private final transient ILocalImageResourceProvider provider;
    private final transient ImageType imageType;
    private transient LocalImageLibrary library;

    public LocalImageXMLHandler(ILocalImageResourceProvider providerIn, ImageType typeIn) {
        if (providerIn == null) {
            throw new IllegalArgumentException("providerIn cannot be null!");
        }
        if (typeIn == null) {
            throw new IllegalArgumentException("typeIn cannot be null!");
        }
        this.provider = providerIn;
        this.imageType = typeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalImageLibrary getLocalLibrary() {
        LocalImageXMLHandler localImageXMLHandler = this;
        synchronized (localImageXMLHandler) {
            if (this.library == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    SAXParser parser = factory.newSAXParser();
                    XMLReader reader = parser.getXMLReader();
                    reader.setContentHandler(this);
                    InputSource source = new InputSource(this.provider.getXMLInputStream());
                    reader.parse(source);
                    this.library = new LocalImageLibrary(this.categories, this.images);
                }
                catch (ParserConfigurationException e) {
                    LOGGER.error((Object)"ParserConfigurationException", (Throwable)e);
                }
                catch (SAXException e) {
                    LOGGER.error((Object)"SAXException", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"IOException", (Throwable)e);
                }
            }
            return this.library;
        }
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(CATEGORY)) {
            this.processCategory(attributes);
        } else if (qName.equalsIgnoreCase(IMAGE)) {
            this.processImage(attributes);
        }
    }

    private void processCategory(Attributes attributes) {
        String catID = attributes.getValue(CATEGORY_ID);
        String i18nKey = attributes.getValue(I18N_KEY);
        ImageCategory category = new ImageCategory(catID, ServiceManager.getLocalizedText(i18nKey));
        this.categories.add(category);
    }

    private void processImage(Attributes attributes) {
        String insertScaleStr;
        String imgID = attributes.getValue(IMAGE_ID);
        String filename = attributes.getValue(FILENAME);
        String tags = attributes.getValue(TAGS);
        String[] tagArray = tags.split(",");
        String catIDs = attributes.getValue(CATEGORY_IDS);
        String[] catIDArray = catIDs.split(",");
        LocalImage image = new LocalImage(this.imageType, imgID, Arrays.asList(catIDArray), filename, Arrays.asList(tagArray), (ILocalImageProvider)this.provider);
        String insertUUID = attributes.getValue(INSERT_UUID);
        if (insertUUID != null) {
            image.setProtectedInsertID(insertUUID);
        }
        if ((insertScaleStr = attributes.getValue(INSERT_SCALE)) != null) {
            image.setProtectedInsertScale(Double.parseDouble(insertScaleStr));
        }
        this.images.add(image);
    }
}

