/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.buzanonline.chaos.guiutilities.image.ImageResizeUtilities;
import com.mxgraph.mindmap.swing.util.SerializableImage;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageProvider;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.image.BufferedImage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImage
implements IImage {
    private static final long serialVersionUID = -2185948574640178064L;
    private final ImageType imageType;
    private final String imageID;
    private Double insertScale;
    private String insertID;
    private List<String> categoryIDs;
    private String resourcePath;
    private List<String> tags;
    private SerializableImage thumbnail;
    private ILocalImageProvider provider;

    public AbstractImage(ImageType typeIn, String idIn) {
        if (typeIn == null) {
            throw new IllegalArgumentException("typeIn cannot be null!");
        }
        if (idIn == null || "".equals(idIn.trim())) {
            throw new IllegalArgumentException("idIn cannot be null or empty");
        }
        this.imageType = typeIn;
        this.imageID = idIn;
        this.insertScale = 1.0;
    }

    public final boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IImage) {
            IImage img = (IImage)obj;
            equal = this == obj || this.imageID.equals(img.getID());
        }
        return equal;
    }

    public final ImageType getImageType() {
        return this.imageType;
    }

    public final String getID() {
        return this.imageID;
    }

    public final boolean isThumbnailLoaded() {
        return this.thumbnail != null;
    }

    public String getProtectedInsertUUID() {
        return this.insertID;
    }

    public void setProtectedInsertID(String insertIDIn) {
        this.insertID = insertIDIn;
    }

    protected final List<String> getProtectedCategoryIDs() {
        return this.categoryIDs;
    }

    protected final void setProtectedCategoryIDs(List<String> categoryIDsIn) {
        this.categoryIDs = categoryIDsIn;
    }

    protected final String getProtectedResourcePath() {
        return this.resourcePath;
    }

    protected final void setProtectedResourcePath(String resourcePathIn) {
        this.resourcePath = resourcePathIn;
    }

    protected final List<String> getProtectedTags() {
        return this.tags;
    }

    protected final void setProtectedTags(List<String> tagsIn) {
        this.tags = tagsIn;
    }

    protected final BufferedImage getProtectedThumbnail() {
        BufferedImage img = null;
        if (this.thumbnail != null) {
            img = this.thumbnail.getImage();
        }
        return img;
    }

    protected final void setProtectedThumbnail(BufferedImage thumbnailIn) {
        this.thumbnail = thumbnailIn == null ? null : new SerializableImage(thumbnailIn);
    }

    public double getProtectedInsertScale() {
        return this.insertScale;
    }

    public void setProtectedInsertScale(double insertScaleIn) {
        this.insertScale = insertScaleIn;
    }

    public ILocalImageProvider getProtectedImageProvider() {
        return this.provider;
    }

    public void setProtectedImageProvider(ILocalImageProvider providerIn) {
        this.provider = providerIn;
    }

    protected final BufferedImage createThumbnail(BufferedImage imageIn) {
        return this.createThumbnail(imageIn, false);
    }

    protected final BufferedImage createThumbnail(BufferedImage imageIn, boolean silentFail) {
        BufferedImage thumb;
        if (imageIn == null) {
            if (silentFail) {
                return null;
            }
            throw new IllegalArgumentException("cannot create thumbnail from a null buffered image! imageID=" + this.getID() + ", type=" + this.getImageType());
        }
        if (imageIn.getWidth() > 120 || imageIn.getHeight() > 120) {
            thumb = imageIn.getWidth() > imageIn.getHeight() ? ImageResizeUtilities.resizeBufferedImage((BufferedImage)imageIn, (int)120) : ImageResizeUtilities.resizeBufferedImage((BufferedImage)imageIn, (int)120);
        } else {
            int xLoc = (120 - imageIn.getWidth()) / 2;
            int yLoc = (120 - imageIn.getHeight()) / 2;
            thumb = new BufferedImage(120, 120, 2);
            thumb.getGraphics().drawImage(imageIn, xLoc, yLoc, null);
        }
        return thumb;
    }
}

