/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.thinkbuzan.pascal.imageservice.licenser.BundleLicenser;
import com.thinkbuzan.pascal.imageservice.model.LocalImage;
import com.thinkbuzan.pascal.imageservice.model.WebImage;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageProvider;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachedImage
implements IImage {
    private static final long serialVersionUID = 3054093516717730451L;
    private static final Logger LOGGER = Logger.getLogger(CachedImage.class);
    private final ImageType type;
    private final String imageID;
    private final String resourcePath;
    private IImage baseImage;
    private transient boolean unavailable = false;

    public CachedImage(IImage baseImageIn) {
        this.validateParams(baseImageIn);
        this.baseImage = baseImageIn;
        this.type = this.baseImage.getImageType();
        this.imageID = this.baseImage.getID();
        this.resourcePath = this.baseImage.getImageResourcePath();
    }

    public CachedImage(ImageType typeIn, String idIn, String resourcePathIn) {
        this.validateParams(typeIn, idIn, resourcePathIn);
        this.type = typeIn;
        this.imageID = idIn;
        this.resourcePath = resourcePathIn;
        switch (this.type) {
            case LOCAL_3D: {
                if (!BundleLicenser.is3DLicensed()) {
                    throw new IllegalStateException("Cannot create a recent 3d image when 3d is not licensed!");
                }
                ILocalImageProvider provider = ServiceManager.getImageService().getLocalImageService().getImageProvider(this.type);
                if (provider == null) break;
                this.baseImage = this.getLocalBaseImage();
                break;
            }
            case LOCAL_DISK: {
                this.baseImage = new LocalImage(this.type, this.imageID, this.resourcePath, ServiceManager.getImageService().getLocalImageService().getImageProvider(this.type));
                break;
            }
            case WEB: {
                this.baseImage = new WebImage(this.imageID, this.resourcePath, new ArrayList<String>());
                break;
            }
            default: {
                this.baseImage = this.getLocalBaseImage();
                if (this.baseImage != null) break;
                LOGGER.warn((Object)("No baseImage match found for 'Local' cached image=" + this));
            }
        }
    }

    private void validateParams(IImage baseImageIn) {
        if (baseImageIn == null) {
            throw new IllegalArgumentException("baseImageIn cannot be null!");
        }
    }

    private void validateParams(ImageType typeIn, String idIn, String resourcePathIn) {
        if (typeIn == null) {
            throw new IllegalArgumentException("typeIn cannot be null!");
        }
        if (idIn == null || "".equals(idIn.trim())) {
            throw new IllegalArgumentException("idIn cannot be null or empty!");
        }
        if (resourcePathIn == null || "".equals(resourcePathIn.trim())) {
            throw new IllegalArgumentException("resourcePathIn cannot be null or empty!");
        }
    }

    private IImage getLocalBaseImage() {
        IImage match = null;
        for (IImageCategory cat : ServiceManager.getImageService().getLocalImageService().getCategories()) {
            for (IImage img : cat.getImages()) {
                if (!img.equals(this)) continue;
                match = img;
                break;
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    public boolean isBaseImageFound() {
        return this.baseImage != null;
    }

    public void registerBaseImage(IImage baseImageIn) {
        if (!this.equals(baseImageIn)) {
            throw new IllegalArgumentException("cannot set base image to an image that does not equal this image! image=" + this + ", baseImageIn=" + baseImageIn);
        }
        this.baseImage = baseImageIn;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IImage) {
            IImage img = (IImage)obj;
            equal = this == obj || this.type.equals((Object)img.getImageType()) && this.imageID.equals(img.getID());
        }
        return equal;
    }

    public String toString() {
        return "RecentImage[id=" + this.imageID + ", type=" + this.type + ", resourcePath=" + this.resourcePath + "baseImage=" + this.baseImage + "]";
    }

    public ImageType getImageType() {
        return this.type;
    }

    public String getID() {
        return this.imageID;
    }

    public String getInsertUUID() {
        String uuid = null;
        if (this.baseImage != null) {
            uuid = this.baseImage.getInsertUUID();
        }
        return uuid;
    }

    public List<String> getCategoryIDs() {
        List cats = this.baseImage == null ? new ArrayList() : this.baseImage.getCategoryIDs();
        return cats;
    }

    public String getImageResourcePath() {
        return this.resourcePath;
    }

    public List<String> getTags() {
        List tags = this.baseImage == null ? new ArrayList() : this.baseImage.getTags();
        return tags;
    }

    public BufferedImage getThumbnail() {
        BufferedImage img = null;
        if (this.baseImage != null && !this.unavailable) {
            img = this.baseImage.getThumbnail();
            this.unavailable = img == null;
        }
        return img;
    }

    public BufferedImage getImage() {
        BufferedImage img = null;
        if (this.baseImage != null && !this.unavailable) {
            img = this.baseImage.getImage();
            this.unavailable = img == null;
        }
        return img;
    }

    public double getInsertScale() {
        double scale = 1.0;
        if (this.baseImage != null) {
            scale = this.baseImage.getInsertScale();
        }
        return scale;
    }

    public boolean isThumbnailLoaded() {
        return this.baseImage != null && this.baseImage.isThumbnailLoaded();
    }
}

