/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.thinkbuzan.pascal.imageservice.ImageService;
import com.thinkbuzan.pascal.imageservice.model.CachedImage;
import com.thinkbuzan.pascal.imageservice.model.ImageCategory;
import com.thinkbuzan.pascal.services.images.listener.ILocalImagesLoadedListener;
import com.thinkbuzan.pascal.services.images.local.ILocalImageService;
import com.thinkbuzan.pascal.services.images.model.ICachedImagesCategory;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachedImagesCategory
extends ImageCategory
implements ICachedImagesCategory {
    private final transient ImageService service;
    private final transient Integer sizeLimit;
    private final transient boolean addNewToStart;

    public CachedImagesCategory(ImageService serviceIn, String categoryID, String categoryText, boolean addNewToStartIn) {
        this(serviceIn, categoryID, categoryText, addNewToStartIn, null);
    }

    public CachedImagesCategory(ImageService serviceIn, String categoryID, String categoryText, boolean addNewToStartIn, Integer sizeLimitIn) {
        super(categoryID, categoryText);
        if (serviceIn == null) {
            throw new IllegalArgumentException("serviceIn cannot be null!");
        }
        this.service = serviceIn;
        this.addNewToStart = addNewToStartIn;
        this.sizeLimit = sizeLimitIn;
        this.service.getLocalImageService().addLocalImagesLoadedListener(new ILocalImagesLoadedListener(){

            public void localImagesLoaded(List<IImageCategory> localCategories) {
                if (localCategories != null) {
                    for (IImageCategory cat : localCategories) {
                        if (!ILocalImageService.THREE_D_CATEGORY_ID.equals(cat.getID())) continue;
                        CachedImagesCategory.this.updateFavourite3DImages(cat);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFavourite3DImages(IImageCategory threeDCategory) {
        if (threeDCategory == null) {
            return;
        }
        boolean updated = false;
        List<IImage> list = this.getModifiableAllImagesList();
        synchronized (list) {
            for (IImage img : this.getModifiableAllImagesList()) {
                if (!ImageType.LOCAL_3D.equals((Object)img.getImageType()) || !(img instanceof CachedImage) || ((CachedImage)img).isBaseImageFound()) continue;
                for (IImage threeDImage : threeDCategory.getImages()) {
                    if (!img.equals(threeDImage)) continue;
                    ((CachedImage)img).registerBaseImage(threeDImage);
                    updated = true;
                }
            }
        }
        if (updated) {
            this.service.refreshImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImage(IImage image) {
        if (image != null) {
            List<IImage> list = this.getModifiableAllImagesList();
            synchronized (list) {
                CachedImage cachedImg = image instanceof CachedImage ? (CachedImage)image : new CachedImage(image);
                if (this.getModifiableAllImagesList().contains(cachedImg)) {
                    this.getModifiableAllImagesList().remove(cachedImg);
                }
                if (this.addNewToStart) {
                    this.getModifiableAllImagesList().add(0, cachedImg);
                } else {
                    this.getModifiableAllImagesList().add(cachedImg);
                }
                if (this.sizeLimit != null && this.sizeLimit > 0 && this.getModifiableAllImagesList().size() > this.sizeLimit) {
                    do {
                        if (this.addNewToStart) {
                            this.getModifiableAllImagesList().remove(this.sizeLimit);
                            continue;
                        }
                        this.getModifiableAllImagesList().remove(0);
                    } while (this.getModifiableAllImagesList().size() > this.sizeLimit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImage(IImage image) {
        if (image != null) {
            List<IImage> list = this.getModifiableAllImagesList();
            synchronized (list) {
                if (this.getModifiableAllImagesList().contains(image)) {
                    this.getModifiableAllImagesList().remove(image);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<IImage> getImages() {
        List<IImage> list = this.getModifiableAllImagesList();
        synchronized (list) {
            ArrayList<IImage> images = new ArrayList<IImage>();
            for (IImage img : this.getModifiableAllImagesList()) {
                if (!(img instanceof CachedImage) || !((CachedImage)img).isBaseImageFound()) continue;
                images.add(img);
            }
            return images;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImages() {
        List<IImage> list = this.getModifiableAllImagesList();
        synchronized (list) {
            this.getModifiableAllImagesList().clear();
        }
    }
}

