/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IImageCategory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCategory
implements IImageCategory {
    private final transient List<IImage> allImages = new ArrayList<IImage>();
    private final transient String catID;
    private final transient String text;

    public ImageCategory(String catIDIn, String textIn) {
        this.validateParams(catIDIn, textIn);
        this.catID = catIDIn;
        this.text = textIn;
    }

    private void validateParams(String catIDIn, String textIn) {
        if (catIDIn == null || "".equals(catIDIn.trim())) {
            throw new IllegalArgumentException("Cannot create an ImageCategory with a null or empty ID!");
        }
        if (textIn == null || "".equals(textIn.trim())) {
            throw new IllegalArgumentException("Cannot create an ImageCategory with null or text!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IImage> getModifiableAllImagesList() {
        List<IImage> list = this.allImages;
        synchronized (list) {
            return this.allImages;
        }
    }

    public final String getID() {
        return this.catID;
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(IImage image) {
        List<IImage> list = this.allImages;
        synchronized (list) {
            if (image != null && !this.allImages.contains(image)) {
                this.allImages.add(image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImages(List<IImage> images) {
        List<IImage> list = this.allImages;
        synchronized (list) {
            if (images != null) {
                for (IImage image : images) {
                    if (this.allImages.contains(image)) continue;
                    this.allImages.add(image);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IImage> getImages() {
        List<IImage> list = this.allImages;
        synchronized (list) {
            return new ArrayList<IImage>(this.allImages);
        }
    }
}

