/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.thinkbuzan.pascal.imageservice.ImageService;
import com.thinkbuzan.pascal.imageservice.model.AbstractImage;
import com.thinkbuzan.pascal.services.images.local.loader.ILocalImageProvider;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalImage
extends AbstractImage {
    private static final long serialVersionUID = -7316733176781050336L;

    public LocalImage(ImageType typeIn, String imageIDIn, String filenameIn, ILocalImageProvider providerIn) {
        this(typeIn, imageIDIn, new ArrayList<String>(), filenameIn, new ArrayList<String>(), providerIn);
    }

    public LocalImage(ImageType typeIn, String imageIDIn, List<String> categoryIDsIn, String filenameIn, List<String> tagsIn, ILocalImageProvider providerIn) {
        super(typeIn, imageIDIn);
        this.validateParams(categoryIDsIn, filenameIn, tagsIn, providerIn);
        this.setProtectedCategoryIDs(new ArrayList<String>(categoryIDsIn));
        this.setProtectedResourcePath(filenameIn);
        this.setProtectedTags(tagsIn);
        this.setProtectedImageProvider(providerIn);
    }

    private void validateParams(List<String> categoryIDsIn, String filenameIn, List<String> tagsIn, ILocalImageProvider providerIn) {
        if (categoryIDsIn == null) {
            throw new IllegalArgumentException("categoryIDsIn cannot be null!");
        }
        if (filenameIn == null || "".equals(filenameIn.trim())) {
            throw new IllegalArgumentException("filenameIn cannot be null or empty!");
        }
        if (tagsIn == null) {
            throw new IllegalArgumentException("tagsIn cannot be null!");
        }
        if (providerIn == null) {
            throw new IllegalArgumentException("providerIn cannot be null!");
        }
    }

    public String getInsertUUID() {
        return this.getProtectedInsertUUID();
    }

    public List<String> getCategoryIDs() {
        return this.getProtectedCategoryIDs();
    }

    public String getImageResourcePath() {
        return this.getProtectedResourcePath();
    }

    public List<String> getTags() {
        return new ArrayList<String>(this.getProtectedTags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getThumbnail() {
        LocalImage localImage = this;
        synchronized (localImage) {
            if (this.getProtectedThumbnail() == null) {
                this.setProtectedThumbnail(this.createThumbnail());
            }
            return this.getProtectedThumbnail();
        }
    }

    public BufferedImage getImage() {
        return this.createImage();
    }

    public double getInsertScale() {
        return this.getProtectedInsertScale();
    }

    private BufferedImage createImage() {
        BufferedImage src = this.getProtectedImageProvider().getLocalImage(this.getImageResourcePath());
        try {
            src = ImageService.getImageTransformedForExif(src, this.getImageResourcePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return src;
    }

    private BufferedImage createThumbnail() {
        return this.createThumbnail(this.createImage());
    }
}

