/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.model;

import com.thinkbuzan.pascal.imageservice.model.AbstractImage;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.model.ImageType;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebImage
extends AbstractImage {
    private static final long serialVersionUID = 1074837142508883190L;

    public WebImage(String imageID, String urlIn, List<String> tags) {
        super(ImageType.WEB, imageID);
        this.validateParams(urlIn, tags);
        this.setProtectedResourcePath(urlIn);
        this.setProtectedCategoryIDs(Arrays.asList("webimages"));
        this.setProtectedTags(tags);
    }

    private void validateParams(String urlIn, List<String> tags) {
        if (urlIn == null) {
            throw new IllegalArgumentException("urlIn cannot be null!");
        }
        if (tags == null) {
            throw new IllegalArgumentException("tags cannot be null!");
        }
    }

    public String getInsertUUID() {
        return this.getProtectedInsertUUID();
    }

    public List<String> getCategoryIDs() {
        return this.getProtectedCategoryIDs();
    }

    public String getImageResourcePath() {
        return this.getProtectedResourcePath();
    }

    public List<String> getTags() {
        return new ArrayList<String>(this.getProtectedTags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getThumbnail() {
        WebImage webImage = this;
        synchronized (webImage) {
            if (this.getProtectedThumbnail() == null) {
                this.setProtectedThumbnail(this.createThumbnail(this.downloadImageFromURL(), true));
            }
            return this.getProtectedThumbnail();
        }
    }

    public BufferedImage getImage() {
        return this.downloadImageFromURL();
    }

    public double getInsertScale() {
        return this.getProtectedInsertScale();
    }

    private BufferedImage downloadImageFromURL() {
        BufferedImage image = null;
        try {
            URL url = new URL(this.getProtectedResourcePath());
            HttpURLConnection conn = ServiceManager.getNetworkService().getHttpURLConnection(url);
            InputStream inStream = conn.getInputStream();
            image = ImageIO.read(inStream);
            inStream.close();
        }
        catch (Exception exc) {
            Logger.getLogger(this.getClass()).warn((Object)"failed to retrieve protected thumbnail", (Throwable)exc);
        }
        return image;
    }
}

