/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.recent;

import com.thinkbuzan.pascal.imageservice.ImageService;
import com.thinkbuzan.pascal.imageservice.cached.AbstractCachedImagesService;
import com.thinkbuzan.pascal.imageservice.cached.CacheController;
import com.thinkbuzan.pascal.imageservice.model.CachedImagesCategory;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.images.model.ICachedImagesCategory;
import com.thinkbuzan.pascal.services.validate.Validator;
import java.io.File;

public final class RecentImagesService
extends AbstractCachedImagesService {
    private static final String RECENT_FOLDER = "recentimages";
    private static final String XML_FILENAME = "recentimages.xml";
    private static final String CATEGORY_ID = "recentimages";
    private static final Integer SIZE_LIMIT = new Integer(50);
    private final transient CacheController cacheController;
    private final transient ICachedImagesCategory category;

    public RecentImagesService(ImageService service) {
        Validator.notNull((Object)service, (String)"service");
        this.category = new CachedImagesCategory(service, "recentimages", ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.recent"), true, SIZE_LIMIT);
        this.cacheController = new CacheController("recentimages", XML_FILENAME);
        this.cacheController.loadImages(this.category);
    }

    public void clearCache() {
        File folder = ServiceManager.getFileAccessService().getUserFile("recentimages");
        if (!folder.exists() && !folder.mkdirs()) {
            return;
        }
        File file = new File(folder, XML_FILENAME);
        if (file.exists() && file.delete()) {
            super.clearCache();
        }
    }

    public ICachedImagesCategory getCategory() {
        return this.category;
    }

    public CacheController getCacheController() {
        return this.cacheController;
    }
}

