/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.resources;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;

public final class ResourceManager {
    private ResourceManager() {
    }

    public static ImageIcon getIcon(String filename) {
        return new ImageIcon(ResourceManager.class.getResource(filename));
    }

    public static BufferedImage getBufferedImage(String imageFileName) {
        BufferedImage bufferedImage;
        ResourceManager.validateGetImageIcon(imageFileName);
        try {
            InputStream inputStream = ResourceManager.class.getResourceAsStream(imageFileName);
            bufferedImage = ImageIO.read(inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not get BufferedImage \"%s\"", imageFileName));
        }
        return bufferedImage;
    }

    private static void validateGetImageIcon(String iamgeFileName) {
        if (null == iamgeFileName || iamgeFileName.length() == 0) {
            throw new IllegalArgumentException(" image file name can't be null or empty");
        }
        InputStream inputStream = ResourceManager.class.getResourceAsStream(iamgeFileName);
        if (null == inputStream) {
            throw new IllegalArgumentException(" image file doesn't exsit.");
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

