/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.ui.v2.windows;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.imageservice.resources.ResourceManager;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InsertImageAsDialog
extends ModalDialog {
    private static final String PREF_KEY_CANVAS_INSERT_AS_CI = "com.thinkbuzan.pascal.image.canvasinsert.asci";
    private static final String PREF_KEY_REMEMBER = "com.thinkbuzan.pascal.image.canvasinsert.asci.remember2";
    private static final String titleLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.title");
    private static final String messageOneLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.message");
    private static final String messageTwoLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.message.branchImage");
    private static final String messageThreeLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images.insertasci.message.rightclick");
    private static final String floatingImageLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.floatingImage");
    private static final String floatingIdeaLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.floatingIdea");
    private static final String doNotShowAgainLocalized = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.infobox.donotshowagain");
    private static final Dimension dialogDimension = new Dimension(800, 550);
    private JCheckBox preferenceCheckBox;

    public InsertImageAsDialog(Frame owner, ActionListener floatingImageListener, ActionListener centralIdeaListener) {
        super(owner, titleLocalized, false, true, Dialog.ModalityType.DOCUMENT_MODAL);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setOpaque(false);
        JPanel messageOneLabel = this.getLabel(messageOneLocalized);
        JPanel imageButtonsPanel = this.getButtonPanel(floatingImageListener, centralIdeaListener);
        JPanel messageTwoLabel = this.getLabel(messageTwoLocalized);
        JPanel messageThreeLabel = this.getLabel(messageThreeLocalized, true);
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(messageOneLabel);
        mainPanel.add(imageButtonsPanel);
        mainPanel.add(messageTwoLabel);
        mainPanel.add(messageThreeLabel);
        mainPanel.add(this.getCheckboxPanel());
        mainPanel.add(Box.createVerticalGlue());
        this.setContent(mainPanel);
        this.setMinimumSize(dialogDimension);
        this.setMaximumSize(dialogDimension);
        this.setPreferredSize(dialogDimension);
        this.setSize(dialogDimension);
    }

    private final void dialogOptionSelected() {
        if (this.preferenceCheckBox.isSelected()) {
            ServiceManager.getPreferencesService().getCurrentUserHiddenPreferences().putBoolean(PREF_KEY_REMEMBER, true);
        }
    }

    private final JPanel getButtonPanel(ActionListener floatingImageListener, ActionListener centralIdeaListener) {
        JPanel imageButtonsPanel = new JPanel();
        imageButtonsPanel.setLayout(new BoxLayout(imageButtonsPanel, 0));
        imageButtonsPanel.setOpaque(false);
        imageButtonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        ImageIcon floatingImageImageIcon = ResourceManager.getIcon("imageafloating.png");
        ImageIcon centralIdeaImageIcon = ResourceManager.getIcon("imageascentral.png");
        JPanel floatingImageButton = this.getButton(floatingImageImageIcon, floatingImageLocalized, floatingImageListener, false);
        JPanel centralIdeaButton = this.getButton(centralIdeaImageIcon, floatingIdeaLocalized, centralIdeaListener, true);
        imageButtonsPanel.add(Box.createHorizontalGlue());
        imageButtonsPanel.add(floatingImageButton);
        imageButtonsPanel.add(Box.createHorizontalStrut(10));
        imageButtonsPanel.add(centralIdeaButton);
        imageButtonsPanel.add(Box.createHorizontalGlue());
        return imageButtonsPanel;
    }

    private final JPanel getButton(ImageIcon imageIcon, String labelText, final ActionListener actionListener, final boolean isInsertAsCentralIdea) {
        final Color backgroundColour = Color.decode("#fafafa");
        final Color hoverBackgroundColour = Color.decode("#d5e1f2");
        final Color pressedBackgroundColour = Color.decode("#a3bde3");
        final JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(backgroundColour);
        final JPanel imagePanel = new JPanel(new FlowLayout(1));
        imagePanel.setOpaque(false);
        imagePanel.setBackground(backgroundColour);
        JLabel imageLabel = new JLabel(imageIcon);
        imageLabel.setOpaque(false);
        imagePanel.add(imageLabel);
        final JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.setOpaque(false);
        labelPanel.setBackground(backgroundColour);
        JLabel label = new JLabel(labelText);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)16.0f));
        labelPanel.add(label);
        panel.add(Box.createVerticalGlue());
        panel.add(imagePanel);
        panel.add(labelPanel);
        panel.add(Box.createVerticalGlue());
        panel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                actionListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                InsertImageAsDialog.this.setVisible(false);
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean(InsertImageAsDialog.PREF_KEY_CANVAS_INSERT_AS_CI, isInsertAsCentralIdea);
                InsertImageAsDialog.this.dialogOptionSelected();
            }

            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                panel.setOpaque(true);
                imagePanel.setOpaque(true);
                labelPanel.setOpaque(true);
                panel.setBackground(hoverBackgroundColour);
                imagePanel.setBackground(hoverBackgroundColour);
                labelPanel.setBackground(hoverBackgroundColour);
            }

            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                panel.setOpaque(false);
                imagePanel.setOpaque(false);
                labelPanel.setOpaque(false);
                panel.setBackground(backgroundColour);
                imagePanel.setBackground(backgroundColour);
                labelPanel.setBackground(backgroundColour);
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                panel.setOpaque(true);
                imagePanel.setOpaque(true);
                labelPanel.setOpaque(true);
                panel.setBackground(pressedBackgroundColour);
                imagePanel.setBackground(pressedBackgroundColour);
                labelPanel.setBackground(pressedBackgroundColour);
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                panel.setOpaque(true);
                imagePanel.setOpaque(true);
                labelPanel.setOpaque(true);
                panel.setBackground(backgroundColour);
                imagePanel.setBackground(backgroundColour);
                labelPanel.setBackground(backgroundColour);
            }
        });
        return panel;
    }

    private final JPanel getCheckboxPanel() {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setOpaque(false);
        checkboxPanel.setLayout(new FlowLayout(2, 0, 0));
        checkboxPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 15));
        this.preferenceCheckBox = CoreUIFactory.createCheckBox((String)doNotShowAgainLocalized);
        this.preferenceCheckBox.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        checkboxPanel.add(this.preferenceCheckBox);
        JPanel innerCheckBoxPanel = new JPanel();
        innerCheckBoxPanel.setLayout(new FlowLayout(1, 0, 0));
        innerCheckBoxPanel.add(checkboxPanel);
        return checkboxPanel;
    }

    private final JPanel getLabel(String text, boolean isBold) {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 0));
        holder.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        holder.setOpaque(false);
        JLabel label = new JLabel("<html><div style=\"text-align:center;width:525px;\">" + text + "</div></html>");
        int fontStyle = 0;
        if (isBold) {
            fontStyle = 0;
        }
        label.setFont(ApplicationFont.getRegularFont((int)fontStyle, (float)16.0f));
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        label.setMaximumSize(new Dimension(575, 70));
        holder.add(Box.createHorizontalGlue());
        holder.add(label);
        holder.add(Box.createHorizontalGlue());
        return holder;
    }

    private final JPanel getLabel(String text) {
        return this.getLabel(text, false);
    }
}

