/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.web;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.thinkbuzan.pascal.imageservice.model.WebImage;
import com.thinkbuzan.pascal.imageservice.osgi.ServiceManager;
import com.thinkbuzan.pascal.imageservice.web.model.WebImageData;
import com.thinkbuzan.pascal.services.images.model.IImage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchManager {
    private static final Logger LOGGER = Logger.getLogger(SearchManager.class);
    public static final int RESULTS_PER_PAGE = 10;
    private static final int LICENSE_TYPE = 2;
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 512;

    public List<IImage> search(String terms) {
        return this.search(terms, 0);
    }

    public List<IImage> search(String terms, int page) {
        if (terms == null || "".equals(terms.trim())) {
            throw new IllegalArgumentException("Cannot search for null or empty terms!");
        }
        if (page < 0) {
            throw new IllegalArgumentException("Cannot search for a negative page number! page=" + page);
        }
        String url = this.buildURL(terms, page);
        HttpClient client = ServiceManager.getNetworkService().getHttpClient();
        ArrayList<IImage> images = new ArrayList<IImage>();
        try {
            HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
            this.populateImagesFromResponse(terms, response, images);
        }
        catch (ClientProtocolException exc) {
            LOGGER.error((Object)("ClientProtocolException caught searching for web images! url=" + url), (Throwable)exc);
        }
        catch (IOException exc) {
            LOGGER.error((Object)("IOException caught searching for web images! url=" + url), (Throwable)exc);
        }
        return images;
    }

    private String buildURL(String terms, int page) {
        return this.buildURL(terms, page, 10, 2, 1, 512);
    }

    private String buildURL(String terms, int page, int pageSize, int licenseType, int minSize, int maxSize) {
        StringBuilder builder = new StringBuilder("http://image.services.thinkbuzan.com/images/search/");
        try {
            builder.append(URLEncoder.encode(terms, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)("Failed to encode search term: " + terms));
        }
        builder.append("/");
        builder.append(page);
        builder.append("/10");
        return builder.toString();
    }

    private void populateImagesFromResponse(String terms, HttpResponse response, List<IImage> images) throws IOException {
        if (response == null || response.getStatusLine() == null) {
            throw new IllegalArgumentException("Cannot populate images from a null response or null status line! reponse=" + response);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IllegalArgumentException("Cannot populate images from a response with status code=" + response.getStatusLine().getStatusCode());
        }
        this.parseResponse(terms, response.getEntity(), images);
    }

    private void parseResponse(String terms, HttpEntity entity, List<IImage> images) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Cannot populate images from a null entity");
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(entity.getContent(), "UTF-8"));
        reader.setLenient(true);
        WebImageData[] imagesData = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("searchresults")) {
                reader.beginObject();
                continue;
            }
            if (name.equals("icons")) {
                Gson gson = new Gson();
                imagesData = (WebImageData[])gson.fromJson(reader, WebImageData[].class);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        if (imagesData != null) {
            String[] termsArray = terms.split(" ");
            for (WebImageData img : imagesData) {
                WebImage image = new WebImage(img.id, img.image, Arrays.asList(termsArray));
                images.add(image);
            }
        }
    }
}

