/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.imageservice.web;

import com.thinkbuzan.pascal.imageservice.model.WebImageCategory;
import com.thinkbuzan.pascal.imageservice.web.SearchManager;
import com.thinkbuzan.pascal.services.images.filter.IImageFilter;
import com.thinkbuzan.pascal.services.images.listener.IImageSearchCallback;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.services.images.model.IWebImageCategory;
import com.thinkbuzan.pascal.services.images.web.IWebImageService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class WebImageService
implements IWebImageService {
    private final transient AtomicBoolean searching = new AtomicBoolean(false);
    private final transient IWebImageCategory category = new WebImageCategory();
    private final transient SearchManager manager = new SearchManager();
    private transient Thread searchThread;
    private transient String searchTerm;
    private transient int page;
    private transient IImageSearchCallback callback;
    private transient boolean nextEnabled;

    public IWebImageCategory getWebImageCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(IImageFilter tagFilter, IImageSearchCallback callbackIn) {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            this.nextEnabled = false;
            if (this.searching.get()) {
                this.cancelSearch();
            }
            this.category.setImages(new ArrayList());
            this.page = 0;
            this.callback = callbackIn;
            if (tagFilter != null && this.callback != null) {
                this.searchTerm = tagFilter.getSearchString();
                this.search();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            this.searching.set(true);
            SearchRunnable runnable = new SearchRunnable(this.page, this.callback);
            this.searchThread = new Thread((Runnable)runnable, "ImageSearch_" + this.searchTerm + "_page=" + this.page);
            this.searchThread.setDaemon(true);
            this.searchThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSearch() {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            this.searching.set(false);
            this.nextEnabled = false;
            if (this.searchThread != null) {
                Thread tmp = this.searchThread;
                this.searchThread = null;
                tmp.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextPage() {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            return this.nextEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            if (!this.nextEnabled) {
                return;
            }
            this.nextEnabled = false;
            if (this.searchThread == null && this.searchTerm != null && this.callback != null) {
                ++this.page;
                this.search();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearching() {
        AtomicBoolean atomicBoolean = this.searching;
        synchronized (atomicBoolean) {
            return this.searching.get();
        }
    }

    private class SearchRunnable
    implements Runnable {
        private final transient int pageToSearch;
        private final transient IImageSearchCallback callbackToUse;

        public SearchRunnable(int pageIn, IImageSearchCallback callbackIn) {
            this.pageToSearch = pageIn;
            this.callbackToUse = callbackIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<IImage> images = WebImageService.this.manager.search(WebImageService.this.searchTerm, this.pageToSearch);
            WebImageService.this.nextEnabled = images != null && images.size() >= 10;
            if (this.pageToSearch == 0) {
                WebImageService.this.category.setImages(images);
            } else {
                WebImageService.this.category.appendImages(images);
            }
            this.callbackToUse.searchFinished(images);
            AtomicBoolean atomicBoolean = WebImageService.this.searching;
            synchronized (atomicBoolean) {
                WebImageService.this.searchThread = null;
                WebImageService.this.searching.set(false);
            }
        }
    }
}

