/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.editor;

import com.thinkbuzan.apollo.ui.win.frame.ui.MapPreviewPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.MindMapFrame;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.gaia.view.IView;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorTabManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.CommentVisibilityListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.SaveLocationListener;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EditorTabManager
implements IEditorTabManager {
    private static final Logger LOGGER = Logger.getLogger(EditorTabManager.class);
    private transient IEditorManager editorManager;
    private transient MindMapFrame frame;
    private Object[] _selectedObjects = new Object[1];
    private HashMap<UUID, JComponent> _editorComponentMap = new HashMap();
    private HashMap<UUID, TabState> _editorContextTabStateMap = new HashMap();
    private HashMap<UUID, IViewListener> _editorViewListenerMap = new HashMap();
    private final transient List<IEditorChangeListener> listeners = new ArrayList<IEditorChangeListener>();
    private String _currentView;
    private SelectionListener _selectionListener = this.createSelectionListener();
    IEditorView oldEditor;

    public EditorTabManager(MindMapFrame frameIn) {
        this.frame = frameIn;
        ServiceManager.addEditorManagerServiceListener((IServiceListener<IEditorManager>)new ServiceAdapter<IEditorManager>(){

            public void serviceAdded(IEditorManager service) {
                super.serviceAdded((Object)service);
                EditorTabManager.this.editorManager = service;
            }
        });
    }

    private SelectionListener createSelectionListener() {
        return new SelectionListener(){

            public void selectionChanged(Object ... selComps) {
                EditorTabManager.access$102(EditorTabManager.this, selComps);
            }
        };
    }

    public int getSelectedEditorComponentIndex() {
        int index = -1;
        for (Component c : this.frame.getQuickMapSwitchPanel().getContents()) {
            if (!(c instanceof MapPreviewPanel)) continue;
            ++index;
            if (((MapPreviewPanel)c).isSelected()) break;
        }
        return index;
    }

    public void removeTab(IEditorView editor1) {
        JComponent c;
        if (editor1 != null && (c = this._editorComponentMap.get(editor1.getId())) != null) {
            this._editorComponentMap.remove(editor1.getId());
            this._editorContextTabStateMap.remove(editor1.getId());
            this.frame.removeComponentFromLayerPane(editor1.getId().toString());
            this.frame.getQuickMapSwitchPanel().remove(editor1);
            this.fireEditorRemoved(editor1);
            this.switchFocusToEditorComponent(this.frame.getQuickMapSwitchPanel().getPreviouslySelectedEditor());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorTabManager.this.frame.getQuickMapSwitchPanel().getToggleButton().setCounter(EditorTabManager.this.editorManager.getAllEditorViews().size());
                    if (EditorTabManager.this.editorManager.getAllEditorViews().size() == 0) {
                        EditorTabManager.this.frame.hideContextTabs();
                        EditorTabManager.this.frame.lockTabs();
                    }
                }
            });
        }
    }

    private void fireEditorRemoved(IEditorView editor2) {
        for (IEditorChangeListener listener : this.listeners) {
            listener.editorRemoved(editor2);
        }
        if (this._editorViewListenerMap.containsKey(editor2.getId())) {
            IViewListener listener = this._editorViewListenerMap.get(editor2.getId());
            editor2.removeViewTypeListener(listener);
            this._editorViewListenerMap.remove(editor2.getId());
        }
        if (this.oldEditor != null && this.oldEditor.getId().equals(editor2.getId())) {
            this.oldEditor = null;
        }
        if (this.frame.getQuickMapSwitchPanel().getPreviouslySelectedEditor() != null && this.frame.getQuickMapSwitchPanel().getPreviouslySelectedEditor().getId().equals(editor2.getId())) {
            this.frame.getQuickMapSwitchPanel().clearPreviouslySelectedEditor();
        }
    }

    public String getTabTextForEditorComponent(IEditorView editor3) {
        return editor3.getTabName();
    }

    public void setTabTextForEditorComponent(IEditorView editor4, String string) {
        this.frame.getQuickMapSwitchPanel().setQuickMapSwitchPanelText(editor4, string);
    }

    public void addTab(IEditorView editor5, JComponent viewComponent) {
        this._editorComponentMap.put(editor5.getId(), viewComponent);
        this.frame.unlockTabs();
        this.frame.addComponentToLayerPane(viewComponent, editor5.getId().toString(), null, editor5.getView().getId());
        this.frame.getQuickMapSwitchPanel().add(editor5);
        this.frame.getQuickMapSwitchPanel().getToggleButton().setCounter(this.editorManager.getAllEditorViews().size());
        editor5.addSaveLocationListener(new SaveLocationListener(){

            public void saveLocationChanged(IEditorView editorComponent, String nameIn) {
                EditorTabManager.this.frame.getQuickMapSwitchPanel().refreshPreviewImage(editorComponent);
            }

            public void saveLocationChanged(IEditorView editorComponent) {
            }
        });
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor6) {
                    if (editor6 != null) {
                        EditorTabManager.this.frame.unlockTabs();
                        EditorTabManager.this.showAppropriateContextTabs(editor6);
                        EditorTabManager.this.frame.setMapName(editor6.getTabName());
                        editor6.addSaveLocationListener(new SaveLocationListener(){

                            public void saveLocationChanged(IEditorView editorComponent, String nameIn) {
                                EditorTabManager.this.frame.setMapName(editorComponent.getTabName());
                            }

                            public void saveLocationChanged(IEditorView editorComponent) {
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IViewListener listener = this.createViewListener(editor5);
        this._editorViewListenerMap.put(editor5.getId(), listener);
        editor5.addViewTypeListener(listener);
        editor5.addSelectionListener(this.frame.getSelectionListener());
        editor5.addSelectionListener(this._selectionListener);
        editor5.addSketchModeListener(this.frame.getSketchListener());
        editor5.addCommentVisibilityListener(new CommentVisibilityListener(){

            public void commentVisibilityChanged(boolean visible) {
                if (visible) {
                    EditorTabManager.this.frame.showCommentsContextTab();
                } else {
                    EditorTabManager.this.frame.hideCommentsContextTab();
                }
            }
        });
    }

    private IViewListener createViewListener(final IEditorView editor11) {
        return new IViewListener(){

            public void viewChanged(String viewId) {
                EditorTabManager.this.frame.getQuickMapSwitchPanel().refreshPreviewImage(editor11);
                EditorTabManager.this.frame.unlockTabs();
                if (!viewId.equals(EditorTabManager.this._currentView)) {
                    EditorTabManager.this.showAppropriateContextTabs(viewId);
                }
                if (viewId.equals("com.thinkbuzan.gaia.view.PresentationView")) {
                    EditorTabManager.this.frame.getQuickMapSwitchPanel().collapse();
                } else {
                    EditorTabManager.this.frame.setPresentationName(null);
                }
            }
        };
    }

    private void showAppropriateContextTabs(IEditorView editor7) {
        if (editor7 != null) {
            this.showAppropriateContextTabs(editor7.getView().getId());
        } else {
            this.frame.hideContextTabs();
        }
    }

    private void showAppropriateContextTabs(String viewId) {
        this.frame.hideContextTabs();
        this.frame.updateSidePanelsForView(viewId);
        if (!viewId.equals("com.thinkbuzan.phoenix.view.MindMapView")) {
            if (viewId.equals("com.thinkbuzan.phoenix.view.FastCaptureView")) {
                this.frame.showFastCaptureContextTab();
            } else if (viewId.equals("com.thinkbuzan.phoenix.view.BrainstormView")) {
                this.frame.showBrainstormContextTab();
            } else if (viewId.equals("com.thinkbuzan.gaia.view.ProjectManagementView")) {
                this.frame.showProjectContextTab();
            } else if (viewId.equals("com.thinkbuzan.gaia.view.PresentationView")) {
                this.frame.showPresentationContextTab();
            } else if (viewId.equals("com.thinkbuzan.orion.view.TimelineView")) {
                this.frame.showTimelineContextTab();
            }
        }
        this._currentView = viewId;
    }

    public void setViewForEditorComponent(IEditorManager manager, IEditorView editor8, IView oldView, IView newView) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LOGGER.warn((Object)"setViewForEditorComponent a tab should be done on the EDT!", (Throwable)new IllegalStateException("Stack Trace:"));
        }
        if (editor8 != null) {
            oldView.release(editor8);
            JComponent newViewComponent = manager.getViewComponent(editor8, newView);
            if (this.editorManager.getCurrentEditorComponent() == editor8) {
                this.frame.addComponentToLayerPane(newViewComponent, editor8.getId().toString(), oldView.getId(), newView.getId());
            }
            this._editorComponentMap.put(editor8.getId(), newViewComponent);
        }
    }

    public void switchFocusToEditorComponent(IEditorView editor9) {
        TabState tabStateToStore = new TabState();
        tabStateToStore.FastCaptureTab = this.frame.isFastCaptureContextTabShowing();
        tabStateToStore.BrainstormTab = this.frame.isBrainstormContextTabShowing();
        tabStateToStore.BranchTab = this.frame.isBranchContextTabShowing();
        tabStateToStore.ProjectTab = this.frame.isProjectContextTabShowing();
        tabStateToStore.CommentsTab = this.frame.isCommentsContextTabShowing();
        tabStateToStore.PresentationTab = this.frame.isPresentationContextTabShowing();
        tabStateToStore.SketchTab = this.frame.isSketchContextTabShowing();
        tabStateToStore.TimelineTab = this.frame.isTimelineContextTabShowing();
        this._editorContextTabStateMap.put(this.editorManager.getCurrentEditorComponent().getId(), tabStateToStore);
        if (editor9 == null) {
            return;
        }
        if (this.oldEditor != null && editor9.getId().equals(this.oldEditor.getId()) && editor9.hasComments()) {
            this.frame.showCommentsContextTab();
            this.frame.goToHomeTab();
        }
        String oldView = this.oldEditor != null ? this.oldEditor.getView().getId() : null;
        this.frame.addComponentToLayerPane(this._editorComponentMap.get(editor9.getId()), editor9.getId().toString(), oldView, editor9.getView().getId());
        if (this.oldEditor != null) {
            this.oldEditor.removeSelectionListener(this.frame.getSelectionListener());
            this.oldEditor.removeSelectionListener(this._selectionListener);
            this.oldEditor.removeSketchModeListener(this.frame.getSketchListener());
        }
        this.frame.getQuickMapSwitchPanel().setSelectedPanel(editor9);
        editor9.addSelectionListener(this.frame.getSelectionListener());
        editor9.addSelectionListener(this._selectionListener);
        editor9.addSketchModeListener(this.frame.getSketchListener());
        this.editorManager.editorChanged();
        this.frame.hideContextTabs();
        this.frame.unlockTabs();
        TabState newTabState = this._editorContextTabStateMap.get(editor9.getId());
        if (newTabState == null) {
            this.showAppropriateContextTabs(editor9.getView().getId());
        } else {
            if (newTabState.FastCaptureTab) {
                this.frame.showFastCaptureContextTab();
            }
            if (newTabState.BrainstormTab) {
                this.frame.showBrainstormContextTab();
            }
            if (newTabState.BranchTab) {
                this.frame.showBranchContextTab();
            }
            if (newTabState.ProjectTab) {
                this.frame.showProjectContextTab();
            }
            if (newTabState.CommentsTab) {
                this.frame.showCommentsContextTab();
            }
            if (newTabState.PresentationTab) {
                // empty if block
            }
            if (newTabState.SketchTab) {
                this.frame.showSketchContextTab();
            }
            if (newTabState.TimelineTab) {
                this.frame.showTimelineContextTab();
            }
        }
        this.oldEditor = editor9;
    }

    public void setEditorComponentBusy(UUID editorId, boolean busy) {
    }

    public Component getComponentForEditorComponent(IEditorView editor10) {
        return this._editorComponentMap.get(editor10.getId());
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.listeners.add(listener);
    }

    static /* synthetic */ Object[] access$102(EditorTabManager x0, Object[] x1) {
        x0._selectedObjects = x1;
        return x1;
    }

    public class TabState {
        public boolean FastCaptureTab;
        public boolean BrainstormTab;
        public boolean ProjectTab;
        public boolean CommentsTab;
        public boolean BranchTab;
        public boolean PresentationTab;
        public boolean SketchTab;
        public boolean TimelineTab;
    }
}

