/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.filters;

import com.thinkbuzan.apollo.ui.win.frame.filters.AbstractBufferedImageOp;
import com.thinkbuzan.apollo.ui.win.frame.filters.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class ShadowFilter
extends AbstractBufferedImageOp {
    static final long serialVersionUID = 6310370419462785691L;
    private int radius = 5;
    private int xOffset = 5;
    private int yOffset = 5;
    private float opacity = 0.5f;
    private boolean addMargins = false;
    private boolean shadowOnly = false;
    private int shadowColor = -16777216;

    public ShadowFilter() {
    }

    public ShadowFilter(int radius, int xOffset, int yOffset, float opacity) {
        this.radius = radius;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.opacity = opacity;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setAddMargins(boolean addMargins) {
        this.addMargins = addMargins;
    }

    public boolean getAddMargins() {
        return this.addMargins;
    }

    public void setShadowOnly(boolean shadowOnly) {
        this.shadowOnly = shadowOnly;
    }

    public boolean getShadowOnly() {
        return this.shadowOnly;
    }

    protected void transformSpace(Rectangle r) {
        if (this.addMargins) {
            r.width += Math.abs(this.xOffset) + 2 * this.radius;
            r.height += Math.abs(this.yOffset) + 2 * this.radius;
        }
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            if (this.addMargins) {
                ColorModel cm = src.getColorModel();
                dst = new BufferedImage(cm, cm.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), cm.isAlphaPremultiplied(), null);
            } else {
                dst = this.createCompatibleDestImage(src, null);
            }
        }
        float[][] extractAlpha = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, this.opacity}};
        BufferedImage shadow = new BufferedImage(width, height, 2);
        new BandCombineOp(extractAlpha, null).filter(src.getRaster(), shadow.getRaster());
        shadow = new GaussianFilter(this.radius).filter(shadow, null);
        Graphics2D g = dst.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, this.opacity));
        if (this.addMargins) {
            int radius2 = this.radius / 2;
            int topShadow = Math.max(0, this.radius - this.yOffset);
            int leftShadow = Math.max(0, this.radius - this.xOffset);
            g.translate(topShadow, leftShadow);
        }
        g.drawRenderedImage(shadow, AffineTransform.getTranslateInstance(this.xOffset, this.yOffset));
        if (!this.shadowOnly) {
            g.setComposite(AlphaComposite.SrcOver);
            g.drawRenderedImage(src, null);
        }
        g.dispose();
        return dst;
    }

    public String toString() {
        return "Stylize/Drop Shadow...";
    }
}

