/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class Animate {
    public static final int RUN_TIME = 100;
    private JPanel panel;
    private Rectangle from;
    private Rectangle to;
    private long startTime;

    public Animate(JPanel panel, Rectangle from, Rectangle to) {
        this.panel = panel;
        this.from = from;
        this.to = to;
    }

    public void start() {
        Timer timer = new Timer(5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long duration = System.currentTimeMillis() - Animate.this.startTime;
                double progress = (double)duration / 100.0;
                if (progress > 1.0) {
                    progress = 1.0;
                    ((Timer)e.getSource()).stop();
                }
                Rectangle target = Animate.calculateProgress(Animate.this.from, Animate.this.to, progress);
                Animate.this.panel.setBounds(target);
            }
        });
        timer.setRepeats(true);
        timer.setCoalesce(true);
        timer.setInitialDelay(0);
        this.startTime = System.currentTimeMillis();
        timer.start();
    }

    public static Rectangle calculateProgress(Rectangle startBounds, Rectangle targetBounds, double progress) {
        Rectangle bounds = new Rectangle();
        if (startBounds != null && targetBounds != null) {
            bounds.setLocation(Animate.calculateProgress(startBounds.getLocation(), targetBounds.getLocation(), progress));
            bounds.setSize(Animate.calculateProgress(startBounds.getSize(), targetBounds.getSize(), progress));
        }
        return bounds;
    }

    public static Point calculateProgress(Point startPoint, Point targetPoint, double progress) {
        Point point = new Point();
        if (startPoint != null && targetPoint != null) {
            point.x = Animate.calculateProgress(startPoint.x, targetPoint.x, progress);
            point.y = Animate.calculateProgress(startPoint.y, targetPoint.y, progress);
        }
        return point;
    }

    public static int calculateProgress(int startValue, int endValue, double fraction) {
        int value = 0;
        int distance = endValue - startValue;
        value = (int)Math.round((double)distance * fraction);
        return value += startValue;
    }

    public static Dimension calculateProgress(Dimension startSize, Dimension targetSize, double progress) {
        Dimension size = new Dimension();
        if (startSize != null && targetSize != null) {
            size.width = Animate.calculateProgress(startSize.width, targetSize.width, progress);
            size.height = Animate.calculateProgress(startSize.height, targetSize.height, progress);
        }
        return size;
    }
}

