/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.win.frame.ui.VisibilityChangedListener;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CollapsableSidePanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final int _5 = 5;
    private static final long serialVersionUID = 1L;
    private boolean _expanded;
    private JComponent _content;
    private int _width;
    private boolean _overResizer = false;
    private Point _startPoint;
    private static final int MIN_WIDTH = 150;
    private static final int MAX_WIDTH = 900;
    private static final int START_WIDTH = 300;
    private transient int maxWidth = 300;
    private ArrayList<VisibilityChangedListener> visibilityChangedListeners = new ArrayList();

    public CollapsableSidePanel(JComponent content) {
        this._content = content;
        this._width = 300;
        this.setVisible(false);
        this._expanded = false;
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.add((Component)this._content, "Center");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public final void setWidth(int width) {
        this._width = width;
    }

    @Override
    public final int getWidth() {
        return this._width;
    }

    public final void setContent(JComponent newContent) {
        this.remove(this._content);
        this._content = newContent;
        this.add((Component)this._content, "Center");
        this.revalidate();
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                CollapsableSidePanel.this.repaint();
            }
        });
    }

    public final void expand() {
        if (this._expanded) {
            return;
        }
        this.setVisible(true);
        this._expanded = true;
        this.notifyVisibilityChangedListeners();
    }

    public final void toggle() {
        if (this._expanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public final void collapse() {
        if (!this._expanded) {
            return;
        }
        this.setVisible(false);
        this._expanded = false;
        this.notifyVisibilityChangedListeners();
    }

    public final void addVisibilityChangedListener(VisibilityChangedListener listener) {
        if (!this.visibilityChangedListeners.contains(listener)) {
            this.visibilityChangedListeners.add(listener);
        }
    }

    public final void removeVisibilityChangedListener(VisibilityChangedListener listener) {
        this.visibilityChangedListeners.remove(listener);
    }

    private void notifyVisibilityChangedListeners() {
        for (VisibilityChangedListener listener : this.visibilityChangedListeners) {
            listener.visibilityChanged(this._expanded);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(Math.min(this.maxWidth, Math.max(150, this._width)), 0);
    }

    @Override
    public final Dimension getMinimumSize() {
        return new Dimension(Math.min(this.maxWidth, Math.max(150, this._width)), 0);
    }

    @Override
    public final Dimension getMaximumSize() {
        return new Dimension(Math.min(this.maxWidth, Math.max(150, this._width)), 0);
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (this._overResizer) {
            this._width = (int)((double)this._width + (this._startPoint.getX() - (double)e.getX()));
            this._width = Math.min(this.maxWidth, Math.max(150, this._width));
            this.revalidate();
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        this._startPoint = e.getPoint();
        if (e.getX() < 5) {
            MainFrameUtilities.getMainFrame().setCursor(Cursor.getPredefinedCursor(11));
            this._overResizer = true;
        } else {
            MainFrameUtilities.getMainFrame().setCursor(Cursor.getDefaultCursor());
            this._overResizer = false;
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this._startPoint = e.getPoint();
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        MainFrameUtilities.getMainFrame().setCursor(Cursor.getDefaultCursor());
    }

    public final void setRestrictSize(boolean doResitrict) {
        this.maxWidth = doResitrict ? 600 : 900;
    }
}

