/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.win.frame.ui.CollapsableSidePanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.ToggleIconButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.VisibilityChangedListener;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class CollapsableTogglePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final CollapsableSidePanel _collapsablePanel;
    final ArrayList<ToggleIconButton> _iconButtons = new ArrayList();
    private final transient ToggleIconButton hideButton;
    final JPanel _iconsContainer;
    private Color _backgroundColour;
    private Color _hoverBackgroundColour;
    private Color _pressedBackgroundColour;
    private JLabel _selectedIcon;
    private transient ArrayList<ISidePanel> _sidePanels = new ArrayList();
    private static final String NOTES_PANEL_ID = "com.thinkbuzan.gaia.ui.sidepanels.notes";
    private static final String OUTLINE_PANEL_ID = "com.thinkbuzan.gaia.ui.sidepanels.outline";

    public CollapsableTogglePanel() {
        this.setLayout(new BorderLayout());
        this._backgroundColour = Color.decode("#f1f1f1");
        this._hoverBackgroundColour = Color.decode("#d5e1f2");
        this._pressedBackgroundColour = Color.decode("#b1d6f0");
        this.setBackground(this._backgroundColour);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        JPanel sideContent = new JPanel();
        sideContent.setBackground(Color.white);
        this._collapsablePanel = new CollapsableSidePanel(sideContent){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintBorder(Graphics g) {
                g.setColor(ToggleIconButton.SELECTED_BORDER_COLOUR);
                int gap = CollapsableTogglePanel.this.hideButton.getHeight() - 1;
                g.drawLine(0, 5, this.getWidth(), 5);
                int yPoint = 5;
                if (CollapsableTogglePanel.this._collapsablePanel.isShowing()) {
                    Point l = SwingUtilities.convertPoint(CollapsableTogglePanel.this.hideButton, 0, 0, CollapsableTogglePanel.this._collapsablePanel);
                    g.drawLine(0, 5, 0, l.y);
                    g.setColor(ToggleIconButton.SELECTED_BACKGROUND);
                    g.drawLine(0, l.y + 1, 0, l.y + gap);
                    g.setColor(ToggleIconButton.SELECTED_BORDER_COLOUR);
                    yPoint = l.y + gap;
                }
                if (CollapsableTogglePanel.this._selectedIcon != null) {
                    Point location = SwingUtilities.convertPoint(CollapsableTogglePanel.this._selectedIcon, 0, 0, CollapsableTogglePanel.this._collapsablePanel);
                    g.drawLine(0, yPoint, 0, location.y);
                    g.setColor(ToggleIconButton.SELECTED_BACKGROUND);
                    g.drawLine(0, location.y + 1, 0, location.y + gap);
                    g.setColor(ToggleIconButton.SELECTED_BORDER_COLOUR);
                    g.drawLine(0, location.y + gap, 0, this.getHeight() - 5);
                } else {
                    g.drawLine(0, yPoint, 0, this.getHeight() - 5);
                }
                g.drawLine(0, this.getHeight() - 5, this.getWidth(), this.getHeight() - 5);
            }
        };
        this._collapsablePanel.addVisibilityChangedListener(new VisibilityChangedListener(){

            @Override
            public void visibilityChanged(final boolean visible) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CollapsableTogglePanel.this.hideButton.setVisible(visible);
                        CollapsableTogglePanel.this._collapsablePanel.revalidate();
                        CollapsableTogglePanel.this._collapsablePanel.repaint();
                        CollapsableTogglePanel.this.hideButton.revalidate();
                        CollapsableTogglePanel.this.hideButton.repaint();
                    }
                });
            }
        });
        this._collapsablePanel.setBackground(Color.decode("#f1f1f1"));
        Border outside = BorderFactory.createEmptyBorder(5, 0, 5, 0);
        MatteBorder inside = BorderFactory.createMatteBorder(1, 1, 1, 0, Color.decode("#c6c6c6"));
        this._collapsablePanel.setBorder(BorderFactory.createCompoundBorder(outside, inside));
        JPanel iconPanel = new JPanel();
        iconPanel.setOpaque(false);
        iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        iconPanel.setBackground(Color.decode("#f1f1f1"));
        iconPanel.setLayout(new BoxLayout(iconPanel, 1));
        iconPanel.add(Box.createVerticalGlue());
        this._iconsContainer = new JPanel();
        this._iconsContainer.setOpaque(false);
        this._iconsContainer.setLayout(new BoxLayout(this._iconsContainer, 1));
        this.hideButton = this.createIconLabel(new JPanel(), ResourceManager.getImageIcon("Side_Panel_minimise@2x.png", 0), "", ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.collapse"), false);
        this.hideButton.setSelected(true);
        this.hideButton.setVisible(false);
        this.hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CollapsableTogglePanel.this._collapsablePanel.collapse();
                if (CollapsableTogglePanel.this._selectedIcon != null) {
                    ((ToggleIconButton)CollapsableTogglePanel.this._selectedIcon).setSelected(false);
                }
            }
        });
        JPanel w = new JPanel(new BorderLayout());
        w.setOpaque(false);
        w.add((Component)this.hideButton, "North");
        this._iconsContainer.add(Box.createVerticalStrut(10));
        this._iconsContainer.add(w);
        this._iconsContainer.add(Box.createVerticalGlue());
        JPanel w2 = new JPanel(new BorderLayout());
        w2.setOpaque(false);
        w2.add(Box.createVerticalStrut(30), "South");
        this._iconsContainer.add(Box.createVerticalGlue());
        this._iconsContainer.add(w2);
        this._iconsContainer.add(Box.createVerticalStrut(5));
        iconPanel.add(this._iconsContainer);
        iconPanel.add(Box.createVerticalGlue());
        this.add((Component)this._collapsablePanel, "Center");
        this.add((Component)iconPanel, "West");
    }

    private ToggleIconButton createIconLabel(final JComponent content, ImageIcon icon, final String panelId, String panelLabel, boolean addMouseListener) {
        final ToggleIconButton iconLabel = new ToggleIconButton(icon, 0, panelLabel);
        iconLabel.setOpaque(false);
        iconLabel.setBackground(this._backgroundColour);
        iconLabel.setAlignmentX(0.5f);
        iconLabel.setAlignmentY(0.0f);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        if (addMouseListener) {
            iconLabel.addMouseListener(new MouseAdapter(){
                boolean _isHovering;
                boolean _isPressed;

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    CollapsableTogglePanel.this._collapsablePanel.setContent(content);
                    CollapsableTogglePanel.this._collapsablePanel.setRestrictSize(!CollapsableTogglePanel.NOTES_PANEL_ID.equalsIgnoreCase(panelId) && !CollapsableTogglePanel.OUTLINE_PANEL_ID.equalsIgnoreCase(panelId));
                    if (iconLabel.isSelected()) {
                        CollapsableTogglePanel.this._collapsablePanel.collapse();
                    } else {
                        CollapsableTogglePanel.this._collapsablePanel.expand();
                    }
                    iconLabel.setSelected(!iconLabel.isSelected());
                    if (iconLabel.isSelected()) {
                        CollapsableTogglePanel.this._selectedIcon = iconLabel;
                    }
                    for (ToggleIconButton button : CollapsableTogglePanel.this._iconButtons) {
                        if (button.equals(iconLabel)) continue;
                        button.setSelected(false);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this._isPressed = true;
                    iconLabel.setBackground(CollapsableTogglePanel.this._pressedBackgroundColour);
                    CollapsableTogglePanel.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this._isPressed = false;
                    iconLabel.setBackground(CollapsableTogglePanel.this._backgroundColour);
                    CollapsableTogglePanel.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    this._isHovering = true;
                    iconLabel.setBackground(CollapsableTogglePanel.this._hoverBackgroundColour);
                    CollapsableTogglePanel.this.revalidate();
                    CollapsableTogglePanel.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this._isHovering = false;
                    if (this._isPressed) {
                        iconLabel.setBackground(CollapsableTogglePanel.this._pressedBackgroundColour);
                    } else {
                        iconLabel.setBackground(CollapsableTogglePanel.this._backgroundColour);
                    }
                    CollapsableTogglePanel.this.revalidate();
                    CollapsableTogglePanel.this.repaint();
                }
            });
        }
        return iconLabel;
    }

    public final void addIconPanel(ISidePanel panel) {
        ToggleIconButton iconButton = this.createIconLabel(panel.getComponent(), (ImageIcon)panel.getIcon(), panel.getID(), panel.getLabel(), true);
        iconButton.setName(panel.getID());
        this._sidePanels.add(panel);
        this._iconButtons.add(iconButton);
        int insertPos = this._iconsContainer.getComponentCount() - 3;
        this._iconsContainer.add((Component)iconButton, insertPos);
        this._iconsContainer.add(Box.createVerticalStrut(5), insertPos);
    }

    public final void showSidePanel(String panelId) {
        for (ToggleIconButton button : this._iconButtons) {
            if (button.getName() == null || !button.getName().equalsIgnoreCase(panelId) || !button.isVisible() || button.isSelected()) continue;
            button.dispatchEvent(new MouseEvent(button, 500, 0L, 0, 0, 0, 1, false));
        }
    }

    public final void updateSidePanelsForView(String viewId) {
        for (ISidePanel spanel : this._sidePanels) {
            for (ToggleIconButton button : this._iconButtons) {
                if (button.getName() == null || !button.getName().equalsIgnoreCase(spanel.getID())) continue;
                boolean wasVisible = button.isVisible() && button.isSelected();
                boolean setVisible = spanel.supportsView(viewId);
                if (wasVisible && !setVisible) {
                    button.dispatchEvent(new MouseEvent(button, 500, 0L, 0, 0, 0, 1, false));
                }
                button.setVisible(setVisible);
            }
        }
        this.revalidate();
    }
}

