/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.thinkbuzan.apollo.ui.win.frame.ui.MindMapFrame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class FrameDocker
implements KeyEventDispatcher {
    private MindMapFrame frame;
    public static final int UNDOCKED = -1;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM_LEFT = 4;
    public static final int BOTTOM_RIGHT = 5;
    public static final int TOP = 6;

    private static boolean isWinKeyDown() {
        short x = User32.INSTANCE.GetKeyState(91);
        short y = User32.INSTANCE.GetKeyState(92);
        return x == -127 || x == -128 || y == -127 || y == -128;
    }

    FrameDocker(MindMapFrame frameIn) {
        this.frame = frameIn;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() == 402) {
            this.keyReleased(e);
        }
        return false;
    }

    public void keyReleased(KeyEvent e) {
        boolean winKeyDown = FrameDocker.isWinKeyDown();
        if (winKeyDown) {
            if (e.getKeyCode() == 37) {
                this.moveLeft();
            } else if (e.getKeyCode() == 39) {
                this.moveRight();
            }
        }
    }

    private static HashMap<String, GraphicsConfiguration> getGraphicsConfigurationMap() {
        GraphicsDevice[] d;
        HashMap<String, GraphicsConfiguration> configs = new HashMap<String, GraphicsConfiguration>();
        for (GraphicsDevice gd : d = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration[] gcs;
            for (GraphicsConfiguration gc : gcs = gd.getConfigurations()) {
                configs.put(gd.getIDstring(), gc);
            }
        }
        return configs;
    }

    private void moveLeft() {
        int dockPosition = this.frame.getDockPosition();
        HashMap<String, GraphicsConfiguration> configs = FrameDocker.getGraphicsConfigurationMap();
        GraphicsConfiguration config = configs.get(this.frame.getGraphicsConfiguration().getDevice().getIDstring());
        if (config == null) {
            return;
        }
        Rectangle bounds = config.getBounds();
        int halfWidth = (int)(bounds.getWidth() / 2.0);
        List<Rectangle> sortedBounds = FrameDocker.getSortedBounds();
        if (!this.frame.isDocked()) {
            this.frame.setBounds(bounds.x, bounds.y, halfWidth, (int)bounds.getHeight());
            this.frame.setDockPosition(2);
        } else {
            switch (dockPosition) {
                case 3: {
                    this.frame.minimise();
                    break;
                }
                case 2: {
                    boolean goneLeft;
                    int i = 0;
                    for (Rectangle r : sortedBounds) {
                        if (r.equals(bounds)) break;
                        ++i;
                    }
                    if (i == 0) {
                        i = sortedBounds.size() - 1;
                        goneLeft = false;
                    } else {
                        --i;
                        goneLeft = true;
                    }
                    Rectangle nextBounds = sortedBounds.get(i);
                    this.frame.setBounds(nextBounds.x + nextBounds.width / 2, nextBounds.y, nextBounds.width / 2, nextBounds.height);
                    this.frame.setDockPosition(3);
                    Rectangle oldMinimiseBounds = this.frame.getMinimiseBounds();
                    oldMinimiseBounds.x = goneLeft ? (oldMinimiseBounds.x -= nextBounds.width) : (oldMinimiseBounds.x += nextBounds.width);
                    this.frame.setMinimiseBounds(oldMinimiseBounds);
                }
            }
        }
    }

    private void moveRight() {
        int dockPosition = this.frame.getDockPosition();
        HashMap<String, GraphicsConfiguration> configs = FrameDocker.getGraphicsConfigurationMap();
        GraphicsConfiguration config = configs.get(this.frame.getGraphicsConfiguration().getDevice().getIDstring());
        if (config == null) {
            return;
        }
        Rectangle bounds = config.getBounds();
        int halfWidth = (int)(bounds.getWidth() / 2.0);
        List<Rectangle> sortedBounds = FrameDocker.getSortedBounds();
        if (!this.frame.isDocked()) {
            this.frame.setBounds(bounds.x + halfWidth, bounds.y, halfWidth, (int)bounds.getHeight());
            this.frame.setDockPosition(3);
        } else {
            switch (dockPosition) {
                case 2: {
                    this.frame.minimise();
                    break;
                }
                case 3: {
                    boolean goneRight;
                    int i = 0;
                    for (Rectangle r : sortedBounds) {
                        if (r.equals(bounds)) break;
                        ++i;
                    }
                    if (i == 0) {
                        i = sortedBounds.size() - 1;
                        goneRight = false;
                    } else {
                        --i;
                        goneRight = true;
                    }
                    Rectangle nextBounds = sortedBounds.get(i);
                    this.frame.setBounds(nextBounds.x, nextBounds.y, nextBounds.width / 2, nextBounds.height);
                    this.frame.setDockPosition(2);
                    Rectangle oldMinimiseBounds = this.frame.getMinimiseBounds();
                    oldMinimiseBounds.x = goneRight ? (oldMinimiseBounds.x -= nextBounds.width) : (oldMinimiseBounds.x += nextBounds.width);
                    this.frame.setMinimiseBounds(oldMinimiseBounds);
                }
            }
        }
    }

    public static List<Rectangle> getSortedBounds() {
        HashMap<String, GraphicsConfiguration> configs = FrameDocker.getGraphicsConfigurationMap();
        Comparator<Rectangle> comparator = new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.x < o2.x) {
                    return -1;
                }
                if (o1.x > o2.x) {
                    return 1;
                }
                return 0;
            }
        };
        ArrayList<Rectangle> sortedBounds = new ArrayList<Rectangle>(configs.size());
        for (GraphicsConfiguration c : configs.values()) {
            sortedBounds.add(c.getBounds());
        }
        Collections.sort(sortedBounds, comparator);
        return sortedBounds;
    }

    public static interface User32
    extends Library {
        public static final User32 INSTANCE = (User32)Native.loadLibrary((String)(Platform.isWindows() ? "User32" : "c"), User32.class);

        public short GetKeyState(int var1);
    }
}

