/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.win.frame.ui.FrameDocker;
import com.thinkbuzan.apollo.ui.win.frame.ui.MindMapFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import org.apache.log4j.Logger;

public class FrameMouseHandler
implements MouseMotionListener,
MouseListener {
    private static final Logger LOGGER = Logger.getLogger(FrameMouseHandler.class);
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private boolean _isDragging = false;
    private Dimension _frameStartSize;
    private Point _frameStartPosition;
    private Point _dragStartMousePosition;
    private Point _cumulativeDragAmount;
    private Point _resizeLimitPoint;
    private boolean _dockedAtStart;
    private static final Dimension MIN_SIZE = new Dimension(100, 100);
    private final MindMapFrame _frame;
    private final int _resizeBorderThickness;
    private int _cursor;
    private transient boolean dockOnRelease;
    private transient int dockPosition;

    public boolean isDragging() {
        return this._isDragging;
    }

    public FrameMouseHandler(MindMapFrame frame, int resizeBorderThickness) {
        this._frame = frame;
        this._resizeBorderThickness = resizeBorderThickness;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this._isDragging) {
            this._isDragging = true;
            this._frameStartSize = this._frame.getSize();
            this._frameStartPosition = this._frame.getLocation();
            this._dragStartMousePosition = e.getPoint();
            this._cumulativeDragAmount = new Point(this._frameStartPosition.x, this._frameStartPosition.y);
            this._resizeLimitPoint = new Point();
            this._resizeLimitPoint.x = (int)(this._frame.getLocation().getX() + (double)this._frame.getWidth() - this._frame.getMinimumSize().getWidth());
            this._resizeLimitPoint.y = (int)(this._frame.getLocation().getY() + (double)this._frame.getHeight() - this._frame.getMinimumSize().getHeight());
        }
        double newWidth = this._frameStartSize.getWidth();
        double newHeight = this._frameStartSize.getHeight();
        double newX = this._frameStartPosition.getX();
        double newY = this._frameStartPosition.getY();
        double dx = e.getPoint().getX() - this._dragStartMousePosition.getX();
        double dy = e.getPoint().getY() - this._dragStartMousePosition.getY();
        this._cumulativeDragAmount.x += (int)dx;
        this._cumulativeDragAmount.y += (int)dy;
        if (this._frame.isMaximised() || this._frame.isDocked()) {
            this._dockedAtStart = this._frame.isDocked();
            this._frame.minimise();
            this._frameStartSize = this._frame.getSize();
            newWidth = this._frameStartSize.getWidth();
            newHeight = this._frameStartSize.getHeight();
            this._dragStartMousePosition.x = this._frame.getWidth() / 2;
        } else {
            newX = this._cumulativeDragAmount.getX();
            newY = this._cumulativeDragAmount.getY();
        }
        this._frame.setLocation((int)newX, (int)newY);
        List<Rectangle> sortedBounds = FrameDocker.getSortedBounds();
        int left = sortedBounds.get((int)0).x;
        int right = sortedBounds.get((int)(sortedBounds.size() - 1)).x + sortedBounds.get((int)(sortedBounds.size() - 1)).width - 1;
        this.dockOnRelease = true;
        if (e.getXOnScreen() <= left + 1) {
            this.dockPosition = 2;
        } else if (e.getXOnScreen() >= right) {
            this.dockPosition = 3;
        } else if (e.getYOnScreen() == 0) {
            this.dockPosition = 6;
        } else {
            this.dockOnRelease = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getY() < 50) {
            if (this._frame.isMaximised() || this._frame.isDocked()) {
                this._frame.minimise();
            } else {
                this._frame.maximise();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._isDragging = false;
        this._frame.setCursor(Cursor.getDefaultCursor());
        this._frame.repaint();
        if (!this.dockOnRelease) {
            if (this._cumulativeDragAmount != null) {
                this._frame.getMinimiseBounds().x = (int)this._cumulativeDragAmount.getX();
                this._frame.getMinimiseBounds().y = (int)this._cumulativeDragAmount.getY();
            }
        } else if (this.dockOnRelease && !this._frame.isMaximised()) {
            List<Rectangle> sortedBounds = FrameDocker.getSortedBounds();
            switch (this.dockPosition) {
                case 2: {
                    this._frame.setDockPosition(2);
                    this.setMinimiseBounds();
                    Rectangle leftBounds = sortedBounds.get(0);
                    this._frame.setBounds(leftBounds.x, leftBounds.y, leftBounds.width / 2, leftBounds.height);
                    break;
                }
                case 3: {
                    this._frame.setDockPosition(3);
                    this.setMinimiseBounds();
                    Rectangle rightBounds = sortedBounds.get(sortedBounds.size() - 1);
                    this._frame.setBounds(rightBounds.x + rightBounds.width / 2, rightBounds.y, rightBounds.width / 2, rightBounds.height);
                    break;
                }
                case 6: {
                    this._frame.maximise();
                    if (this._dockedAtStart) break;
                    this.setMinimiseBounds();
                    this._dockedAtStart = false;
                }
            }
        }
    }

    private void setMinimiseBounds() {
        this._frame.setMinimiseBounds(new Rectangle(this._frameStartPosition.x, this._frameStartPosition.y, this._frameStartSize.width, this._frameStartSize.height));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._frame.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

