/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MapPreviewPanel
extends JPanel {
    private static final int _6 = 6;
    private static final int _3 = 3;
    private static final long serialVersionUID = 1L;
    private static final Dimension SIZE = new Dimension(150, 84);
    private static final Dimension LABEL_SIZE = new Dimension(140, 15);
    private static final Color DROPBOX_COLOUR = Color.decode("#0089d1");
    private static final Color GOOGLE_DRIVE_COLOUR = Color.decode("#fa4a42");
    private IEditorView _editor;
    private boolean _isSelected;
    private JLabel _editorNameLabel;
    private JLabel _imageLabel;
    private JButton _closeButton;
    private static final String UNTITLED_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.untitled");

    public final IEditorView getEditor() {
        return this._editor;
    }

    public final boolean isSelected() {
        return this._isSelected;
    }

    public MapPreviewPanel(IEditorView editor) {
        this._editor = editor;
        this.setBackground(Color.decode("#0067b0"));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 6));
        this.setLayout(new BoxLayout(this, 1));
        BufferedImage mmImage = editor.getMindMapImage(SIZE);
        this._imageLabel = new JLabel(new ImageIcon(mmImage)){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (MapPreviewPanel.this._editor.isThirdPartyCloudMap()) {
                    MapPreviewPanel.this.setBorders();
                    Graphics2D g2d = (Graphics2D)g.create();
                    BufferedImage cloudIcon = MapPreviewPanel.this._editor.isDropboxMap() ? ResourceManager.getBufferedImage("dropbox.png") : ResourceManager.getBufferedImage("googledrive.png");
                    g2d.drawImage((Image)cloudIcon, SIZE.width - cloudIcon.getWidth(), SIZE.height - cloudIcon.getHeight(), null);
                    g2d.dispose();
                }
            }
        };
        this._imageLabel.setOpaque(true);
        this._imageLabel.setBackground(Color.white);
        this._imageLabel.setMinimumSize(SIZE);
        this._imageLabel.setMaximumSize(SIZE);
        this._imageLabel.setPreferredSize(SIZE);
        this.setBorders();
        this._editorNameLabel = new JLabel(editor.getEditorName(), 0);
        this._editorNameLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)10.0f));
        if (this._editorNameLabel.getText() == null || this._editorNameLabel.getText().equals("")) {
            this._editorNameLabel.setText(UNTITLED_TEXT);
        }
        this._editorNameLabel.setForeground(Color.white);
        this._editorNameLabel.setMaximumSize(LABEL_SIZE);
        this._editorNameLabel.setPreferredSize(LABEL_SIZE);
        this._editorNameLabel.setMinimumSize(LABEL_SIZE);
        this._closeButton = new JButton("\uf072");
        this._closeButton.setFont(new Font("Marlett", 0, 10));
        this._closeButton.setOpaque(false);
        this._closeButton.setFocusPainted(false);
        this._closeButton.setContentAreaFilled(false);
        this._closeButton.setFocusable(false);
        this._closeButton.setBorderPainted(false);
        this._closeButton.setForeground(Color.white);
        this._closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.CloseAction", new Object[]{MapPreviewPanel.this._editor});
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel topRow = new JPanel();
        topRow.setOpaque(false);
        topRow.setLayout(new BoxLayout(topRow, 0));
        topRow.add(Box.createHorizontalGlue());
        topRow.add(this._closeButton);
        JPanel middleRow = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return SIZE;
            }
        };
        middleRow.setOpaque(false);
        middleRow.setLayout(new BoxLayout(middleRow, 0));
        middleRow.add(this._imageLabel);
        JPanel bottomRow = new JPanel();
        bottomRow.setOpaque(false);
        bottomRow.setLayout(new BoxLayout(bottomRow, 0));
        bottomRow.add(Box.createHorizontalGlue());
        bottomRow.add(this._editorNameLabel);
        bottomRow.add(Box.createHorizontalGlue());
        this.add(topRow);
        this.add(middleRow);
        this.add(bottomRow);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (MapPreviewPanel.this._isSelected) {
                    MapPreviewPanel.this.setBackground(Color.decode("#0067b0").darker().darker());
                } else {
                    MapPreviewPanel.this.setBackground(Color.decode("#0067b0").brighter());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (MapPreviewPanel.this._isSelected) {
                    MapPreviewPanel.this.setBackground(Color.decode("#0067b0").darker());
                } else {
                    MapPreviewPanel.this.setBackground(Color.decode("#0067b0"));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (ServiceManager.getEditorManager().getCurrentEditorComponent().getId().equals(MapPreviewPanel.this._editor.getId())) {
                        return;
                    }
                    ServiceManager.getEditorManager().switchFocusToEditorComponent(MapPreviewPanel.this._editor.getId());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void setBorders() {
        if (this._editor.isDropboxMap()) {
            this._imageLabel.setBorder(BorderFactory.createLineBorder(DROPBOX_COLOUR));
        } else if (this._editor.isGoogleDriveMap()) {
            this._imageLabel.setBorder(BorderFactory.createLineBorder(GOOGLE_DRIVE_COLOUR));
        } else {
            this._imageLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        }
    }

    public final void setSelected(boolean flag) {
        this._isSelected = flag;
        this.setBorders();
        if (flag) {
            this.setBackground(Color.decode("#0067b0").darker());
        } else {
            this.setBackground(Color.decode("#0067b0"));
        }
    }

    public final void setText(String string) {
        this._editorNameLabel.setText(string);
        this.setBorders();
    }

    public final void refreshPreviewImage() {
        if (this._editor == null) {
            return;
        }
        if (this._imageLabel == null) {
            return;
        }
        this.setBorders();
        BufferedImage mmImage = this._editor.getMindMapImage(SIZE);
        if (mmImage != null) {
            this._imageLabel.setIcon(new ImageIcon(mmImage));
        }
    }
}

