/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.dialogs.HelpDialog;
import com.thinkbuzan.apollo.dialogs.notifications.NotificationsLabel;
import com.thinkbuzan.apollo.ui.core.win.component.CommandButton;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.CollapsableTogglePanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.FrameDocker;
import com.thinkbuzan.apollo.ui.win.frame.ui.FrameMouseHandler;
import com.thinkbuzan.apollo.ui.win.frame.ui.MapOutlinePanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPinToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.ZoomSlider;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.ContextTabTopper;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.Tab;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.TabbedRibbon;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanel;
import com.thinkbuzan.gaia.version.VersionManager;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.SketchModeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import com.thinkbuzan.pascal.services.notifications.INotificationController;
import com.thinkbuzan.pascal.services.overlay.IGlobalOverlayManager;
import com.thinkbuzan.pascal.services.overlay.IOverlay;
import com.thinkbuzan.pascal.services.ui.IMainFrame;
import com.thinkbuzan.phoenix.fullscreen.FullScreenListener;
import com.thinkbuzan.phoenix.fullscreen.FullScreenState;
import com.thinkbuzan.phoenix.licensing.License;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class MindMapFrame
extends JFrame
implements IGlobalOverlayManager,
FullScreenListener,
IMainFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MindMapFrame.class);
    private static final String WINDOW_TITLE_DEFAULT = "com.thinkbuzan.i18n.imindmap.windowtitle";
    private static final String WINDOW_TITLE_BASIC = "com.thinkbuzan.i18n.imindmap.windowtitle.basic";
    private static final String WINDOW_TITLE_TRIAL = "com.thinkbuzan.i18n.imindmap.windowtitle.trial";
    private static final String WINDOW_TITLE_HOME = "com.thinkbuzan.i18n.imindmap.windowtitle.home";
    private static final String WINDOW_TITLE_ULTIMATE = "com.thinkbuzan.i18n.imindmap.windowtitle.ultimate";
    private static final String WINDOW_TITLE_FULL_LICENSED_TO = "com.thinkbuzan.i18n.imindmap.windowtitle.licensedto";
    private static final int MAX_MIN_BUTTON_INDEX = 2;
    private Rectangle maxBounds;
    int _frameState;
    int _previousFrameState;
    final Border focusedBorder;
    final Border unfocusedBorder;
    final FrameMouseHandler _mouseHandler;
    final JFrame thisFrame;
    final JPanel _mainPanel;
    final JPanel _rightCommandPanel;
    final JPanel _leftCommandPanel;
    QuickMapSwitchPanel _quickMapSwitchPanel;
    MapOutlinePanel _mapOutlinePanel;
    TabbedRibbon _tabbedRibbon;
    final JPanel _titleBar;
    JLabel _titleLabel;
    JLabel _quickMapSwitchButton;
    JLabel _bottomBarLabel;
    private String _licenseName;
    private String _mapName;
    private String _presentationName;
    final CommandButton _maximiseButton;
    final CommandButton _minimiseButton;
    private final SelectionListener _selectionListener;
    private final SketchModeListener _sketchListener;
    private JPanel centralPanel;
    private CardLayout cardLayout;
    private HashMap<String, HashMap<String, JComponent>> viewComponentsForDocId;
    final NotificationsLabel notificationsLabel;
    private boolean docked;
    private int dockPosition;
    private transient CollapsableTogglePanel _rightPanel;
    private JLayeredPane _innerLayeredPane;
    private JLayeredPane _outerLayeredPane;
    private JPanel _glass;
    private JPanel topGlassBar;
    private JPanel _tt;
    private boolean _isDragging;
    private Dimension _frameStartSize;
    private Point _frameStartPosition;
    private Point _dragStartMousePosition;
    private Point _resizeLimitPoint;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private Rectangle _minimiseBounds;
    private boolean _maximised;
    private static final String IMAGE_LIBRARY_CARD = "image";
    private static final String ICON_LIBRARY_CARD = "icon";
    private ISidePanel imageLibraryPanel;
    private ISidePanel iconLibraryPanel;
    private JPanel imagesLabelPanel;
    private JPanel iconsLabelPanel;
    private JPanel imagesCardPanel;
    private CardLayout imagesCardLayout;
    private static final String NOTES_CARD = "notes";
    private static final String LINKS_CARD = "links";
    private ISidePanel notesPanel;
    private ISidePanel linksPanel;
    private JPanel notesLabelPanel;
    private JPanel linksLabelPanel;
    private JPanel attachmentsCardPanel;
    private CardLayout attachmentsCardLayout;
    private static final Color DESELECTED_COLOUR = Color.decode("#FAFAFA");
    private static final Color SELECTED_COLOUR = Color.decode("#E0E0E0");
    private static final Color BORDER_COLOUR = Color.decode("#C6C6C6");
    private static final int TOP_PADDING = 12;
    private static final int BOTTOM_PADDING = 13;
    private static final float HEADING_FONT_SIZE = 15.0f;
    private boolean firstLoad;
    private transient boolean fullScreen;
    private transient JPanel _topBar;
    private transient JPanel _exitBar;
    private transient JPanel _bottomBar;
    private transient JPanel _notification;
    private transient FullScreenMouseListener listener;
    boolean wasMaximised;
    int tabbedRibbonPosition;
    private boolean mapOutlineVisibility;

    public boolean isDocked() {
        return this.docked;
    }

    public void setDocked(boolean d) {
        this.docked = d;
        if (!this.docked) {
            this.dockPosition = -1;
        }
    }

    public int getDockPosition() {
        return this.dockPosition;
    }

    public void setDockPosition(int pos) {
        this.dockPosition = pos;
        this.setDocked(pos >= 0);
    }

    public MindMapFrame() {
        this._previousFrameState = this._frameState = 0;
        this.focusedBorder = BorderFactory.createLineBorder(Color.decode("#0067b0"));
        this.unfocusedBorder = BorderFactory.createLineBorder(Color.gray);
        this._titleBar = this.createJPanel();
        this._maximiseButton = this.createMaximiseButton();
        this._minimiseButton = this.createMinimiseButton();
        this.viewComponentsForDocId = new HashMap();
        this.dockPosition = -1;
        this._innerLayeredPane = new JLayeredPane();
        this._outerLayeredPane = new JLayeredPane();
        this.firstLoad = true;
        this.fullScreen = false;
        this.listener = new FullScreenMouseListener();
        this.mapOutlineVisibility = false;
        MainFrameUtilities.setMainFrame((Frame)this);
        this.notificationsLabel = new NotificationsLabel(ServiceManager.getI18n(), ServiceManager.getActionManager());
        this.thisFrame = this;
        this._mouseHandler = new FrameMouseHandler(this, 5);
        this._selectionListener = this.createSelectionListener();
        this._sketchListener = this.createSketchListener();
        this.setFrameIcon();
        this.setUndecorated(true);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setLayout(new BorderLayout());
        this._rightCommandPanel = this.createJPanel();
        this._leftCommandPanel = this.createJPanel();
        this._mainPanel = this.createJPanel();
        this.initMainPanel();
        this.initFocusListener();
        this.getContentPane().add((Component)this._outerLayeredPane, "Center");
        this.addMouseMotionListener(this._mouseHandler);
        this.addMouseListener(this._mouseHandler);
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 6) {
                    MindMapFrame.this.setExtendedState(0);
                    MindMapFrame.this.maximise();
                }
            }
        });
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new FrameDocker(this));
        this._previousFrameState = 6;
        int minimisedX = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_MINIMISED_X", 200);
        int minimisedY = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_MINIMISED_Y", 100);
        int minimisedWidth = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_MINIMISED_WIDTH", 1300);
        int minimisedHeight = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_MINIMISED_HEIGHT", 700);
        this.setMinimiseBounds(new Rectangle(minimisedX, minimisedY, minimisedWidth, minimisedHeight));
    }

    private void showMaximiseButton() {
        this._minimiseButton.reset();
        this._rightCommandPanel.remove((Component)this._minimiseButton);
        this._rightCommandPanel.remove((Component)this._maximiseButton);
        this._rightCommandPanel.add((Component)this._maximiseButton, 2);
    }

    private void showMinimiseButton() {
        this._maximiseButton.reset();
        this._rightCommandPanel.remove((Component)this._minimiseButton);
        this._rightCommandPanel.remove((Component)this._maximiseButton);
        this._rightCommandPanel.add((Component)this._minimiseButton, 2);
    }

    public void showFileTab() {
        this._tabbedRibbon.showFileTab();
        this.updateTitleBounds();
    }

    public void showFileTab(String tab) {
        this._tabbedRibbon.showFileTab(tab);
        this.updateTitleBounds();
    }

    public void showFastCaptureContextTab() {
        this._tabbedRibbon.addFastCaptureContextTab();
        this.updateTitleBounds();
    }

    public void showBrainstormContextTab() {
        this._tabbedRibbon.addBrainstormContextTab();
        this.updateTitleBounds();
    }

    public void showTimelineContextTab() {
        this._tabbedRibbon.addTimelineContextTab();
        this.updateTitleBounds();
    }

    public void hideTimelineContextTab() {
        this._tabbedRibbon.hideTimelineContextTab();
        this.updateTitleBounds();
    }

    public void hideBrainstormContextTab() {
        this._tabbedRibbon.hideBrainstormContextTab();
        this.updateTitleBounds();
    }

    public void showProjectContextTab() {
        this._tabbedRibbon.addProjectContextTab();
        this.updateTitleBounds();
    }

    public void hideProjectContextTab() {
        this._tabbedRibbon.hideProjectContextTab();
        this.updateTitleBounds();
    }

    public void showBranchContextTab() {
        this._tabbedRibbon.addBranchContextTab();
        this.updateTitleBounds();
    }

    public void hideBranchContextTab() {
        this._tabbedRibbon.hideBranchContextTab();
        this.updateTitleBounds();
    }

    public void showCommentsContextTab() {
        this._tabbedRibbon.addCommentsContextTab();
        this.updateTitleBounds();
    }

    public void hideCommentsContextTab() {
        this._tabbedRibbon.hideCommentsContextTab();
        this.updateTitleBounds();
    }

    public void showPresentationContextTab() {
        this._tabbedRibbon.addPresentationContextTab();
        this.updateTitleBounds();
    }

    public void hidePresentationContextTab() {
        this._tabbedRibbon.hidePresentationContextTab();
        this.updateTitleBounds();
    }

    public void showSketchContextTab() {
        this._tabbedRibbon.addSketchContextTab();
        this.updateTitleBounds();
    }

    public void hideSketchContextTab() {
        this._tabbedRibbon.hideSketchContextTab();
        this.updateTitleBounds();
    }

    public void hideContextTabs() {
        this._tabbedRibbon.hideContextTabs();
        this.updateTitleBounds();
    }

    public void goToHomeTab() {
        this._tabbedRibbon.setSelectedIndex(1);
    }

    public QuickMapSwitchPanel getQuickMapSwitchPanel() {
        return this._quickMapSwitchPanel;
    }

    private void removeBorders() {
        this._mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.repaint();
    }

    private void addBorders() {
        this._mainPanel.setBorder(this.focusedBorder);
        this.repaint();
    }

    private void initMainPanel() {
        this._outerLayeredPane.setLayout(new OverlayLayout(this._outerLayeredPane));
        this._outerLayeredPane.add((Component)this._mainPanel, new Integer(1));
        this._mainPanel.setLayout(new BorderLayout());
        this._tt = this.createJPanel();
        this._tt.setLayout(new BoxLayout(this._tt, 3));
        this._topBar = this.createJPanel();
        this._topBar.setPreferredSize(new Dimension(this.getWidth(), 23));
        this._licenseName = this.getTitleFromLicenseType();
        this._titleLabel = this.createJLabel(this._licenseName);
        this.setTitle(this._licenseName);
        this._titleBar.add(this._titleLabel);
        this._titleBar.setLayout(null);
        this._titleBar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MindMapFrame.this.updateTitleLabel();
            }
        });
        this._topBar.setLayout(new BorderLayout());
        this._topBar.add((Component)this._leftCommandPanel, "West");
        this._topBar.add((Component)this._titleBar, "Center");
        this._topBar.add((Component)this._rightCommandPanel, "East");
        JLabel exitFullscreen = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.exitFullScreen"), 0);
        exitFullscreen.setCursor(Cursor.getPredefinedCursor(12));
        exitFullscreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                MindMapFrame.this.toggleFullScreen();
            }
        });
        this._exitBar = new JPanel(new BorderLayout());
        this._exitBar.setOpaque(false);
        this._exitBar.add((Component)exitFullscreen, "North");
        this._exitBar.setVisible(false);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setOpaque(true);
        wrapper.add((Component)this._topBar, "North");
        wrapper.add((Component)this._exitBar, "South");
        this._tt.add(wrapper);
        this._mainPanel.add((Component)this._tt, "North");
        FileMenu filePagePanel = new FileMenu();
        filePagePanel.setVisible(false);
        this._outerLayeredPane.add((Component)filePagePanel, new Integer(2));
        this._tabbedRibbon = new TabbedRibbon(this._titleBar, filePagePanel);
        this.lockTabs();
        ServiceManager.addNotificationControllerServiceListener(new IServiceListener<INotificationController>(){

            public void serviceRemoved(INotificationController service) {
            }

            public void serviceAdded(final INotificationController service) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MindMapFrame.this.notificationsLabel.setNotificationsController(service);
                    }
                });
            }
        });
        this._tt.add(this._tabbedRibbon);
        filePagePanel.getBackButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MindMapFrame.this._tabbedRibbon.collapse();
                MindMapFrame.this._tabbedRibbon.goToPreviousTab();
            }
        });
        filePagePanel.setRibbon(this._tabbedRibbon);
        this._leftCommandPanel.setLayout(new FlowLayout(0, 0, 0));
        this._leftCommandPanel.add(this.createImmButton());
        this._leftCommandPanel.add(this.createSaveButton());
        this._leftCommandPanel.add(this.createUndoButton());
        this._leftCommandPanel.add(this.createRedoButton());
        this._rightCommandPanel.setLayout(new FlowLayout(2, 0, 0));
        this._rightCommandPanel.add(this.createHelpButton());
        this._rightCommandPanel.add(this.createIconifyButton());
        this._rightCommandPanel.add((Component)this._minimiseButton);
        this._rightCommandPanel.add(this.createExitButton());
        this._bottomBar = new JPanel();
        this._bottomBar.setBackground(Color.decode("#0067b0"));
        this._bottomBar.setPreferredSize(new Dimension(this.getWidth(), 23));
        this._bottomBar.setLayout(new BorderLayout());
        this._bottomBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        JPanel bottomRightToolsPanel = new JPanel();
        bottomRightToolsPanel.setOpaque(false);
        bottomRightToolsPanel.setLayout(new BoxLayout(bottomRightToolsPanel, 0));
        bottomRightToolsPanel.add(this.getCleanUpButton());
        bottomRightToolsPanel.add(Box.createHorizontalStrut(25));
        bottomRightToolsPanel.add(this.getMapOverviewButton());
        bottomRightToolsPanel.add(Box.createHorizontalStrut(25));
        bottomRightToolsPanel.add(new ZoomSlider());
        this._bottomBar.add((Component)bottomRightToolsPanel, "East");
        this._mainPanel.add((Component)this._bottomBar, "South");
        this.centralPanel = new JPanel();
        this.centralPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        Border inside = BorderFactory.createLineBorder(Color.decode("#c6c6c6"));
        Border outside = BorderFactory.createLineBorder(Color.decode("#f1f1f1"), 5);
        this.centralPanel.setBorder(BorderFactory.createCompoundBorder(outside, inside));
        this.centralPanel.setBackground(Color.white);
        this.cardLayout = new CardLayout();
        this.centralPanel.setLayout(this.cardLayout);
        this._innerLayeredPane.setLayout(new OverlayLayout(this._innerLayeredPane));
        this._innerLayeredPane.add((Component)this.centralPanel, new Integer(1));
        this._mainPanel.add((Component)this._innerLayeredPane, "Center");
        this._rightPanel = new CollapsableTogglePanel();
        this._mainPanel.add((Component)this._rightPanel, "East");
        this._quickMapSwitchPanel = new QuickMapSwitchPanel();
        this.addQuickMapSwitchPanelTutorial();
        this._quickMapSwitchPanel.setVisible(false);
        this._quickMapSwitchPanel.setAlignmentX(0.0f);
        this._quickMapSwitchPanel.setBackground(Color.decode("#0067b0"));
        this._innerLayeredPane.add((Component)this._quickMapSwitchPanel, new Integer(2));
        this._mapOutlinePanel = new MapOutlinePanel(this.centralPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public void setVisible(boolean aFlag) {
                boolean realVis = MindMapFrame.this.mapOutlineVisibility && aFlag;
                super.setVisible(realVis);
            }
        };
        this._mapOutlinePanel.setVisible(false);
        this._innerLayeredPane.add((Component)this._mapOutlinePanel, new Integer(3));
        this.centralPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MindMapFrame.this._mapOutlinePanel.revalidate();
                        MindMapFrame.this._mapOutlinePanel.repaint();
                    }
                });
            }
        });
        QuickMapSwitchPinToggleButton quickSwitchPin = new QuickMapSwitchPinToggleButton(this._quickMapSwitchPanel);
        QuickMapSwitchToggleButton quickSwitchPanelButton = new QuickMapSwitchToggleButton(this._quickMapSwitchPanel, quickSwitchPin);
        this._quickMapSwitchPanel.setToggleButton(quickSwitchPanelButton);
        JPanel quickSwitchButtonAndPinPanel = new JPanel(new BorderLayout());
        quickSwitchButtonAndPinPanel.setOpaque(false);
        quickSwitchButtonAndPinPanel.add((Component)quickSwitchPanelButton, "West");
        quickSwitchButtonAndPinPanel.add((Component)quickSwitchPin, "Center");
        this._bottomBar.add((Component)quickSwitchButtonAndPinPanel, "West");
        JPanel shortcutPanel = new JPanel();
        shortcutPanel.setOpaque(false);
        shortcutPanel.setLayout(new FlowLayout(1, 0, 0));
        shortcutPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
        this._bottomBarLabel = new JLabel("", 0);
        this._bottomBarLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        this._bottomBarLabel.setForeground(Color.white);
        this._bottomBarLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        shortcutPanel.add(this._bottomBarLabel);
        this._bottomBar.add((Component)shortcutPanel, "Center");
        this._glass = new JPanel();
        this._glass.setLayout(new GridBagLayout());
        this.topGlassBar = this.getResizeGrabPanel(8);
        JPanel left = this.getResizeGrabPanel(10);
        JPanel bottom = this.getResizeGrabPanel(9);
        JPanel right = this.getResizeGrabPanel(11);
        JPanel topLeft = this.getResizeGrabPanel(6);
        JPanel topRight = this.getResizeGrabPanel(7);
        JPanel bottomLeft = this.getResizeGrabPanel(4);
        JPanel bottomRight = this.getResizeGrabPanel(5);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        this._glass.add((Component)topLeft, c);
        c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.anchor = 19;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this._glass.add((Component)this.topGlassBar, c);
        c = new GridBagConstraints();
        c.anchor = 24;
        c.gridx = 2;
        c.gridy = 0;
        this._glass.add((Component)topRight, c);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 3;
        this._glass.add((Component)left, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 24;
        this._notification = new JPanel(new FlowLayout(2, 0, 0));
        this._notification.setOpaque(false);
        this._notification.add((Component)this.notificationsLabel);
        this._notification.setBorder(BorderFactory.createEmptyBorder(14, 0, 0, 0));
        this._glass.add((Component)this._notification, c);
        c = new GridBagConstraints();
        c.anchor = 22;
        c.gridx = 2;
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 3;
        this._glass.add((Component)right, c);
        c = new GridBagConstraints();
        c.anchor = 25;
        c.gridx = 0;
        c.gridy = 2;
        this._glass.add((Component)bottomLeft, c);
        c = new GridBagConstraints();
        c.anchor = 20;
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        this._glass.add((Component)bottom, c);
        c = new GridBagConstraints();
        c.anchor = 26;
        c.gridx = 2;
        c.gridy = 2;
        this._glass.add((Component)bottomRight, c);
        this.setGlassPane(this._glass);
        this._glass.setOpaque(false);
        this._glass.setVisible(true);
    }

    private JButton getMapOverviewButton() {
        JButton mapOverviewButton = new JButton((Icon)ResourceManager.getImageIcon("navigator-15.png", 15)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                this.setVisible(b);
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Point p = new Point();
                p.y = -this.getHeight();
                return p;
            }
        };
        mapOverviewButton.setBorderPainted(false);
        mapOverviewButton.setBorder(BorderFactory.createEmptyBorder());
        mapOverviewButton.setFocusPainted(false);
        mapOverviewButton.setFocusable(false);
        mapOverviewButton.setContentAreaFilled(false);
        mapOverviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ToggleMapOverviewPanelAction", new Object[0]);
            }
        });
        mapOverviewButton.setEnabled(false);
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.ToggleMapOverviewPanelAction", (JComponent)mapOverviewButton);
        mapOverviewButton.setToolTipText(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.showOverviewPanel"));
        return mapOverviewButton;
    }

    private JButton getCleanUpButton() {
        JButton cleanUpButton = new JButton((Icon)ResourceManager.getImageIcon("cleanup-15.png", 15)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                this.setVisible(b);
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Point p = new Point();
                p.y = -this.getHeight();
                return p;
            }
        };
        cleanUpButton.setBorderPainted(false);
        cleanUpButton.setBorder(BorderFactory.createEmptyBorder());
        cleanUpButton.setFocusPainted(false);
        cleanUpButton.setFocusable(false);
        cleanUpButton.setContentAreaFilled(false);
        cleanUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.CondenseAction", new Object[0]);
            }
        });
        cleanUpButton.setEnabled(false);
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.CondenseAction", (JComponent)cleanUpButton);
        cleanUpButton.setToolTipText(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.tooltips.autoLayout"));
        return cleanUpButton;
    }

    private void addQuickMapSwitchPanelTutorial() {
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceAdded(final IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){
                    boolean firstTime = true;

                    public void editorChanged(IEditorView editor) {
                        if (this.firstTime && service.getAllEditorViews().size() > 1) {
                            this.firstTime = false;
                            MindMapFrame.this._quickMapSwitchPanel.expand();
                        }
                    }
                });
            }

            public void serviceRemoved(IEditorManager service) {
            }
        });
    }

    private JPanel getResizeGrabPanel(int side) {
        JPanel p = new JPanel(new FlowLayout(0, 4, 4));
        p.setCursor(Cursor.getPredefinedCursor(side));
        p.setOpaque(false);
        p.addMouseListener(this.createMouseAdapter(p, side));
        p.addMouseMotionListener(this.createMouseAdapter(p, side));
        return p;
    }

    private MouseAdapter createMouseAdapter(final JPanel panel, final int side) {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!MindMapFrame.this._maximised) {
                    MindMapFrame.this._isDragging = false;
                    MindMapFrame.this.setCursor(Cursor.getDefaultCursor());
                    MindMapFrame.this.repaint();
                    MindMapFrame.this.setMinimiseBounds(MindMapFrame.this.getBounds());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MindMapFrame.this._maximised) {
                    panel.setCursor(Cursor.getDefaultCursor());
                } else {
                    panel.setCursor(Cursor.getPredefinedCursor(side));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!MindMapFrame.this._maximised) {
                    if (!MindMapFrame.this._isDragging) {
                        MindMapFrame.this._isDragging = true;
                        MindMapFrame.this._frameStartSize = MindMapFrame.this.getSize();
                        MindMapFrame.this._frameStartPosition = MindMapFrame.this.getLocation();
                        MindMapFrame.this._dragStartMousePosition = e.getLocationOnScreen();
                        MindMapFrame.this._resizeLimitPoint = new Point();
                        ((MindMapFrame)MindMapFrame.this)._resizeLimitPoint.x = (int)(MindMapFrame.this.getLocation().getX() + (double)MindMapFrame.this.getWidth() - MindMapFrame.this.getMinimumSize().getWidth());
                        ((MindMapFrame)MindMapFrame.this)._resizeLimitPoint.y = (int)(MindMapFrame.this.getLocation().getY() + (double)MindMapFrame.this.getHeight() - MindMapFrame.this.getMinimumSize().getHeight());
                    }
                    double newWidth = MindMapFrame.this._frameStartSize.getWidth();
                    double newHeight = MindMapFrame.this._frameStartSize.getHeight();
                    double newX = MindMapFrame.this._frameStartPosition.getX();
                    double newY = MindMapFrame.this._frameStartPosition.getY();
                    double dx = (double)e.getXOnScreen() - MindMapFrame.this._dragStartMousePosition.getX();
                    double dy = (double)e.getYOnScreen() - MindMapFrame.this._dragStartMousePosition.getY();
                    switch (side) {
                        case 8: {
                            newHeight = MindMapFrame.this.DoResize(newHeight, -dy, 1);
                            if (newHeight <= MindMapFrame.this.getMinimumSize().getHeight()) {
                                dy = MindMapFrame.this._resizeLimitPoint.getY() - MindMapFrame.this._frameStartPosition.getY();
                            }
                            newY = MindMapFrame.this.DoReposition(newY, dy);
                            break;
                        }
                        case 7: {
                            newHeight = MindMapFrame.this.DoResize(newHeight, -dy, 1);
                            if (newHeight <= MindMapFrame.this.getMinimumSize().getHeight()) {
                                dy = MindMapFrame.this._resizeLimitPoint.getY() - MindMapFrame.this._frameStartPosition.getY();
                            }
                            newY = MindMapFrame.this.DoReposition(newY, dy);
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width + dx;
                            break;
                        }
                        case 11: {
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width + dx;
                            break;
                        }
                        case 5: {
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width + dx;
                            newHeight = MindMapFrame.this.DoResize(newHeight, dy, 1);
                            break;
                        }
                        case 9: {
                            newHeight = MindMapFrame.this.DoResize(newHeight, dy, 1);
                            break;
                        }
                        case 4: {
                            newHeight = MindMapFrame.this.DoResize(newHeight, dy, 1);
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width - dx;
                            if (newWidth <= MindMapFrame.this.getMinimumSize().getWidth()) {
                                dx = MindMapFrame.this._resizeLimitPoint.getX() - MindMapFrame.this._frameStartPosition.getX();
                            }
                            newX = MindMapFrame.this.DoReposition(newX, dx);
                            break;
                        }
                        case 10: {
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width - dx;
                            if (newWidth <= MindMapFrame.this.getMinimumSize().getWidth()) {
                                dx = MindMapFrame.this._resizeLimitPoint.getX() - MindMapFrame.this._frameStartPosition.getX();
                            }
                            newX = MindMapFrame.this.DoReposition(newX, dx);
                            break;
                        }
                        case 6: {
                            newHeight = MindMapFrame.this.DoResize(newHeight, -dy, 1);
                            if (newHeight <= MindMapFrame.this.getMinimumSize().getHeight()) {
                                dy = MindMapFrame.this._resizeLimitPoint.getY() - MindMapFrame.this._frameStartPosition.getY();
                            }
                            newY = MindMapFrame.this.DoReposition(newY, dy);
                            newWidth = (double)((MindMapFrame)MindMapFrame.this)._frameStartSize.width - dx;
                            if (newWidth <= MindMapFrame.this.getMinimumSize().getWidth()) {
                                dx = MindMapFrame.this._resizeLimitPoint.getX() - MindMapFrame.this._frameStartPosition.getX();
                            }
                            newX = MindMapFrame.this.DoReposition(newX, dx);
                        }
                    }
                    MindMapFrame.this.setLocation((int)newX, (int)newY);
                    MindMapFrame.this.setSize((int)newWidth, (int)newHeight);
                    MindMapFrame.this.repaint();
                }
            }
        };
    }

    private double DoReposition(double currentPos, double change) {
        return currentPos += change;
    }

    private double DoResize(double currentSize, double change, int orientation) {
        currentSize += change;
        switch (orientation) {
            case 0: {
                return Math.max(this.getMinimumSize().getWidth(), currentSize);
            }
            case 1: {
                return Math.max(this.getMinimumSize().getHeight(), currentSize);
            }
        }
        return 0.0;
    }

    public void setBottomBarText(String text) {
        this._bottomBarLabel.setText(text);
    }

    private SelectionListener createSelectionListener() {
        return new SelectionListener(){

            public void selectionChanged(Object ... selComps) {
                if (selComps.length == 1) {
                    Class<?> clazz;
                    String className;
                    boolean isBrainstorm = false;
                    boolean isFastCapture = false;
                    boolean isTimeline = false;
                    IEditorManager editorManager = null;
                    try {
                        editorManager = ServiceManager.getEditorManager();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (editorManager != null) {
                        isBrainstorm = editorManager.getCurrentEditorComponent().getView().getId().equals("com.thinkbuzan.phoenix.view.BrainstormView");
                        isFastCapture = editorManager.getCurrentEditorComponent().getView().getId().equals("com.thinkbuzan.phoenix.view.FastCaptureView");
                        isTimeline = editorManager.getCurrentEditorComponent().getView().getId().equals("com.thinkbuzan.orion.view.TimelineView");
                    }
                    if ((className = (clazz = selComps[0].getClass()).getCanonicalName()).equals("com.mxgraph.mindmap.model.mmBranchCell") && !isBrainstorm && !isFastCapture && !isTimeline) {
                        MindMapFrame.this.showBranchContextTab();
                    } else {
                        MindMapFrame.this.hideBranchContextTab();
                    }
                } else {
                    MindMapFrame.this.hideBranchContextTab();
                }
            }
        };
    }

    private SketchModeListener createSketchListener() {
        return new SketchModeListener(){

            public void sketchToolStateChanged(boolean enabled) {
                if (enabled) {
                    MindMapFrame.this.showSketchContextTab();
                } else {
                    MindMapFrame.this.hideSketchContextTab();
                }
            }
        };
    }

    public SelectionListener getSelectionListener() {
        return this._selectionListener;
    }

    public SketchModeListener getSketchListener() {
        return this._sketchListener;
    }

    public void setQuickMapSwitchButtonText(String text) {
        this._quickMapSwitchButton.setText("\ue17d " + text);
    }

    private JPanel createJPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.decode("#f1f1f1"));
        return jPanel;
    }

    private JLabel createJLabel(String text) {
        JLabel label = new JLabel(text);
        Font font = ApplicationFont.getRegularFont((int)0, (float)12.0f);
        label.setForeground(Color.decode("#444444"));
        label.setFont(font);
        return label;
    }

    private JLabel createHelpButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VersionManager versionManager = ServiceManager.getVersionManager();
                            HelpDialog helpDialog = new HelpDialog(MainFrameUtilities.getMainFrame(), ServiceManager.getActionManager(), ServiceManager.getI18n(), ServiceManager.getPluginLicenseService(), versionManager, ServiceManager.getPreferencesService().getSystemPreferences());
                            helpDialog.setVisible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                return null;
            }
        };
        CommandButton exitButton = new CommandButton("\uf073", (Callable)c);
        return exitButton;
    }

    private JLabel createExitButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean("FRAME_MAXIMISED", MindMapFrame.this.isMaximised());
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_MINIMISED_X", ((MindMapFrame)MindMapFrame.this)._minimiseBounds.x);
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_MINIMISED_Y", ((MindMapFrame)MindMapFrame.this)._minimiseBounds.y);
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_MINIMISED_WIDTH", ((MindMapFrame)MindMapFrame.this)._minimiseBounds.width);
                ServiceManager.getPreferencesService().getCurrentUserPreferences().putInt("FRAME_MINIMISED_HEIGHT", ((MindMapFrame)MindMapFrame.this)._minimiseBounds.height);
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ShutdownAction", new Object[0]);
                return null;
            }
        };
        CommandButton exitButton = new CommandButton("\uf072", (Callable)c);
        return exitButton;
    }

    private CommandButton createMaximiseButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MindMapFrame.this.maximise();
                return null;
            }
        };
        CommandButton maximiseButton = new CommandButton("\uf031", (Callable)c);
        return maximiseButton;
    }

    public boolean isMaximised() {
        return this._maximised;
    }

    public void setMinimiseBounds(Rectangle bounds) {
        this._minimiseBounds = bounds;
    }

    public Rectangle getMinimiseBounds() {
        return this._minimiseBounds;
    }

    public void maximise() {
        this.removeBorders();
        this.showMinimiseButton();
        this._maximised = true;
        this.setDocked(false);
        Rectangle bounds = this.getRealScreenBounds();
        if (bounds != null) {
            this.setBounds(bounds);
        } else {
            this.setLocation(0, 0);
            Rectangle newBounds = this.getRealScreenBounds();
            if (newBounds != null) {
                this._minimiseBounds = new Rectangle(newBounds.x, newBounds.y, this._minimiseBounds.width, this._minimiseBounds.height);
                this.setBounds(newBounds);
            }
        }
    }

    public void minimise() {
        this.addBorders();
        this.showMaximiseButton();
        this._maximised = false;
        this.setDocked(false);
        if (this._minimiseBounds != null) {
            this.setBounds(this._minimiseBounds);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getScreenBounds();
        x = Math.max(x, bounds.x);
        y = Math.max(y, bounds.y);
        width = Math.min(width, bounds.width);
        height = Math.min(height, bounds.height);
        super.setBounds(x, y, width, height);
    }

    private Rectangle getScreenBounds() {
        Rectangle fullBounds = new Rectangle(0, 0, 1300, 700);
        try {
            GraphicsConfiguration graphicsConfiguration = null;
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                graphicsConfiguration = gd.getDefaultConfiguration();
                Rectangle screenBounds = graphicsConfiguration.getBounds();
                Dimension screenSize = screenBounds.getSize();
                screenSize.toString();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                int taskBarGap = 1;
                if (screenInsets.left != 0 || screenInsets.right != 0 || screenInsets.top != 0 || screenInsets.bottom != 0) {
                    taskBarGap = 0;
                }
                Rectangle currentScreenBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom + taskBarGap));
                fullBounds.add(currentScreenBounds);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        return fullBounds;
    }

    private Rectangle getRealScreenBounds() {
        try {
            Point p = MouseInfo.getPointerInfo().getLocation();
            GraphicsConfiguration graphicsConfiguration = null;
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!gd.getDefaultConfiguration().getBounds().contains(p)) continue;
                graphicsConfiguration = gd.getDefaultConfiguration();
                break;
            }
            if (graphicsConfiguration != null) {
                Rectangle screenBounds = graphicsConfiguration.getBounds();
                Dimension screenSize = screenBounds.getSize();
                screenSize.toString();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                int taskBarGap = 1;
                if (screenInsets.left != 0 || screenInsets.right != 0 || screenInsets.top != 0 || screenInsets.bottom != 0) {
                    taskBarGap = 0;
                }
                return new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom + taskBarGap));
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        return null;
    }

    private CommandButton createMinimiseButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MindMapFrame.this.minimise();
                return null;
            }
        };
        CommandButton minimiseButton = new CommandButton("\uf032", (Callable)c);
        return minimiseButton;
    }

    private JLabel createIconifyButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MindMapFrame.this.setExtendedState(1);
                return null;
            }
        };
        CommandButton minimiseButton = new CommandButton("\uf030", (Callable)c);
        return minimiseButton;
    }

    private JLabel createImmButton() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Robot r = new Robot();
                r.keyPress(18);
                r.keyPress(32);
                r.keyRelease(32);
                r.keyRelease(18);
                return null;
            }
        };
        Callable<Void> c2 = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                System.exit(0);
                return null;
            }
        };
        ImageIcon imgIcon = this.createImageIcon("file/imm10-orb-15px.png");
        CommandButton frameOptionsButton = new CommandButton(imgIcon, (Callable)c, (Callable)c2);
        return frameOptionsButton;
    }

    private JLabel createSaveButton() {
        String actionId = "com.thinkbuzan.gaia.actions.SaveAction";
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveAction", new Object[0]);
                return null;
            }
        };
        CommandButton saveButton = new CommandButton(this.createImageIcon("file/save-15px.png"), (Callable)c, null);
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.SaveAction", (JComponent)saveButton);
        return saveButton;
    }

    private JLabel createUndoButton() {
        String actionId = "com.thinkbuzan.gaia.actions.UndoDelegatorAction";
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.UndoDelegatorAction", new Object[0]);
                return null;
            }
        };
        CommandButton undoButton = new CommandButton(this.createImageIcon("file/undo-15px.png"), (Callable)c, null);
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.UndoDelegatorAction", (JComponent)undoButton);
        return undoButton;
    }

    private JLabel createRedoButton() {
        String actionId = "com.thinkbuzan.gaia.actions.RedoDelegatorAction";
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.RedoDelegatorAction", new Object[0]);
                return null;
            }
        };
        CommandButton redoButton = new CommandButton(this.createImageIcon("file/redo-15px.png"), (Callable)c, null);
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.RedoDelegatorAction", (JComponent)redoButton);
        return redoButton;
    }

    private ImageIcon createImageIcon(String filename) {
        Image img = null;
        try {
            InputStream input = this.getClass().getResourceAsStream("/com/thinkbuzan/apollo/ui/win/frame/ui/assets/" + filename);
            img = ImageIO.read(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Image dimg = img.getScaledInstance(15, 15, 4);
        return new ImageIcon(dimg);
    }

    private void setFrameIcon() {
        int s = 13;
        int[] sizes = new int[s];
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = 16 + ii * 2;
        }
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(s);
        for (int ii = 0; ii < sizes.length; ++ii) {
            BufferedImage imi = ResourceManager.getBufferedImage("icons/" + sizes[ii] + ".png");
            images.add(imi);
        }
        this.setIconImages(images);
    }

    private void initFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                MindMapFrame.this._mainPanel.setBorder(MindMapFrame.this.focusedBorder);
                MindMapFrame.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                MindMapFrame.this._mainPanel.setBorder(MindMapFrame.this.unfocusedBorder);
                MindMapFrame.this.repaint();
            }
        });
    }

    private String getTitleFromLicenseType() {
        String title;
        License license = ServiceManager.getPluginLicenseService().getLicense(false);
        String licensedTo = ServiceManager.getPluginLicenseService().getLicense(false).getProperty("licensedTo", null);
        switch (license.getType()) {
            case trial: {
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_TRIAL);
                if (BundleLicenser.isHomeAndStudentVersion()) {
                    title = title + " (" + ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_HOME) + ")";
                    break;
                }
                title = title + " (" + ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_ULTIMATE) + ")";
                break;
            }
            case basic: {
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_BASIC);
                break;
            }
            case homestudent: {
                if (licensedTo == null) {
                    if (license.getSerialNumber() == null || !license.getSerialNumber().matches("[\\w]{6}-[\\w]{6}-[\\w]{6}-[\\w]{6}")) {
                        LOGGER.warn((Object)"Error reading title");
                    }
                    title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_HOME);
                    break;
                }
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_FULL_LICENSED_TO, new Object[]{licensedTo});
                break;
            }
            case ultimate: {
                if (licensedTo == null) {
                    if (license.getSerialNumber() == null || !license.getSerialNumber().matches("[\\w]{6}-[\\w]{6}-[\\w]{6}-[\\w]{6}")) {
                        LOGGER.warn((Object)"Error reading title");
                    }
                    title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_ULTIMATE);
                    break;
                }
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_FULL_LICENSED_TO, new Object[]{licensedTo});
                break;
            }
            case fullNetwork: {
                if (licensedTo == null) {
                    title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_DEFAULT);
                    break;
                }
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_FULL_LICENSED_TO, new Object[]{licensedTo});
                break;
            }
            default: {
                title = ServiceManager.getI18n().getLocalizedText(WINDOW_TITLE_DEFAULT);
            }
        }
        return title;
    }

    public void addComponentToLayerPane(JComponent component, String id, String oldViewId, String viewIdIn) {
        if (component != null) {
            Component[] children;
            boolean missing = true;
            for (Component child : children = this.centralPanel.getComponents()) {
                if (!component.equals(child)) continue;
                missing = false;
            }
            String viewId = "com.thinkbuzan.gaia.view.nullview.NullView".equalsIgnoreCase(viewIdIn) ? "com.thinkbuzan.gaia.view.mindmap.MindMapView" : viewIdIn;
            if (missing) {
                HashMap<String, JComponent> viewComponents = this.viewComponentsForDocId.get(id);
                if (viewComponents == null) {
                    HashMap<String, JComponent> comps = new HashMap<String, JComponent>();
                    comps.put(viewId, component);
                    this.viewComponentsForDocId.put(id, comps);
                } else if (viewComponents.containsKey(viewId)) {
                    if (oldViewId != null && "com.thinkbuzan.gaia.view.PresentationView".equalsIgnoreCase(oldViewId) && viewComponents.containsKey(oldViewId)) {
                        this.centralPanel.remove(viewComponents.get(oldViewId));
                        viewComponents.remove(oldViewId);
                    }
                    for (String key : viewComponents.keySet()) {
                        if (!key.equalsIgnoreCase(viewId)) continue;
                        this.centralPanel.remove(viewComponents.get(key));
                    }
                    viewComponents.put(viewId, component);
                    this.viewComponentsForDocId.put(id, viewComponents);
                } else {
                    if (oldViewId != null && "com.thinkbuzan.gaia.view.PresentationView".equalsIgnoreCase(oldViewId) && viewComponents.containsKey(oldViewId)) {
                        this.centralPanel.remove(viewComponents.get(oldViewId));
                        viewComponents.remove(oldViewId);
                        this.viewComponentsForDocId.put(id, viewComponents);
                    }
                    viewComponents.put(viewId, component);
                    this.viewComponentsForDocId.put(id, viewComponents);
                }
                this.centralPanel.add((Component)component, id + "-" + viewId);
            }
            this.cardLayout.show(this.centralPanel, id + "-" + viewId);
            this.revalidate();
            this.repaint();
        }
    }

    public void removeComponentFromLayerPane(String id) {
        if (id != null) {
            HashMap<String, JComponent> componentsForId = this.viewComponentsForDocId.get(id);
            if (componentsForId != null) {
                for (JComponent currentComp : componentsForId.values()) {
                    this.centralPanel.remove(currentComp);
                }
                this.viewComponentsForDocId.remove(id);
            }
        } else {
            LOGGER.error((Object)"Error removing null component from frame ");
        }
        this.revalidate();
        this.repaint();
    }

    public JComponent getComponentLayerPane() {
        return (JComponent)this._innerLayeredPane.getComponent(1);
    }

    public void addSidePanel(ISidePanel panel) {
        if (panel.getID().equals("com.thinkbuzan.pascal.ui.sidepanel.images")) {
            this.imageLibraryPanel = panel;
            if (this.iconLibraryPanel != null) {
                this._rightPanel.addIconPanel(this.createImageAndIconSidePanel());
            }
        } else if (panel.getID().equals("com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.impl")) {
            this.iconLibraryPanel = panel;
            if (this.imageLibraryPanel != null) {
                this._rightPanel.addIconPanel(this.createImageAndIconSidePanel());
            }
        } else if (panel.getID().equals("com.thinkbuzan.apollo.ui.sidepanels.attachments")) {
            this.linksPanel = panel;
            if (this.notesPanel != null) {
                this._rightPanel.addIconPanel(this.createNotesAndLinksPanel());
            }
        } else if (panel.getID().equals("com.thinkbuzan.gaia.ui.sidepanels.notes")) {
            this.notesPanel = panel;
            if (this.linksPanel != null) {
                this._rightPanel.addIconPanel(this.createNotesAndLinksPanel());
            }
        } else {
            this._rightPanel.addIconPanel(panel);
        }
        this._rightPanel.revalidate();
    }

    private void showSubPanel(CardLayout layout, JPanel panel, String cardId, JPanel selectedPanel, JPanel ... deselectedPanels) {
        for (JPanel deselectedPanel : deselectedPanels) {
            deselectedPanel.setBackground(DESELECTED_COLOUR);
        }
        selectedPanel.setBackground(SELECTED_COLOUR);
        layout.show(panel, cardId);
    }

    private ISidePanel createNotesAndLinksPanel() {
        final JPanel wrapper = new JPanel();
        wrapper.setOpaque(false);
        wrapper.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        topPanel.setLayout(new GridLayout(1, 3));
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOUR));
        this.notesLabelPanel = new JPanel();
        this.notesLabelPanel.setOpaque(true);
        this.notesLabelPanel.setBackground(SELECTED_COLOUR);
        this.notesLabelPanel.setLayout(new BorderLayout());
        Border inner = BorderFactory.createEmptyBorder(12, 0, 13, 0);
        MatteBorder outer = BorderFactory.createMatteBorder(0, 1, 0, 0, BORDER_COLOUR);
        this.notesLabelPanel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        JLabel notesLabel = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.notes").toUpperCase(), 0);
        notesLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)15.0f));
        this.notesLabelPanel.add((Component)notesLabel, "Center");
        this.linksLabelPanel = new JPanel();
        this.linksLabelPanel.setOpaque(true);
        this.linksLabelPanel.setBackground(DESELECTED_COLOUR);
        this.linksLabelPanel.setLayout(new BorderLayout());
        this.linksLabelPanel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        JLabel linksLabel = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.links").toUpperCase(), 0);
        linksLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)15.0f));
        this.linksLabelPanel.add((Component)linksLabel, "Center");
        topPanel.add(this.notesLabelPanel);
        topPanel.add(this.linksLabelPanel);
        this.attachmentsCardPanel = new JPanel();
        this.attachmentsCardPanel.setOpaque(false);
        this.attachmentsCardLayout = new CardLayout();
        this.attachmentsCardPanel.setLayout(this.attachmentsCardLayout);
        linksLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MindMapFrame.this.showSubPanel(MindMapFrame.this.attachmentsCardLayout, MindMapFrame.this.attachmentsCardPanel, MindMapFrame.LINKS_CARD, MindMapFrame.this.linksLabelPanel, new JPanel[]{MindMapFrame.this.notesLabelPanel});
            }
        });
        notesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MindMapFrame.this.showSubPanel(MindMapFrame.this.attachmentsCardLayout, MindMapFrame.this.attachmentsCardPanel, MindMapFrame.NOTES_CARD, MindMapFrame.this.notesLabelPanel, new JPanel[]{MindMapFrame.this.linksLabelPanel});
            }
        });
        this.attachmentsCardLayout.addLayoutComponent(this.notesPanel.getComponent(), NOTES_CARD);
        this.attachmentsCardLayout.addLayoutComponent(this.linksPanel.getComponent(), LINKS_CARD);
        this.attachmentsCardPanel.add((Component)this.notesPanel.getComponent(), NOTES_CARD);
        this.attachmentsCardPanel.add((Component)this.linksPanel.getComponent(), LINKS_CARD);
        wrapper.add((Component)topPanel, "North");
        wrapper.add((Component)this.attachmentsCardPanel, "Center");
        return new ISidePanel(){

            public boolean supportsView(String viewId) {
                return MindMapFrame.this.notesPanel.supportsView(viewId) && MindMapFrame.this.linksPanel.supportsView(viewId);
            }

            public Dimension getPreferredSize() {
                Dimension notes = MindMapFrame.this.notesPanel.getPreferredSize();
                Dimension links = MindMapFrame.this.linksPanel.getPreferredSize();
                int width = (int)Math.max(notes.getWidth(), links.getWidth());
                int height = (int)Math.max(notes.getHeight(), links.getHeight());
                return new Dimension(width, height);
            }

            public String getLabel() {
                return MindMapFrame.this.linksPanel.getLabel();
            }

            public Icon getIcon() {
                return MindMapFrame.this.linksPanel.getIcon();
            }

            public String getID() {
                return MindMapFrame.this.linksPanel.getID();
            }

            public JComponent getComponent(String viewId) {
                return wrapper;
            }

            public JComponent getComponent() {
                return wrapper;
            }
        };
    }

    private ISidePanel createImageAndIconSidePanel() {
        final JPanel wrapper = new JPanel();
        wrapper.setOpaque(false);
        wrapper.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOUR));
        this.imagesLabelPanel = new JPanel();
        this.imagesLabelPanel.setOpaque(true);
        this.imagesLabelPanel.setBackground(SELECTED_COLOUR);
        this.imagesLabelPanel.setLayout(new BorderLayout());
        Border inner = BorderFactory.createEmptyBorder(12, 0, 13, 0);
        MatteBorder outer = BorderFactory.createMatteBorder(0, 1, 0, 0, BORDER_COLOUR);
        this.imagesLabelPanel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        JLabel imagesLabel = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images").toUpperCase(), 0);
        imagesLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)15.0f));
        this.imagesLabelPanel.add((Component)imagesLabel, "Center");
        this.iconsLabelPanel = new JPanel();
        this.iconsLabelPanel.setOpaque(true);
        this.iconsLabelPanel.setBackground(DESELECTED_COLOUR);
        this.iconsLabelPanel.setLayout(new BorderLayout());
        outer = BorderFactory.createMatteBorder(0, 1, 0, 1, BORDER_COLOUR);
        this.iconsLabelPanel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        JLabel iconsLabel = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.icons").toUpperCase(), 0);
        iconsLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)15.0f));
        this.iconsLabelPanel.add((Component)iconsLabel, "Center");
        topPanel.add(this.imagesLabelPanel);
        topPanel.add(this.iconsLabelPanel);
        this.imagesCardPanel = new JPanel();
        this.imagesCardPanel.setOpaque(false);
        this.imagesCardLayout = new CardLayout();
        this.imagesCardPanel.setLayout(this.imagesCardLayout);
        iconsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MindMapFrame.this.showSubPanel(MindMapFrame.this.imagesCardLayout, MindMapFrame.this.imagesCardPanel, MindMapFrame.ICON_LIBRARY_CARD, MindMapFrame.this.iconsLabelPanel, new JPanel[]{MindMapFrame.this.imagesLabelPanel});
            }
        });
        imagesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MindMapFrame.this.showSubPanel(MindMapFrame.this.imagesCardLayout, MindMapFrame.this.imagesCardPanel, MindMapFrame.IMAGE_LIBRARY_CARD, MindMapFrame.this.imagesLabelPanel, new JPanel[]{MindMapFrame.this.iconsLabelPanel});
            }
        });
        this.imagesCardLayout.addLayoutComponent(this.imageLibraryPanel.getComponent(), IMAGE_LIBRARY_CARD);
        this.imagesCardLayout.addLayoutComponent(this.iconLibraryPanel.getComponent(), ICON_LIBRARY_CARD);
        this.imagesCardPanel.add((Component)this.imageLibraryPanel.getComponent(), IMAGE_LIBRARY_CARD);
        this.imagesCardPanel.add((Component)this.iconLibraryPanel.getComponent(), ICON_LIBRARY_CARD);
        wrapper.add((Component)topPanel, "North");
        wrapper.add((Component)this.imagesCardPanel, "Center");
        return new ISidePanel(){

            public boolean supportsView(String viewId) {
                return MindMapFrame.this.imageLibraryPanel.supportsView(viewId) && MindMapFrame.this.iconLibraryPanel.supportsView(viewId);
            }

            public Dimension getPreferredSize() {
                Dimension image = MindMapFrame.this.imageLibraryPanel.getPreferredSize();
                Dimension icon = MindMapFrame.this.iconLibraryPanel.getPreferredSize();
                return new Dimension((int)Math.max(image.getWidth(), icon.getWidth()), (int)Math.max(image.getHeight(), icon.getHeight()));
            }

            public String getLabel() {
                String images = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.images");
                String icons = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.icons");
                return images + " & " + icons;
            }

            public Icon getIcon() {
                return MindMapFrame.this.imageLibraryPanel.getIcon();
            }

            public String getID() {
                return MindMapFrame.this.imageLibraryPanel.getID();
            }

            public JComponent getComponent(String viewId) {
                return wrapper;
            }

            public JComponent getComponent() {
                return wrapper;
            }
        };
    }

    public void hideSidePanel() {
    }

    public void fullScreenChanged(FullScreenState state) {
    }

    public void setGlobalOverlay(IOverlay overlay) {
    }

    public void setGlobalOverlayComponent(JComponent overlay) {
    }

    public void removeGlobalOverlay() {
    }

    @Override
    public Rectangle getMaximizedBounds() {
        return this.maxBounds;
    }

    @Override
    public void setMaximizedBounds(Rectangle maxBounds) {
        this.maxBounds = maxBounds;
        super.setMaximizedBounds(maxBounds);
    }

    public boolean isFastCaptureContextTabShowing() {
        return this._tabbedRibbon.isFastCaptureTabAdded();
    }

    public boolean isTimelineContextTabShowing() {
        return this._tabbedRibbon.isTimelineTabAdded();
    }

    public boolean isBrainstormContextTabShowing() {
        return this._tabbedRibbon.isBrainstormTabAdded();
    }

    public boolean isBranchContextTabShowing() {
        return this._tabbedRibbon.isBranchTabAdded();
    }

    public boolean isProjectContextTabShowing() {
        return this._tabbedRibbon.isProjectTabAdded();
    }

    public boolean isCommentsContextTabShowing() {
        return this._tabbedRibbon.isCommentsTabAdded();
    }

    public boolean isPresentationContextTabShowing() {
        return this._tabbedRibbon.isPresentationTabAdded();
    }

    public boolean isSketchContextTabShowing() {
        return this._tabbedRibbon.isSketchTabAdded();
    }

    public final void showSidePanel(String id) {
        if (id.equals("com.thinkbuzan.gaia.ui.sidepanels.notes")) {
            this._rightPanel.showSidePanel("com.thinkbuzan.apollo.ui.sidepanels.attachments");
            this.showSubPanel(this.attachmentsCardLayout, this.attachmentsCardPanel, NOTES_CARD, this.notesLabelPanel, this.linksLabelPanel);
        } else if (id.equals("com.thinkbuzan.apollo.ui.sidepanels.attachments")) {
            this._rightPanel.showSidePanel("com.thinkbuzan.apollo.ui.sidepanels.attachments");
            this.showSubPanel(this.attachmentsCardLayout, this.attachmentsCardPanel, LINKS_CARD, this.linksLabelPanel, this.notesLabelPanel);
        } else if (id.equals("com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.impl")) {
            this._rightPanel.showSidePanel("com.thinkbuzan.pascal.ui.sidepanel.images");
            this.showSubPanel(this.imagesCardLayout, this.imagesCardPanel, ICON_LIBRARY_CARD, this.iconsLabelPanel, this.imagesLabelPanel);
        } else if (id.equals("com.thinkbuzan.pascal.ui.sidepanel.images")) {
            this._rightPanel.showSidePanel("com.thinkbuzan.pascal.ui.sidepanel.images");
            this.showSubPanel(this.imagesCardLayout, this.imagesCardPanel, IMAGE_LIBRARY_CARD, this.imagesLabelPanel, this.iconsLabelPanel);
        } else {
            this._rightPanel.showSidePanel(id);
        }
    }

    public final void updateSidePanelsForView(String viewId) {
        this._rightPanel.updateSidePanelsForView(viewId);
    }

    public boolean isContextTabShowing() {
        return this.isBranchContextTabShowing() || this.isBrainstormContextTabShowing() || this.isFastCaptureContextTabShowing() || this.isProjectContextTabShowing() || this.isCommentsContextTabShowing() || this.isPresentationContextTabShowing() || this.isSketchContextTabShowing() || this.isTimelineContextTabShowing();
    }

    public void setMapName(String text) {
        this._mapName = text;
        this.updateTitleLabel();
    }

    public void setPresentationName(String text) {
        this._presentationName = text;
        this.updateTitleLabel();
    }

    private void updateTitleLabel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                sb.append(MindMapFrame.this._licenseName);
                if (MindMapFrame.this._mapName != null) {
                    sb.append(" - ");
                    sb.append(MindMapFrame.this._mapName);
                }
                if (MindMapFrame.this._presentationName != null) {
                    sb.append(" - ");
                    sb.append(MindMapFrame.this._presentationName);
                }
                try {
                    IEditorView editor = ServiceManager.getEditorManager().getCurrentEditorComponent();
                    if (editor.isThirdPartyCloudMap()) {
                        sb.append(" - ");
                        if (editor.isDropboxMap()) {
                            sb.append("Dropbox");
                        } else if (editor.isGoogleDriveMap()) {
                            sb.append("Google Drive");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MindMapFrame.this._titleLabel.setText(sb.toString());
                MindMapFrame.this.updateTitleBounds();
            }
        });
    }

    private void updateTitleBounds() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateTitleBounds();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MindMapFrame.this.doUpdateTitleBounds();
                }
            });
        }
    }

    private void doUpdateTitleBounds() {
        Dimension titleLabelDimensions = this._titleLabel.getPreferredSize();
        int x = this._titleBar.getWidth() / 2 - titleLabelDimensions.width / 2;
        if (this.isContextTabShowing()) {
            Rectangle topperBounds = new Rectangle(0, 0, 0, 0);
            for (int i = 0; i < this._titleBar.getComponentCount(); ++i) {
                if (!(this._titleBar.getComponent(i) instanceof ContextTabTopper)) continue;
                ContextTabTopper topper = (ContextTabTopper)this._titleBar.getComponent(i);
                topperBounds.add(topper.getBounds());
            }
            Rectangle titleBarBounds = this._titleBar.getBounds();
            int width = (int)((double)this._titleBar.getWidth() - (topperBounds.getX() - titleBarBounds.getX()) - topperBounds.getWidth());
            int middle = (int)(topperBounds.getX() + topperBounds.getWidth() + (double)(width / 2));
            x = middle - titleLabelDimensions.width / 2 - this._rightCommandPanel.getWidth() / 2;
            if (titleLabelDimensions.width > width - this._rightCommandPanel.getWidth()) {
                this._titleLabel.setText("");
            }
        }
        this._titleLabel.setBounds(new Rectangle(new Point(x, 2), titleLabelDimensions));
        this._titleLabel.repaint();
    }

    public void unlockTabs() {
        this._tabbedRibbon.unlockTabs();
    }

    public void lockTabs() {
        this._tabbedRibbon.lockTabs();
    }

    public void showFrame() {
        if (this.firstLoad) {
            this.firstLoad = false;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MindMapFrame.this.getExtendedState() != 1) {
                    MindMapFrame.this.setExtendedState(1);
                }
                MindMapFrame.this.setExtendedState(0);
            }
        });
    }

    public TabbedRibbon getTabbedRibbon() {
        return this._tabbedRibbon;
    }

    public void exitFullScreen() {
    }

    public void stopJavaFX() {
        Platform.exit();
    }

    public void toggleFullScreen() {
        this.fullScreen = !this.fullScreen;
        this.topGlassBar.removeMouseListener(this.listener);
        this._tabbedRibbon.removeFullScreenMouseListener(this.listener);
        if (this.fullScreen) {
            this.wasMaximised = this.isMaximised();
            if (!this.isMaximised()) {
                this.maximise();
            }
            this.topGlassBar.addMouseListener(this.listener);
            this._tabbedRibbon.addFullScreenMouseListener(this.listener);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MindMapFrame.this.centralPanel.setBorder(null);
                    MindMapFrame.this._tt.remove(MindMapFrame.this._tabbedRibbon);
                    MindMapFrame.this._exitBar.add((Component)MindMapFrame.this._tabbedRibbon, "Center");
                    MindMapFrame.this._exitBar.setVisible(false);
                }
            });
        } else {
            Border inside = BorderFactory.createLineBorder(Color.decode("#c6c6c6"));
            Border outside = BorderFactory.createLineBorder(Color.decode("#f1f1f1"), 5);
            this.centralPanel.setBorder(BorderFactory.createCompoundBorder(outside, inside));
            this._exitBar.remove(this._tabbedRibbon);
            this._tt.add(this._tabbedRibbon);
            if (this.wasMaximised) {
                this.maximise();
            } else {
                this.minimise();
            }
        }
        this._titleBar.setVisible(!this.fullScreen);
        this._notification.setVisible(!this.fullScreen);
        this._topBar.setVisible(!this.fullScreen);
        this._exitBar.setVisible(this.fullScreen);
        this._bottomBar.setVisible(!this.fullScreen);
        this._rightPanel.setVisible(!this.fullScreen);
        this._quickMapSwitchPanel.setVisible(!this.fullScreen);
    }

    public void setOutlinePanel(JComponent outlinePanelIn) {
        this._mapOutlinePanel.setOutline(outlinePanelIn);
    }

    public void toggleMapOverviewPanel() {
        this.mapOutlineVisibility = !this.mapOutlineVisibility;
        this._mapOutlinePanel.setVisible(this.mapOutlineVisibility);
    }

    public JComponent getMapOutlinePanel() {
        return this._mapOutlinePanel;
    }

    public class FullScreenMouseListener
    extends MouseAdapter {
        public void hide() {
            MindMapFrame.this._exitBar.setVisible(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource().equals(MindMapFrame.this.topGlassBar)) {
                MindMapFrame.this._exitBar.setVisible(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() instanceof Tab) {
                int height = ((Tab)e.getSource()).getHeight();
                int y = e.getY();
                if (y >= height) {
                    MindMapFrame.this._exitBar.setVisible(false);
                }
            } else if (e.getSource().equals(MindMapFrame.this._tabbedRibbon) && e.getY() > 0) {
                MindMapFrame.this._exitBar.setVisible(false);
            }
        }
    }
}

