/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.core.win.component.LionScrollBarUI;
import com.thinkbuzan.apollo.ui.win.frame.ui.MapPreviewPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPanelHideButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPinToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchToggleButton;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.plaf.ScrollBarUI;

public class QuickMapSwitchPanel
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private static final int SCROLL_BLOCK_SIZE = 16;
    private QuickMapSwitchToggleButton _buttonLabel;
    private HashMap<UUID, MapPreviewPanel> _panelDictionary = new HashMap();
    private JLabel _editorNameLabel;
    private JScrollPane _scroller;
    private JPanel _scrollerContent;
    private boolean firstCollapse = true;
    private boolean _expanded = false;
    private boolean _pinned = false;
    private IEditorView _previouslySelectedEditor;
    private static final String MAPS_OPEN_KEY = "com.thinkbuzan.i18n.win.uimaps.open.many";
    private static final String MAP_OPEN = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.uimaps.open.one");
    private transient QuickMapSwitchPinToggleButton pinButton;

    public final boolean isExpanded() {
        return this._expanded;
    }

    public final boolean isPinned() {
        return this._pinned;
    }

    public final IEditorView getPreviouslySelectedEditor() {
        return this._previouslySelectedEditor;
    }

    public final void clearPreviouslySelectedEditor() {
        this._previouslySelectedEditor = null;
    }

    public QuickMapSwitchPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.decode("#0067b0"));
        this._scrollerContent = new JPanel();
        this._scrollerContent.setBackground(Color.decode("#0067b0"));
        this._scrollerContent.setBorder(null);
        this._scrollerContent.setLayout(new BoxLayout(this._scrollerContent, 3));
        QuickMapSwitchPanelHideButton b = new QuickMapSwitchPanelHideButton();
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QuickMapSwitchPanel.this._buttonLabel.toggle();
            }
        });
        this._scrollerContent.add(b);
        this._scroller = new JScrollPane(this._scrollerContent);
        this._scroller.getVerticalScrollBar().setUnitIncrement(16);
        this._scroller.setBorder(null);
        this._scroller.setBackground(Color.decode("#0067b0"));
        this._scroller.getVerticalScrollBar().setUI((ScrollBarUI)new LionScrollBarUI(this._scroller.getVerticalScrollBar()));
        this._scroller.setVerticalScrollBarPolicy(20);
        this._scroller.setHorizontalScrollBarPolicy(31);
        JScrollBar scrollBar = this._scroller.getVerticalScrollBar();
        this._scroller.remove(scrollBar);
        JPanel tmp = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        tmp.setLayout(new OverlayLayout(tmp));
        this._scroller.setAlignmentX(0.0f);
        scrollBar.setAlignmentX(0.0f);
        tmp.add(scrollBar);
        tmp.add(this._scroller);
        this.add(tmp);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.addFocusListener(this);
    }

    public final void remove(IEditorView editor) {
        MapPreviewPanel panel = this._panelDictionary.get(editor.getId());
        if (panel != null) {
            this._panelDictionary.remove(editor.getId());
            this._scrollerContent.remove(panel);
        }
        this._scrollerContent.revalidate();
    }

    public final void add(IEditorView editor) {
        MapPreviewPanel panel = new MapPreviewPanel(editor);
        this._panelDictionary.put(editor.getId(), panel);
        this._scrollerContent.add(panel);
        int c = this._scrollerContent.getComponentCount();
        String msg = "";
        msg = c == 1 ? MAP_OPEN : ServiceManager.getI18n().getLocalizedText(MAPS_OPEN_KEY, new Object[]{c});
        this._buttonLabel.setText(msg);
        this.setSelectedPanel(editor);
        this._scrollerContent.revalidate();
    }

    public final void togglePin() {
        boolean bl = this._pinned = !this._pinned;
        if (this._pinned && !this._expanded) {
            this.expand();
        } else if (!this._pinned && this._expanded) {
            this.collapse();
        }
        if (this.pinButton != null) {
            this.pinButton.update();
        }
    }

    public final void toggle() {
        this.toggle(false);
    }

    public final void toggle(boolean forced) {
        if (this._expanded) {
            this.collapse(forced);
        } else {
            this.expand();
        }
    }

    public final void expand() {
        this._expanded = true;
        this.setVisible(true);
        this.requestFocusInWindow();
        this.revalidate();
    }

    public final void collapse() {
        this.collapse(false);
    }

    public final boolean isCollapsed() {
        return !this._expanded;
    }

    public final void collapse(boolean forced) {
        if (this._pinned && !forced) {
            return;
        }
        this._expanded = false;
        this._pinned = false;
        this.setVisible(false);
        this.revalidate();
        if (this.firstCollapse) {
            this.firstCollapse = false;
            try {
                ServiceManager.getEditorManager().showMapSwitchHint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.pinButton != null) {
            this.pinButton.update();
        }
    }

    public final void setPinButton(QuickMapSwitchPinToggleButton button) {
        this.pinButton = button;
    }

    @Override
    public final void setBounds(int x, int y, int width, int height) {
        super.setBounds(0, 0, width, height);
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this._expanded) {
            return new Dimension(200, Integer.MAX_VALUE);
        }
        return new Dimension(0, Integer.MAX_VALUE);
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final MapPreviewPanel getMapPreviewPanel(UUID id) {
        return this._panelDictionary.get(id);
    }

    public final void setToggleButton(QuickMapSwitchToggleButton quickSwitchPanelButton) {
        this._buttonLabel = quickSwitchPanelButton;
    }

    public final QuickMapSwitchToggleButton getToggleButton() {
        return this._buttonLabel;
    }

    public final void setQuickMapSwitchPanelText(IEditorView editor, String string) {
        MapPreviewPanel panel = this._panelDictionary.get(editor.getId());
        if (panel != null) {
            panel.setText(string);
        }
    }

    public final void setSelectedPanel(IEditorView editor) {
        for (UUID uuid : this._panelDictionary.keySet()) {
            MapPreviewPanel panel = this._panelDictionary.get(uuid);
            if (panel.isSelected() && !panel.getEditor().equals(editor)) {
                this._previouslySelectedEditor = panel.getEditor();
                this.refreshPreviewImage(this._previouslySelectedEditor);
            }
            panel.setSelected(false);
            if (!uuid.equals(editor.getId())) continue;
            this._panelDictionary.get(uuid).setSelected(true);
        }
    }

    public final void refreshPreviewImage(IEditorView editor) {
        MapPreviewPanel panel = this._panelDictionary.get(editor.getId());
        panel.refreshPreviewImage();
    }

    public final Component[] getContents() {
        return this._scrollerContent.getComponents();
    }

    public final IEditorView getFirstEditor() {
        Iterator<UUID> i$ = this._panelDictionary.keySet().iterator();
        if (i$.hasNext()) {
            UUID uuid = i$.next();
            MapPreviewPanel panel = this._panelDictionary.get(uuid);
            return panel.getEditor();
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public final void focusLost(FocusEvent e) {
        this.collapse();
    }
}

