/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

public class QuickMapSwitchPinToggleButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final String PINNED = "pinned.png";
    private static final String UNPINNED = "unpinned.png";
    private static final Color BG_COLOUR = Color.decode("#0067b0");
    private final Icon pinnedIcon;
    private final Icon unpinnedIcon;
    private final QuickMapSwitchPanel _quickSwitchPanel;

    public QuickMapSwitchPinToggleButton(QuickMapSwitchPanel quickSwitchPanel) {
        super(ResourceManager.getImageIcon(UNPINNED, 15), 2);
        this._quickSwitchPanel = quickSwitchPanel;
        this._quickSwitchPanel.setPinButton(this);
        this.pinnedIcon = ResourceManager.getImageIcon(PINNED, 15);
        this.unpinnedIcon = this.getIcon();
        this.setOpaque(true);
        this.setBackground(BG_COLOUR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                QuickMapSwitchPinToggleButton.this.setForeground(Color.decode("#98b2d9"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                QuickMapSwitchPinToggleButton.this.setForeground(Color.white);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                QuickMapSwitchPinToggleButton.this.toggle();
            }
        });
    }

    public void toggle() {
        this._quickSwitchPanel.togglePin();
        this._quickSwitchPanel.requestFocus();
    }

    public void update() {
        if (this._quickSwitchPanel.isExpanded()) {
            this.setBackground(BG_COLOUR);
        } else {
            this.setBackground(BG_COLOUR.brighter());
        }
        Icon icon = this._quickSwitchPanel.isPinned() ? this.pinnedIcon : this.unpinnedIcon;
        this.setIcon(icon);
    }
}

