/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.QuickMapSwitchPinToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class QuickMapSwitchToggleButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final String MAPS_OPEN_KEY = "com.thinkbuzan.i18n.win.uimaps.open.many";
    private static final String MAP_OPEN = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.uimaps.open.one");
    private static final Color BG_COLOUR = Color.decode("#0067b0");
    private final QuickMapSwitchPanel _quickSwitchPanel;
    private final QuickMapSwitchPinToggleButton _pin;

    public QuickMapSwitchToggleButton(QuickMapSwitchPanel quickSwitchPanel, QuickMapSwitchPinToggleButton pin) {
        super(ServiceManager.getI18n().getLocalizedText(MAPS_OPEN_KEY, new Object[]{0}), ResourceManager.getImageIcon("quickswitchbutton.png", 15), 2);
        this._quickSwitchPanel = quickSwitchPanel;
        this._pin = pin;
        this.setOpaque(true);
        this.setForeground(Color.white);
        this.setBackground(BG_COLOUR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                QuickMapSwitchToggleButton.this.setForeground(Color.decode("#98b2d9"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                QuickMapSwitchToggleButton.this.setForeground(Color.white);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                QuickMapSwitchToggleButton.this.toggle();
            }
        });
    }

    public void toggle() {
        this._quickSwitchPanel.toggle(true);
        this._pin.update();
        if (this._quickSwitchPanel.isExpanded()) {
            this.setBackground(BG_COLOUR);
        } else {
            this.setBackground(BG_COLOUR.brighter());
        }
    }

    public void setCounter(int count) {
        if (count == 1) {
            this.setText(MAP_OPEN);
        } else {
            this.setText(ServiceManager.getI18n().getLocalizedText(MAPS_OPEN_KEY, new Object[]{count}));
        }
    }
}

