/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.RibbonPanel;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class RibbonSection
extends RibbonPanel {
    private static final long serialVersionUID = 1L;
    protected static final int STRUT = 25;
    protected static final int MEDIUM_ICON_SIZE = 15;
    protected static final int LARGE_ICON_SIZE = 30;
    private final JPanel _contentPanel;
    private final String _sectionTitle;
    private JLabel _titleLabel;

    public RibbonSection(String title) {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this._sectionTitle = title;
        this.setBackground(Color.decode("#fafafa"));
        this.setLayout(new BoxLayout(this, 3));
        this._contentPanel = new RibbonPanel();
        this._contentPanel.setOpaque(false);
        this.add(this._contentPanel);
        this.add(Box.createVerticalGlue());
        RibbonPanel titleAndOptionsButtonPanel = new RibbonPanel();
        titleAndOptionsButtonPanel.setLayout(new BoxLayout(titleAndOptionsButtonPanel, 2));
        ((Container)titleAndOptionsButtonPanel).add(Box.createHorizontalGlue());
        ((Container)titleAndOptionsButtonPanel).add(this.createTitleLabel());
        ((Container)titleAndOptionsButtonPanel).add(Box.createHorizontalGlue());
        this.add(titleAndOptionsButtonPanel);
        this.add(Box.createVerticalStrut(1));
    }

    public JPanel getContentPanel() {
        return this._contentPanel;
    }

    protected Callable<Void> getActionCaller(final String actionId, final Object parameter) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(actionId, new Object[]{parameter});
                return null;
            }
        };
        return callable;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superDim = super.getPreferredSize();
        int dw = superDim.width;
        int tw = this._titleLabel.getWidth() + 10;
        return new Dimension(Math.max(dw, tw), superDim.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private JLabel createTitleLabel() {
        this._titleLabel = new JLabel(this._sectionTitle);
        this._titleLabel.setForeground(Color.decode("#666666"));
        this._titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        this._titleLabel.setHorizontalAlignment(0);
        return this._titleLabel;
    }

    protected Component wrapForAlignment(Component component, int alignment) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(component);
        return panel;
    }
}

