/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ToggleIconButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    private boolean isSelected = false;
    public static final Color SELECTED_BACKGROUND = Color.decode("#fafafa");
    private static final Color DESELECTED_BACKGROUND = Color.decode("#f1f1f1");
    public static final Color SELECTED_BORDER_COLOUR = Color.decode("#c6c6c6");
    private static final int RIGHT_PADDING = 5;
    private static final Border INNER_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 5);
    private static final Border OUTER_SELECTED_BORDER = BorderFactory.createMatteBorder(1, 1, 1, 0, SELECTED_BORDER_COLOUR);
    private static final Border SELECTED_BORDER = BorderFactory.createCompoundBorder(OUTER_SELECTED_BORDER, INNER_BORDER);
    private static final Border OUTER_DESELECTED_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 0);
    private static final Border DESELECTED_BORDER = BorderFactory.createCompoundBorder(OUTER_DESELECTED_BORDER, INNER_BORDER);
    private static final Dimension SIZE = new Dimension(48, 38);
    int width = 0;
    boolean tooltipNeedsMeasuring = true;

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            this.setBorder(SELECTED_BORDER);
        } else {
            this.setBorder(DESELECTED_BORDER);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public ToggleIconButton(ImageIcon imageIcon, int alignment, String label) {
        super(imageIcon, alignment);
        this.setBorder(DESELECTED_BORDER);
        this.setToolTipText(label);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Point p = new Point();
        p.x -= this.width / 2;
        return p;
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bgColor = this.isSelected ? SELECTED_BACKGROUND : DESELECTED_BACKGROUND;
        g.setColor(bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        if (this.tooltipNeedsMeasuring) {
            this.measureTooltip(g);
            this.tooltipNeedsMeasuring = false;
        }
    }

    private void measureTooltip(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        this.width = fm.stringWidth(this.getToolTipText());
    }
}

