/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.ui.CommonActions;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IZoomListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class ZoomSlider
extends JPanel
implements IZoomListener {
    private static final long serialVersionUID = 1L;
    private static final String FIT_ACTION_ID = "com.thinkbuzan.gaia.actions.FitMapToScreenAction";
    private static final String FULL_ACTION_ID = "com.thinkbuzan.phoenix.fullscreen.ToggleFullScreenAction";
    private static final Color HOVER_COLOUR = Color.decode("#98b2d9");
    public static final double HUNDRED = 100.0;
    public static final double MINIMUM_SCALE = 0.1;
    public static final double MAXIMUM_SCALE = 4.0;
    public static final int MIN = 10;
    public static final int MAX = 400;
    private final JSlider _slider;
    private final JLabel _valueLabel;
    private boolean updating;
    private HashSet<UUID> _listenerList = new HashSet();
    private static final String HUNDRED_PERCENT_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.hundredpercent");

    public ZoomSlider() {
        this.setOpaque(false);
        int min = 10;
        int max = 400;
        int current = 10;
        this._slider = new JSlider(10, 400, 10);
        this._slider.setUI((SliderUI)CoreUIFactory.createSliderUI((JSlider)this._slider));
        this._slider.setOpaque(false);
        this._slider.setPreferredSize(new Dimension(105, 0));
        this._slider.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this._valueLabel = this.createValueLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.createFullscreenButton());
        this.add(Box.createHorizontalStrut(10));
        this.add(this.createFitButton());
        this.add(Box.createHorizontalStrut(10));
        this.add(this.createMinusButton());
        this.add(this._slider);
        this.add(this.createPlusButton());
        this.add(Box.createHorizontalStrut(10));
        this.add(this._valueLabel);
        this.add(Box.createHorizontalStrut(10));
        this._slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ZoomSlider.this.updating) {
                    return;
                }
                double zoom = (double)ZoomSlider.this._slider.getValue() * 100.0;
                zoom = Math.max(ZoomSlider.this._slider.getValue(), 10);
                zoom = Math.min(zoom, 400.0);
                ServiceManager.getActionManager().runAction(CommonActions.SET_ZOOM, new Object[]{zoom / 100.0});
            }
        });
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                try {
                    ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                        public void editorChanged(IEditorView editor) {
                            if (editor != null && editor.getZoomController() != null) {
                                if (!ZoomSlider.this._listenerList.contains(editor.getId())) {
                                    editor.getZoomController().addZoomListener((IZoomListener)ZoomSlider.this);
                                    ZoomSlider.this._listenerList.add(editor.getId());
                                }
                                int newZoom = Math.max(10, (int)(editor.getZoomController().getZoom() * 100.0));
                                newZoom = Math.min(400, newZoom);
                                ZoomSlider.this.setZoom(newZoom);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setZoom(int newZoom) {
        this.updating = true;
        try {
            this._slider.setValue(newZoom);
            this._valueLabel.setText(newZoom + "%");
        }
        finally {
            this.updating = false;
        }
    }

    private JButton createFitButton() {
        JButton fitButton = new JButton((Icon)ResourceManager.getImageIcon("refit-15.png", 0)){
            private static final long serialVersionUID = 1L;

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Point p = new Point();
                p.y = -this.getHeight();
                return p;
            }
        };
        fitButton.setBorder(BorderFactory.createEmptyBorder());
        fitButton.setBorderPainted(false);
        fitButton.setContentAreaFilled(false);
        fitButton.setRolloverEnabled(false);
        fitButton.setFocusable(false);
        fitButton.setFocusPainted(false);
        fitButton.setMargin(new Insets(0, 0, 0, 0));
        fitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(ZoomSlider.FIT_ACTION_ID, new Object[0]);
            }
        });
        ServiceManager.getActionManager().hookActionStateListener(FIT_ACTION_ID, (JComponent)fitButton);
        fitButton.setToolTipText(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.fitMapToScreen"));
        return fitButton;
    }

    private Component createFullscreenButton() {
        JButton fitButton = new JButton((Icon)ResourceManager.getImageIcon("full_screen.png", 0)){
            private static final long serialVersionUID = 1L;

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Point p = new Point();
                p.y = -this.getHeight();
                return p;
            }
        };
        fitButton.setBorder(BorderFactory.createEmptyBorder());
        fitButton.setBorderPainted(false);
        fitButton.setContentAreaFilled(false);
        fitButton.setRolloverEnabled(false);
        fitButton.setFocusable(false);
        fitButton.setFocusPainted(false);
        fitButton.setMargin(new Insets(0, 0, 0, 0));
        fitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(ZoomSlider.FULL_ACTION_ID, new Object[0]);
            }
        });
        ServiceManager.getActionManager().hookActionStateListener(FULL_ACTION_ID, (JComponent)fitButton);
        fitButton.setToolTipText(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.fullScreenNew.title"));
        return fitButton;
    }

    private JPanel createMinusButton() {
        final Dimension size = new Dimension(10, 10);
        final JPanel minusButton = new JPanel(){
            private static final long serialVersionUID = 1L;
            {
                this.setOpaque(false);
                this.setForeground(Color.white);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(this.getForeground());
                g.fillRect(1, this.getHeight() / 2, 6, 2);
                g.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return size;
            }

            @Override
            public Dimension getMaximumSize() {
                return size;
            }

            @Override
            public Dimension getMinimumSize() {
                return size;
            }
        };
        minusButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                minusButton.setForeground(HOVER_COLOUR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                minusButton.setForeground(Color.white);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ServiceManager.getActionManager().runAction(CommonActions.ZOOM_OUT, new Object[0]);
            }
        });
        return minusButton;
    }

    private JPanel createPlusButton() {
        final Dimension size = new Dimension(10, 10);
        final JPanel label = new JPanel(){
            private static final long serialVersionUID = 1L;
            {
                this.setOpaque(false);
                this.setForeground(Color.white);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(this.getForeground());
                g.fillRect(1, this.getHeight() / 2, 8, 2);
                g.fillRect(this.getWidth() / 2 - 1, 2, 2, 8);
                g.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return size;
            }

            @Override
            public Dimension getMaximumSize() {
                return size;
            }

            @Override
            public Dimension getMinimumSize() {
                return size;
            }
        };
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                label.setForeground(HOVER_COLOUR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                label.setForeground(Color.white);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                ServiceManager.getActionManager().runAction(CommonActions.ZOOM_IN, new Object[0]);
            }
        });
        return label;
    }

    private JLabel createValueLabel() {
        JLabel label = new JLabel(HUNDRED_PERCENT_TEXT);
        label.setForeground(Color.white);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)11.0f));
        return label;
    }

    public void zoomChanged(double zoom) {
        int newZoom = Math.max(10, (int)(zoom * 100.0));
        newZoom = Math.min(400, newZoom);
        this.setZoom(newZoom);
    }
}

