/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.brainstorm;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CanvasButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final Color BACKGROUND_COLOUR = Color.white;
    private static final Color HOVER_BACKGROUND_COLOUR = Color.decode("#d5e0f2");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.3d.uihint.settings");
    private final transient String action;
    private final transient boolean fastCapture;

    public CanvasButton(String actionIn, String imageIn, boolean fastCaptureIn) {
        super(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.brainstorm.canvas"), ResourceManager.getImageIcon(imageIn, 30), ResourceManager.getImageIcon(imageIn, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.action = actionIn;
        this.fastCapture = fastCaptureIn;
        this.setPopup(this.createMindMapMenu());
        ServiceManager.getActionManager().hookActionStateListener(actionIn, (JComponent)((Object)this));
    }

    private JPopupMenu createMindMapMenu() {
        JPopupMenu mindMapMenu = CoreUIFactory.createPopupMenu();
        mindMapMenu.setBackground(Color.white);
        mindMapMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#c6c6c6")));
        JLabel empty = new JLabel(ResourceManager.getImageIcon("brainstorm/empty_50px.png", 50));
        this.styleAndListener(empty, "empty");
        JLabel cork = new JLabel(ResourceManager.getImageIcon("brainstorm/corkboard_50px.png", 50));
        this.styleAndListener(cork, "corkboard");
        JLabel minimal = new JLabel(ResourceManager.getImageIcon("brainstorm/minimal_50px.png", 50));
        this.styleAndListener(minimal, "minimal");
        JLabel footer = new JLabel(ResourceManager.getImageIcon("brainstorm/footer_50px.png", 50));
        this.styleAndListener(footer, "footer");
        JLabel ice = new JLabel(ResourceManager.getImageIcon("brainstorm/ice_geom_50px.png", 50));
        this.styleAndListener(ice, "ice_geom");
        JLabel moon = new JLabel(ResourceManager.getImageIcon("brainstorm/moon_50px.png", 50));
        this.styleAndListener(moon, "moon");
        JLabel pattern = new JLabel(ResourceManager.getImageIcon("brainstorm/pattern_50px.png", 50));
        this.styleAndListener(pattern, "pattern");
        JLabel geometry = new JLabel(ResourceManager.getImageIcon("brainstorm/geometry_50px.png", 50));
        this.styleAndListener(geometry, "geometry");
        JLabel embroidery = new JLabel(ResourceManager.getImageIcon("brainstorm/embroidery_50px.png", 50));
        this.styleAndListener(embroidery, "embroidery");
        JLabel flora = new JLabel(ResourceManager.getImageIcon("brainstorm/flora2_50px.png", 50));
        this.styleAndListener(flora, "flora2");
        JLabel symphony = new JLabel(ResourceManager.getImageIcon("brainstorm/symphony_50px.png", 50));
        this.styleAndListener(symphony, "symphony");
        JLabel stardust = new JLabel(ResourceManager.getImageIcon("brainstorm/stardust_50px.png", 50));
        this.styleAndListener(stardust, "stardust");
        JLabel twinkle = new JLabel(ResourceManager.getImageIcon("brainstorm/twinkle_50px.png", 50));
        this.styleAndListener(twinkle, "twinkle2");
        JLabel woodLight = new JLabel(ResourceManager.getImageIcon("brainstorm/wood_light_50px.png", 50));
        this.styleAndListener(woodLight, "wood_light");
        JLabel woodDark = new JLabel(ResourceManager.getImageIcon("brainstorm/wood_dark_50px.png", 50));
        this.styleAndListener(woodDark, "wood_dark");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        if (this.fastCapture) {
            panel.setLayout(new GridLayout(1, 3));
            panel.add(empty);
            panel.add(twinkle);
            panel.add(stardust);
        } else {
            panel.setLayout(new GridLayout(3, 4));
            panel.add(cork);
            panel.add(minimal);
            panel.add(symphony);
            panel.add(flora);
            panel.add(embroidery);
            panel.add(geometry);
            panel.add(pattern);
            panel.add(moon);
            panel.add(ice);
            panel.add(footer);
            panel.add(woodLight);
            panel.add(woodDark);
        }
        mindMapMenu.add(panel);
        return mindMapMenu;
    }

    private void styleAndListener(final JLabel label, final String actionid) {
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        label.setOpaque(true);
        label.setBackground(BACKGROUND_COLOUR);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                label.setBackground(BACKGROUND_COLOUR);
                ServiceManager.getActionManager().runAction(CanvasButton.this.action, new Object[]{actionid});
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(HOVER_BACKGROUND_COLOUR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(BACKGROUND_COLOUR);
            }
        });
    }
}

