/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.brainstorm;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ConvertTypeButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 2258378765351512845L;
    public static final String ACTION_ID = "com.thinkbuzan.apollo.brainstorm.actions.ConvertBrainstormTypeAction";
    private static final String IMAGE_PATH = "brainstorm/convert_type.png";
    private static final String IDEA_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.brainstorm.convertType");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.brainstorm.convertType.description");
    private static final String CONVERT_TO_IDEA = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.brainstorm.convertToIdea");
    private static final String CONVERT_TO_GROUP = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.brainstorm.convertToGroup");
    private static final String CONVERT_TO_LIST = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.brainstorm.convertToList");
    private static final Color BACKGROUND_COLOUR = Color.white;
    private static final Color HOVER_BACKGROUND_COLOUR = Color.decode("#d5e0f2");

    public ConvertTypeButton() {
        super(IDEA_BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setPopup(this.createPopupMenu());
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu mindMapMenu = CoreUIFactory.createPopupMenu();
        mindMapMenu.setBackground(Color.white);
        mindMapMenu.setBorder(BorderFactory.createLineBorder(Color.decode("#c6c6c6")));
        JLabel groupToIdea = this.createLabel(CONVERT_TO_IDEA, ResourceManager.getImageIcon("brainstorm/convert_to_idea.png", 30));
        this.styleAndListener(groupToIdea, "com.thinkbuzan.apollo.brainstorm.actions.ConvertGroupToIdeaAction");
        JLabel listToIdea = this.createLabel(CONVERT_TO_IDEA, ResourceManager.getImageIcon("brainstorm/convert_to_idea.png", 30));
        this.styleAndListener(listToIdea, "com.thinkbuzan.apollo.brainstorm.actions.ConvertListToIdeaAction");
        JLabel ideaToGroup = this.createLabel(CONVERT_TO_GROUP, ResourceManager.getImageIcon("brainstorm/convert_to_group.png", 30));
        this.styleAndListener(ideaToGroup, "com.thinkbuzan.apollo.brainstorm.actions.ConvertIdeaToGroupAction");
        JLabel listToGroup = this.createLabel(CONVERT_TO_GROUP, ResourceManager.getImageIcon("brainstorm/convert_to_group.png", 30));
        this.styleAndListener(listToGroup, "com.thinkbuzan.apollo.brainstorm.actions.ConvertListToGroupAction");
        JLabel ideaToList = this.createLabel(CONVERT_TO_LIST, ResourceManager.getImageIcon("brainstorm/convert_to_list.png", 30));
        this.styleAndListener(ideaToList, "com.thinkbuzan.apollo.brainstorm.actions.ConvertIdeaToListAction");
        JLabel groupToList = this.createLabel(CONVERT_TO_LIST, ResourceManager.getImageIcon("brainstorm/convert_to_list.png", 30));
        this.styleAndListener(groupToList, "com.thinkbuzan.apollo.brainstorm.actions.ConvertGroupToListAction");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(groupToIdea);
        panel.add(listToIdea);
        panel.add(listToGroup);
        panel.add(ideaToGroup);
        panel.add(ideaToList);
        panel.add(groupToList);
        mindMapMenu.add(panel);
        return mindMapMenu;
    }

    private JLabel createLabel(String label, ImageIcon imageIcon) {
        return new JLabel(label, imageIcon, 2){
            private static final long serialVersionUID = -9129212343651634341L;

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setVisible(enabled);
            }
        };
    }

    private void styleAndListener(final JLabel label, final String actionid) {
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        label.setOpaque(true);
        label.setBackground(BACKGROUND_COLOUR);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                label.setBackground(BACKGROUND_COLOUR);
                ServiceManager.getActionManager().runAction(actionid, new Object[0]);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(HOVER_BACKGROUND_COLOUR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(BACKGROUND_COLOUR);
            }
        });
        ServiceManager.getActionManager().hookActionStateListener(actionid, (JComponent)label);
    }
}

