/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.brainstorm;

import com.thinkbuzan.apollo.ui.win.frame.ui.LargeToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.apollo.view.IBrainstormView;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.JComponent;

public class DrawModeButton
extends LargeToggleButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.apollo.brainstorm.actions.ToggleDrawModeAction";
    private static final String IMAGE_PATH = "brainstorm/relationship-pins-30px.png";
    private static final HashMap<UUID, IViewListener> listenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.relationship");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.relationship");

    public DrawModeButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(DrawModeButton.ACTION_ID, new Object[0]);
                DrawModeButton.this.setSelected(!DrawModeButton.this.isSelected());
                return null;
            }
        };
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                DrawModeButton.this.initialise();
            }
        });
        this.setCommand(callable);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!listenerMap.containsKey(editor.getId())) {
                            IViewListener listener = DrawModeButton.this.getListener(editor);
                            editor.addViewTypeListener(listener);
                            listenerMap.put(editor.getId(), listener);
                        }
                        DrawModeButton.this.updateSelection(editor, editor.getView().getId());
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && listenerMap.containsKey(editor.getId())) {
                        editor.removeViewTypeListener((IViewListener)listenerMap.get(editor.getId()));
                        listenerMap.remove(editor.getId());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IViewListener getListener(final IEditorView editor) {
        return new IViewListener(){

            public void viewChanged(String viewID) {
                DrawModeButton.this.updateSelection(editor, viewID);
            }
        };
    }

    private void updateSelection(IEditorView editor, String viewID) {
        if (viewID.equals("com.thinkbuzan.phoenix.view.BrainstormView")) {
            this.setSelected(((IBrainstormView)editor.getView()).isDrawEnabled(editor.getId()));
        }
    }
}

