/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.CustomJMenuItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.DrawTool;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class DrawModeButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String LICENSE_ID = "com.thinkbuzan.license.gaia.freehand";
    private static final String ACTION_ID_BRANCH = "com.thinkbuzan.gaia.actions.SetDrawOrganicAction";
    private static final String ACTION_ID_FREEHAND = "com.thinkbuzan.gaia.actions.SetDrawFreehandAction";
    private static final String IMAGE_PATH_FREEHAND = "design/freehand-30px.png";
    private static final String IMAGE_PATH_BRANCH = "insert/branch-30px.png";
    private static final String BRANCH_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.branch");
    private static final String FREEHAND_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.freehand");
    private static final String TOOL_TIP_TEXT_BRANCH = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.organic.title");
    private static final String TOOL_TIP_TEXT_BRANCH_SWITCH = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.organic.description");
    private static final String TOOL_TIP_TEXT_FREEHAND = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.freehand.title");
    private static final String TOOL_TIP_TEXT_FREEHAND_SWITCH = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.freehand.description");

    public DrawModeButton() {
        super(BRANCH_BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH_BRANCH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH_BRANCH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT_BRANCH);
        this.setPopup(this.createDrawModeMenu());
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID_FREEHAND, (JComponent)((Object)this));
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        if (editor == null) {
                            return;
                        }
                        DrawTool dt = editor.getDrawTool();
                        if (dt != null && dt == DrawTool.FREEHAND) {
                            DrawModeButton.this.setFreehand();
                        } else {
                            DrawModeButton.this.setBranch();
                        }
                    }
                });
            }
        });
    }

    private void setFreehand() {
        this.setIcon(ResourceManager.getImageIcon(IMAGE_PATH_FREEHAND, 30));
        this.setDisabledIcon(ResourceManager.getImageIcon(DISABLED + IMAGE_PATH_FREEHAND, 30));
        this.setText(FREEHAND_BUTTON_TEXT);
        this.setToolTipText(TOOL_TIP_TEXT_FREEHAND);
    }

    private void setBranch() {
        this.setIcon(ResourceManager.getImageIcon(IMAGE_PATH_BRANCH, 30));
        this.setDisabledIcon(ResourceManager.getImageIcon(DISABLED + IMAGE_PATH_BRANCH, 30));
        this.setText(BRANCH_BUTTON_TEXT);
        this.setToolTipText(TOOL_TIP_TEXT_BRANCH);
    }

    private JPopupMenu createDrawModeMenu() {
        JPopupMenu drawModeMenu = new JPopupMenu();
        drawModeMenu.setBackground(Color.white);
        ActionListener freehand = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(DrawModeButton.ACTION_ID_FREEHAND, new Object[0]);
                DrawModeButton.this.setFreehand();
            }
        };
        ActionListener organic = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(DrawModeButton.ACTION_ID_BRANCH, new Object[0]);
                DrawModeButton.this.setBranch();
            }
        };
        CustomJMenuItem branchButton = new CustomJMenuItem(BRANCH_BUTTON_TEXT);
        branchButton.setIcon(ResourceManager.getImageIcon(IMAGE_PATH_BRANCH, 30));
        branchButton.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        branchButton.addActionListener(organic);
        branchButton.setToolTipText(TOOL_TIP_TEXT_BRANCH_SWITCH);
        drawModeMenu.add(branchButton);
        CustomJMenuItem freehandButton = new CustomJMenuItem(FREEHAND_BUTTON_TEXT);
        freehandButton.setIcon(ResourceManager.getImageIcon(IMAGE_PATH_FREEHAND, 30));
        freehandButton.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        freehandButton.addActionListener(freehand);
        freehandButton.setToolTipText(TOOL_TIP_TEXT_FREEHAND_SWITCH);
        drawModeMenu.add(freehandButton);
        return drawModeMenu;
    }

    public String getLicenseId() {
        return LICENSE_ID;
    }
}

