/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design;

import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.ThemePopup;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.entities.FontOption;
import com.thinkbuzan.gaia.theme.listener.ThemeEvent;
import com.thinkbuzan.gaia.theme.listener.ThemesListener;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import java.awt.Component;

public class FontsButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String FONT_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.fonts");
    private static final String IMAGE_PATH = "design/font-15px.png";
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.tooltip.styleFonts");
    private ThemePopup<FontOption> themePopup;

    public FontsButton() {
        super(FONT_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 15), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 15), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.themePopup = new ThemePopup<FontOption>(FontOption.class, ServiceManager.getActionManager());
        this.themePopup.install((Component)((Object)this));
        ServiceManager.addThemeManagerServiceListener(this.createThemeManagerListener());
    }

    private IServiceListener<ThemeManager> createThemeManagerListener() {
        return new IServiceListener<ThemeManager>(){

            public void serviceRemoved(ThemeManager service) {
            }

            public void serviceAdded(final ThemeManager service) {
                FontsButton.this.updateFontOptions(service);
                service.addThemesListener(new ThemesListener(){

                    public void themesChanged(ThemeEvent event) {
                        if (event.getType() == ThemeEvent.ThemeEventType.OPTIONS_CHANGED) {
                            if (event.getOptionClass().equals(FontOption.class)) {
                                FontsButton.this.updateFontOptions(service);
                            }
                        } else if (event.getType() == ThemeEvent.ThemeEventType.OPTIONS_SELECTION_CHANGED && event.getOptionClass().equals(FontOption.class)) {
                            FontsButton.this.updateFontOptionSelection(service);
                        }
                    }
                });
            }
        };
    }

    private void updateFontOptions(ThemeManager service) {
        this.themePopup.populate(service.getFontOptionManager().getOptions());
        this.updateFontOptionSelection(service);
    }

    private void updateFontOptionSelection(ThemeManager service) {
        if (service.getSelectedTheme() == null) {
            this.themePopup.setSelected(null);
        } else {
            FontOption option = service.getSelectedTheme().getFontOption();
            this.themePopup.setSelected(option);
        }
    }
}

