/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design;

import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.ThemePopup;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.entities.GraphicsOption;
import com.thinkbuzan.gaia.theme.listener.ThemeEvent;
import com.thinkbuzan.gaia.theme.listener.ThemesListener;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import java.awt.Component;

public class GraphicsButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String IMAGE_PATH = "design/colours-15px.png";
    private static final String GRAPHICS_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.graphics");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.tooltip.styleGraphics");
    private ThemePopup<GraphicsOption> themePopup;

    public GraphicsButton() {
        super(GRAPHICS_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 15), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 15), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.themePopup = new ThemePopup<GraphicsOption>(GraphicsOption.class, ServiceManager.getActionManager());
        this.themePopup.install((Component)((Object)this));
        ServiceManager.addThemeManagerServiceListener(this.createThemeManagerListener());
    }

    private IServiceListener<ThemeManager> createThemeManagerListener() {
        return new IServiceListener<ThemeManager>(){

            public void serviceRemoved(ThemeManager service) {
            }

            public void serviceAdded(final ThemeManager service) {
                GraphicsButton.this.updateGraphicsOptions(service);
                service.addThemesListener(new ThemesListener(){

                    public void themesChanged(ThemeEvent event) {
                        if (event.getType() == ThemeEvent.ThemeEventType.OPTIONS_CHANGED) {
                            if (event.getOptionClass().equals(GraphicsOption.class)) {
                                GraphicsButton.this.updateGraphicsOptions(service);
                            }
                        } else if (event.getType() == ThemeEvent.ThemeEventType.OPTIONS_SELECTION_CHANGED && event.getOptionClass().equals(GraphicsOption.class)) {
                            GraphicsButton.this.updateGraphicsOptionSelection(service);
                        }
                    }
                });
            }
        };
    }

    private void updateGraphicsOptions(ThemeManager service) {
        this.themePopup.populate(service.getGraphicsOptionManager().getOptions());
        this.updateGraphicsOptionSelection(service);
    }

    private void updateGraphicsOptionSelection(ThemeManager service) {
        if (service.getSelectedTheme() == null) {
            this.themePopup.setSelected(null);
        } else {
            GraphicsOption option = service.getSelectedTheme().getGraphicsOption();
            this.themePopup.setSelected(option);
        }
    }
}

