/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util;

import com.thinkbuzan.gaia.entities.FontOption;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FontOptionIcons {
    private static final int WIDTH = 200;
    private static final int HEIGHT = 40;
    private final transient Map<CacheKey, Icon> cache = new HashMap<CacheKey, Icon>();
    private final Icon emptyIcon;
    private static final transient FontOptionIcons INSTANCE = new FontOptionIcons();

    public static FontOptionIcons getInstance() {
        return INSTANCE;
    }

    private FontOptionIcons() {
        BufferedImage emptyImage = new BufferedImage(200, 40, 6);
        this.emptyIcon = new ImageIcon(emptyImage);
    }

    public Icon getIcon(Object value, Font labelFont, Color foreground) {
        if (value instanceof FontOption) {
            FontOption fontOption = (FontOption)value;
            CacheKey key = new CacheKey(fontOption.getName(), (Font)fontOption.getFont(1), (Font)fontOption.getFont(2));
            Icon icon = this.cache.get(key);
            if (icon == null) {
                icon = this.createIcon(fontOption, labelFont);
                this.cache.put(key, icon);
            }
            this.updateImageColor(icon, foreground);
            return icon;
        }
        return this.emptyIcon;
    }

    private void updateImageColor(Icon icon, Color foreground) {
        BufferedImage image = (BufferedImage)((ImageIcon)icon).getImage();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(foreground);
        graphics.setComposite(AlphaComposite.SrcIn);
        graphics.fillRect(0, 0, 200, 40);
        graphics.dispose();
    }

    private Icon createIcon(FontOption fontOption, Font labelFont) {
        BufferedImage image = new BufferedImage(200, 40, 6);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setFont(labelFont);
        graphics.drawString(fontOption.getName(), 0, 16);
        Font firstFont = fontOption.getFont(1).deriveFont(18.0f);
        graphics.setFont(firstFont);
        graphics.drawString(firstFont.getName(), 0, 35);
        graphics.dispose();
        return new ImageIcon(image);
    }

    private class CacheKey {
        private final transient String name;
        private final transient Font firstFont;
        private final transient Font secondFont;

        public CacheKey(String nameIn, Font firstFontIn, Font secondFontIn) {
            this.name = nameIn;
            this.firstFont = firstFontIn;
            this.secondFont = secondFontIn;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheKey)) {
                return false;
            }
            return ((CacheKey)object).name.equals(this.name) && ((CacheKey)object).firstFont.equals(this.firstFont) && ((CacheKey)object).secondFont.equals(this.secondFont);
        }

        public int hashCode() {
            return this.name.hashCode() + this.firstFont.hashCode() + this.secondFont.hashCode();
        }
    }
}

