/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util;

import com.buzanonline.chaos.action.ActionManager;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.win.component.CustomScrollBarUI;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.DefaultBorder;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.ThemePopupListCellRenderer;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.gaia.entities.ColorOption;
import com.thinkbuzan.gaia.entities.FontOption;
import com.thinkbuzan.gaia.entities.GraphicsOption;
import com.thinkbuzan.gaia.entities.LayoutOption;
import com.thinkbuzan.gaia.entities.Option;
import com.thinkbuzan.gaia.entities.PresentationOption;
import com.thinkbuzan.gaia.entities.Theme;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import com.thinkbuzan.gaia.ui.ButtonPopup;
import com.thinkbuzan.gaia.ui.components.MenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ScrollBarUI;
import org.apache.log4j.Logger;

public class ThemePopup<CLASS> {
    private static final transient Logger LOGGER = Logger.getLogger(ThemePopup.class);
    private static final Dimension CELL_DIMENSION = new Dimension(110, 80);
    private static final int MAX_VISIBLE_ROW_COUNT = 8;
    private final Class<?> clazz;
    private final transient ActionManager actionManager;
    private final transient JList list = new JList();
    private final transient JPanel panel;
    private transient ButtonPopup popup;
    private final transient JPopupMenu rightClickMenu = new JPopupMenu();
    private transient boolean disableSelectionListener;
    private final transient String setActionId;
    private final transient String removeActionId;
    private final transient List<String> namesToIgnore = new ArrayList<String>();
    private final transient String componentsName = UUID.randomUUID().toString();

    public ThemePopup(Class<? extends CLASS> clazzIn, ActionManager actionManagerIn) {
        this.actionManager = actionManagerIn;
        this.clazz = clazzIn;
        this.list.addListSelectionListener(this.createListSelectionListener());
        this.rightClickMenu.setName(this.componentsName);
        this.list.addMouseListener(this.createListMouseListener());
        if (this.clazz == PresentationOption.class) {
            this.removeActionId = "com.thinkbuzan.gaia.actions.DeletePresentationAction";
            this.setActionId = "com.thinkbuzan.gaia.actions.SetCurrentPresentationAction";
        } else {
            this.removeActionId = "com.thinkbuzan.gaia.theme.actions.RemoveThemeOptionByIdAction";
            this.setActionId = "com.thinkbuzan.gaia.theme.actions.SetThemeOptionByIdAction";
        }
        this.panel = this.createPanel(null);
        this.setNamesToIgnore(new ArrayList<String>());
    }

    public ThemePopup(ActionManager actionManagerIn, ThemeManager themeManager) {
        this.actionManager = actionManagerIn;
        this.clazz = Theme.class;
        this.list.setFocusable(false);
        this.list.addListSelectionListener(this.createListSelectionListener());
        this.list.setCellRenderer(new ThemePopupListCellRenderer(this.list, themeManager));
        this.list.setFixedCellHeight((int)CELL_DIMENSION.getHeight());
        this.list.setFixedCellWidth((int)CELL_DIMENSION.getWidth());
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.addMouseListener(this.createListMouseListener());
        this.setActionId = "com.thinkbuzan.gaia.theme.actions.SetThemeByIdAction";
        this.removeActionId = "com.thinkbuzan.gaia.theme.actions.RemoveThemeByIdAction";
        this.panel = this.createPanel(themeManager);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    protected void populateRightClickMenu(Point location) {
        boolean userDefined;
        this.rightClickMenu.removeAll();
        int index = this.list.locationToIndex(location);
        Rectangle cellBounds = this.list.getCellBounds(index, index);
        if (!cellBounds.contains(location)) {
            return;
        }
        Object element = this.list.getModel().getElementAt(index);
        String id = element instanceof Option ? ((Option)element).getUUID().toString() : ((Theme)element).getUUID().toString();
        if (element instanceof Option) {
            userDefined = ((Option)element).isUserDefined();
        } else if (element instanceof Theme) {
            userDefined = ((Theme)element).isUserDefined();
        } else {
            return;
        }
        if (element instanceof Theme) {
            MenuItem setDefaultItem = new MenuItem(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles.setAsDefault"), "com.thinkbuzan.gaia.theme.actions.SetDefaultThemeByIdAction", (Icon)null, (Icon)null, this.actionManager, new Object[]{id});
            this.rightClickMenu.add((JMenuItem)setDefaultItem);
            JSeparator separator = new JSeparator();
            this.rightClickMenu.add(separator);
        }
        MenuItem removeItem = new MenuItem(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.remove"), this.removeActionId, (Icon)null, (Icon)null, this.actionManager, new Object[]{id});
        this.rightClickMenu.add((JMenuItem)removeItem);
        removeItem.setEnabled(userDefined);
    }

    private MouseListener createListMouseListener() {
        return new MouseAdapter(){
            private transient boolean hasPopped;

            @Override
            public void mousePressed(MouseEvent event) {
                this.maybePopup(event);
                this.hasPopped = event.isPopupTrigger();
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                this.maybePopup(event);
                this.hasPopped |= event.isPopupTrigger();
                if (!this.hasPopped) {
                    ThemePopup.this.safePopupHide();
                }
            }

            private void maybePopup(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    ThemePopup.this.populateRightClickMenu(event.getPoint());
                    ThemePopup.this.rightClickMenu.show(ThemePopup.this.list, event.getX(), event.getY());
                }
            }
        };
    }

    private ActionListener createMenuItemActionListener(final String actionId) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThemePopup.this.actionManager.runAction(actionId, new Object[0]);
                ThemePopup.this.safePopupHide();
            }
        };
    }

    private void safePopupHide() {
        if (this.popup == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Did not expect popup not be null");
            }
        } else {
            this.popup.hide();
        }
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (ThemePopup.this.disableSelectionListener) {
                    return;
                }
                if (event.getValueIsAdjusting()) {
                    return;
                }
                ThemePopup.this.runSetAction();
            }
        };
    }

    private void runSetAction() {
        Object selected = this.list.getSelectedValue();
        if (selected instanceof Theme) {
            this.actionManager.runAction(this.setActionId, new Object[]{((Theme)selected).getUUID().toString()});
        } else if (selected instanceof Option) {
            this.actionManager.runAction(this.setActionId, new Object[]{((Option)selected).getUUID().toString()});
        }
        this.safePopupHide();
    }

    private JPanel createPanel(ThemeManager themeManager) {
        JPanel thePanel = new JPanel(new GridBagLayout());
        thePanel.setBackground(Color.WHITE);
        thePanel.setName(this.componentsName);
        if (SystemInfo.isWindows()) {
            thePanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        }
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new CustomScrollBarUI());
        scrollPane.setBorder(null);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        if (this.clazz == Theme.class) {
            thePanel.add((Component)this.createLabelPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles"), 0), constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        thePanel.add((Component)scrollPane, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        thePanel.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        BottomButton menuItem = this.createBottomButton();
        thePanel.add((Component)menuItem, constraints);
        return thePanel;
    }

    private BottomButton createBottomButton() {
        String menuItemText;
        String menuItemActionId;
        if (ColorOption.class.equals(this.clazz)) {
            this.list.setCellRenderer(new ThemePopupListCellRenderer<ColorOption>(this.list, ColorOption.class));
            menuItemActionId = "com.thinkbuzan.gaia.theme.actions.ShowColorOptionsDialogAction";
            menuItemText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseColours") + "...";
        } else if (FontOption.class.equals(this.clazz)) {
            this.list.setCellRenderer(new ThemePopupListCellRenderer<FontOption>(this.list, FontOption.class));
            menuItemActionId = "com.thinkbuzan.gaia.theme.actions.ShowFontOptionsDialogAction";
            menuItemText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseFonts") + "...";
        } else if (GraphicsOption.class.equals(this.clazz)) {
            this.list.setCellRenderer(new ThemePopupListCellRenderer<GraphicsOption>(this.list, GraphicsOption.class));
            menuItemActionId = "com.thinkbuzan.gaia.theme.actions.ShowGraphicsOptionsDialogAction";
            menuItemText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseGraphics") + "...";
        } else if (LayoutOption.class.equals(this.clazz)) {
            this.list.setCellRenderer(new ThemePopupListCellRenderer<LayoutOption>(this.list, LayoutOption.class));
            menuItemActionId = "com.thinkbuzan.gaia.theme.actions.ShowLayoutOptionsDialogAction";
            menuItemText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseLayout") + "...";
        } else if (PresentationOption.class.equals(this.clazz)) {
            this.list.setCellRenderer(new ThemePopupListCellRenderer<PresentationOption>(this.list, PresentationOption.class));
            menuItemActionId = "com.thinkbuzan.gaia.actions.NewPresentationAction";
            menuItemText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.presentation.builder.createNewPresentation");
        } else {
            List<Class> validClasses = Arrays.asList(ColorOption.class, FontOption.class, GraphicsOption.class, LayoutOption.class);
            throw new IllegalArgumentException(String.format("clazz=%s must be one of %s", this.clazz, validClasses));
        }
        BottomButton menuItem = new BottomButton(menuItemText, this.list.getSelectionBackground());
        menuItem.setBackground(Color.WHITE);
        menuItem.setFont(new JLabel().getFont());
        menuItem.addActionListener(this.createMenuItemActionListener(menuItemActionId));
        if (SystemInfo.isWindows()) {
            menuItem.setContentAreaFilled(false);
        }
        return menuItem;
    }

    private JPanel createLabelPanel(String text, int verticalPadding) {
        JPanel currentStyleLabelPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        currentStyleLabelPanel.setBackground(Color.WHITE);
        Component verticalStrut = Box.createVerticalStrut(verticalPadding);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        currentStyleLabelPanel.add(verticalStrut, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        if (text == null || text.equals("")) {
            constraints.weightx = 1.0;
            currentStyleLabelPanel.add((Component)new JSeparator(), constraints);
        } else {
            constraints.insets = new Insets(0, 0, 0, 4);
            constraints.weightx = 0.0;
            constraints.fill = 2;
            JSeparator separator = new JSeparator();
            separator.setPreferredSize(new Dimension(24, separator.getPreferredSize().height));
            currentStyleLabelPanel.add((Component)separator, constraints);
            constraints.gridx = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            currentStyleLabelPanel.add((Component)new JLabel(text), constraints);
            constraints.gridx = 2;
            constraints.insets = new Insets(0, 4, 0, 0);
            constraints.weightx = 1.0;
            currentStyleLabelPanel.add((Component)new JSeparator(), constraints);
        }
        return currentStyleLabelPanel;
    }

    public String getName() {
        return this.componentsName;
    }

    public void install(Component button) {
        this.install(button, false);
    }

    public void install(Component button, boolean centerX) {
        this.popup = new ButtonPopup(button, (JComponent)this.panel, centerX);
        this.popup.setPopupMenuToIgnore(this.rightClickMenu);
        this.popup.setNamesToIgnore(this.namesToIgnore);
        button.addMouseListener(this.popup.getMouseListener());
        if (SystemInfo.isMacOSX() && this.clazz == Theme.class) {
            this.popup.setOffset(5, -23);
        }
    }

    public void populate(List<CLASS> options) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("populate(options=%s)", options));
        }
        this.list.setModel(this.createListModel(options));
        int visibleRowCount = this.clazz == Theme.class ? 0 : Math.min(options.size(), 8);
        this.list.setVisibleRowCount(visibleRowCount);
        this.list.validate();
    }

    private DefaultListModel createListModel(List<CLASS> list) {
        DefaultListModel<CLASS> model = new DefaultListModel<CLASS>();
        for (CLASS element : list) {
            model.addElement(element);
        }
        return model;
    }

    public CLASS getSelected() {
        return (CLASS)this.list.getSelectedValue();
    }

    public void setSelected(CLASS option) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("setSelected(option=%s)", option));
        }
        Object newSelectedValue = null;
        UUID id = this.getUUID(option);
        if (id != null) {
            ListModel listModel = this.list.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object element = listModel.getElementAt(i);
                UUID elementId = this.getUUID(element);
                if (elementId == null) {
                    LOGGER.error((Object)"Did not expect elementId to be null");
                    continue;
                }
                if (!id.equals(elementId)) continue;
                newSelectedValue = element;
                break;
            }
        }
        this.disableSelectionListener = true;
        this.list.setSelectedValue(newSelectedValue, true);
        if (newSelectedValue == null) {
            this.list.clearSelection();
        }
        this.disableSelectionListener = false;
    }

    private UUID getUUID(Object object) {
        UUID id = null;
        if (object instanceof Option) {
            id = ((Option)object).getUUID();
        } else if (object instanceof Theme) {
            id = ((Theme)object).getUUID();
        }
        return id;
    }

    public void setNamesToIgnore(List<String> namesToIgnoreIn) {
        this.namesToIgnore.clear();
        this.namesToIgnore.addAll(namesToIgnoreIn);
        this.namesToIgnore.add(this.getName());
    }

    private static class BottomButton
    extends JButton {
        private static final long serialVersionUID = 1107861891593384091L;
        private final transient Border osxPainter;
        private transient boolean hover;
        private final transient Color hoverColor;
        private final transient Color defaultColor;

        public BottomButton(String text, Color color) {
            this.hoverColor = color;
            this.defaultColor = this.getBackground();
            this.osxPainter = new DefaultBorder(this.hoverColor);
            this.setText(text);
            this.setBorder(null);
            this.setBorderPainted(false);
            this.setHorizontalAlignment(10);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent event) {
                    BottomButton.this.setHover(true);
                }

                @Override
                public void mouseExited(MouseEvent event) {
                    BottomButton.this.setHover(false);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BottomButton.this.setHover(false);
                }
            });
            this.setBorder(BorderFactory.createEmptyBorder(1, 23, 1, 5));
        }

        public void setHover(boolean hoverIn) {
            this.hover = hoverIn;
            if (SystemInfo.isAnyMac()) {
                if (this.hover) {
                    this.setForeground(Color.WHITE);
                } else {
                    this.setForeground(Color.BLACK);
                }
            } else if (SystemInfo.isLinux()) {
                if (this.hover) {
                    this.setBackground(this.hoverColor);
                } else {
                    this.setBackground(this.defaultColor);
                }
            }
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.hover && this.osxPainter != null) {
                this.osxPainter.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
        }
    }
}

