/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util;

import com.thinkbuzan.apollo.ui.core.RetinaIcon;
import com.thinkbuzan.apollo.ui.core.win.component.ColourOptionIcons;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.DefaultBorder;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.design.util.FontOptionIcons;
import com.thinkbuzan.gaia.entities.ColorOption;
import com.thinkbuzan.gaia.entities.FontOption;
import com.thinkbuzan.gaia.entities.GraphicsOption;
import com.thinkbuzan.gaia.entities.LayoutOption;
import com.thinkbuzan.gaia.entities.PresentationOption;
import com.thinkbuzan.gaia.entities.Theme;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ThemePopupListCellRenderer<CLASS>
extends DefaultListCellRenderer {
    private static final String TICK = "\u2713";
    private static final long serialVersionUID = -2002869916217345731L;
    private final transient Class<? extends CLASS> clazz;
    private final transient JList list;
    private final transient ThemeManager themeManager;
    private final transient Border hoverPainter;
    private transient boolean paintHover;
    private transient boolean paintTick;
    private transient int hoverIndex = -1;
    private transient int lastHoverIndex;
    private transient int selectedIndex;

    public ThemePopupListCellRenderer(JList listIn, Class<? extends CLASS> clazzIn) {
        this.list = listIn;
        this.hoverPainter = new DefaultBorder(this.list.getSelectionBackground());
        this.clazz = clazzIn;
        this.themeManager = null;
        this.addListListeners(this.list);
        this.lastHoverIndex = listIn.getSelectedIndex();
        this.setOpaque(false);
    }

    public ThemePopupListCellRenderer(JList listIn, ThemeManager themeManagerIn) {
        this.list = listIn;
        this.hoverPainter = new DefaultBorder(this.list.getSelectionBackground());
        this.clazz = null;
        this.themeManager = themeManagerIn;
        this.addListListeners(this.list);
        this.lastHoverIndex = listIn.getSelectedIndex();
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setOpaque(false);
    }

    private void addListListeners(final JList listIn) {
        listIn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent event) {
                ThemePopupListCellRenderer.this.listMouseExited();
            }
        });
        listIn.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                ThemePopupListCellRenderer.this.listMouseMoved(event);
            }
        });
        listIn.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ThemePopupListCellRenderer.this.listValueChanged(listIn, event);
            }
        });
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.paintHover = index == this.hoverIndex;
        this.paintTick = index == this.selectedIndex;
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (ColorOption.class.equals(this.clazz)) {
            this.colorOption(value);
        } else if (FontOption.class.equals(this.clazz)) {
            this.fontOption(value, index);
        } else if (GraphicsOption.class.equals(this.clazz)) {
            this.graphicsOption(value);
        } else if (LayoutOption.class.equals(this.clazz)) {
            this.layoutOption(value);
        } else if (PresentationOption.class.equals(this.clazz)) {
            this.presentationOption(value);
        } else if (this.clazz == null) {
            this.theme(value, index, isSelected, cellHasFocus);
        }
        this.setBackground(list.getBackground());
        if (this.paintHover) {
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
        }
        return this;
    }

    private void theme(Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof Theme)) {
            return;
        }
        Theme theme = (Theme)value;
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)this.list, value, index, isSelected, cellHasFocus);
        label.setIcon((Icon)new RetinaIcon((Image)this.themeManager.getThumbnail(theme, false), (Image)this.themeManager.getThumbnail(theme, true)));
        label.setText(theme.getName());
    }

    private void presentationOption(Object value) {
        String text;
        if (value instanceof PresentationOption) {
            PresentationOption option = (PresentationOption)value;
            text = option.getName();
        } else {
            text = null;
        }
        this.setText(text);
    }

    private void layoutOption(Object value) {
        String text;
        if (value instanceof LayoutOption) {
            LayoutOption option = (LayoutOption)value;
            text = option.getName();
        } else {
            text = null;
        }
        this.setText(text);
    }

    private void graphicsOption(Object value) {
        String text;
        if (value instanceof GraphicsOption) {
            GraphicsOption option = (GraphicsOption)value;
            text = option.getName();
        } else {
            text = null;
        }
        this.setText(text);
    }

    private void fontOption(Object value, int index) {
        this.setText(null);
        if (this.paintHover) {
            this.setForeground(this.list.getSelectionForeground());
        } else {
            this.setForeground(this.list.getForeground());
        }
        Color foreground = index == -1 ? this.list.getForeground() : this.getForeground();
        Icon icon = FontOptionIcons.getInstance().getIcon(value, this.getFont(), foreground);
        if (value instanceof FontOption && index == -1) {
            FontOption option = (FontOption)value;
            this.setText(option.getName());
            this.setIcon(null);
        } else {
            this.setText(null);
            this.setIcon(icon);
        }
    }

    private void colorOption(Object value) {
        if (value instanceof ColorOption) {
            ColorOption option = (ColorOption)value;
            this.setText(option.getName());
            this.setIcon(ColourOptionIcons.getInstance().getIcon(option.getColors()));
        } else {
            this.setText(" ");
        }
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets localInsets = insets;
        if (insets == null) {
            localInsets = new Insets(0, 0, 0, 0);
        }
        if (this.clazz == null) {
            localInsets.top = 1;
            localInsets.bottom = 1;
            localInsets.right = 7;
            localInsets.left = 7;
        } else {
            localInsets.top = 1;
            localInsets.bottom = 1;
            localInsets.right = 5;
            localInsets.left = 23;
        }
        return localInsets;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.paintHover && this.hoverPainter != null) {
            this.hoverPainter.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
        if (this.paintTick) {
            int i = 13;
            Font oldFont = graphics.getFont();
            graphics.setFont(ApplicationFont.getSafeFont((int)0, (float)12.0f));
            graphics.setColor(this.getForeground());
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawString(TICK, 6, 13);
            graphics.setFont(oldFont);
        }
        super.paintComponent(graphics);
    }

    private void listMouseMoved(MouseEvent event) {
        this.hoverIndex = this.list.locationToIndex(event.getPoint());
        Rectangle cellBounds = this.list.getCellBounds(this.hoverIndex, this.hoverIndex);
        if (cellBounds != null && !cellBounds.contains(event.getPoint())) {
            this.hoverIndex = -1;
        }
        if (this.lastHoverIndex == this.hoverIndex) {
            return;
        }
        Rectangle lastCellBounds = this.list.getCellBounds(this.lastHoverIndex, this.lastHoverIndex);
        if (lastCellBounds != null) {
            this.list.repaint(lastCellBounds);
        }
        if (cellBounds != null) {
            this.list.repaint(cellBounds);
        }
        this.lastHoverIndex = this.hoverIndex;
    }

    private void listMouseExited() {
        this.lastHoverIndex = -1;
        this.hoverIndex = -1;
        this.list.repaint();
    }

    private void listValueChanged(JList listIn, ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.selectedIndex = listIn.getSelectedIndex();
    }

    public void setPaintHover(boolean paintHoverIn) {
        this.paintHover = paintHoverIn;
    }
}

