/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.fastcapture;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.orion.view.IFastCaptureView;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class ToggleEdgeShapeButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.orion.fastcapture.actions.ToggleEdgeShapeAction";
    private static final String IMAGE_PATH = "fastcapture/curve.png";
    private static final String IMAGE_PATH_OFF = "fastcapture/straight.png";
    private static final HashMap<UUID, IViewListener> listenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.fastcapture.connector.togglestyle");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.fastcapture.connector.togglestyle");
    private transient boolean selected;

    public ToggleEdgeShapeButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setEnabled(false);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(ToggleEdgeShapeButton.ACTION_ID, new Object[0]);
                ToggleEdgeShapeButton.this.setIcon(!ToggleEdgeShapeButton.this.selected);
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                ToggleEdgeShapeButton.this.initialise();
            }
        });
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!listenerMap.containsKey(editor.getId())) {
                            IViewListener listener = ToggleEdgeShapeButton.this.getListener(editor);
                            editor.addViewTypeListener(listener);
                            listenerMap.put(editor.getId(), listener);
                        }
                        ToggleEdgeShapeButton.this.updateSelection(editor, editor.getView().getId());
                        ToggleEdgeShapeButton.this.setEnabled(true);
                    } else {
                        ToggleEdgeShapeButton.this.setEnabled(false);
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && listenerMap.containsKey(editor.getId())) {
                        editor.removeViewTypeListener((IViewListener)listenerMap.get(editor.getId()));
                        listenerMap.remove(editor.getId());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIcon(final boolean flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToggleEdgeShapeButton.this.selected = flag;
                    if (flag) {
                        ToggleEdgeShapeButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleEdgeShapeButton.IMAGE_PATH, 30));
                    } else {
                        ToggleEdgeShapeButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleEdgeShapeButton.IMAGE_PATH_OFF, 30));
                    }
                }
            });
        }
    }

    private IViewListener getListener(final IEditorView editor) {
        return new IViewListener(){

            public void viewChanged(String viewID) {
                ToggleEdgeShapeButton.this.updateSelection(editor, viewID);
            }
        };
    }

    private void updateSelection(IEditorView editor, String viewID) {
        if (viewID.equals("com.thinkbuzan.phoenix.view.FastCaptureView")) {
            this.setIcon(((IFastCaptureView)editor.getView()).isEdgesCurved(editor.getId()));
        }
    }
}

